/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.daisy.common.xproc.XProcOptionInfo;
import org.daisy.common.xproc.XProcPortInfo;

public final class XProcPipelineInfo {
    private final URI uri;
    private final Map<String, XProcPortInfo> inputPorts;
    private final Map<String, XProcPortInfo> parameterPorts;
    private final Map<String, XProcPortInfo> outputPorts;
    private final Map<QName, XProcOptionInfo> options;

    private XProcPipelineInfo(URI uri, Map<String, XProcPortInfo> inputPorts, Map<String, XProcPortInfo> parameterPorts, Map<String, XProcPortInfo> outputPorts, Map<QName, XProcOptionInfo> options) {
        this.uri = uri;
        this.inputPorts = ImmutableMap.copyOf(inputPorts);
        this.parameterPorts = ImmutableMap.copyOf(parameterPorts);
        this.outputPorts = ImmutableMap.copyOf(outputPorts);
        this.options = ImmutableMap.copyOf(options);
    }

    public URI getURI() {
        return this.uri;
    }

    public Iterable<XProcPortInfo> getInputPorts() {
        return this.inputPorts.values();
    }

    public XProcPortInfo getInputPort(String name) {
        return this.inputPorts.get(name);
    }

    public Iterable<XProcOptionInfo> getOptions() {
        return this.options.values();
    }

    public XProcOptionInfo getOption(QName name) {
        return this.options.get(name);
    }

    public Iterable<XProcPortInfo> getOutputPorts() {
        return this.outputPorts.values();
    }

    public XProcPortInfo getOutputPort(String name) {
        return this.outputPorts.get(name);
    }

    public Iterable<String> getParameterPorts() {
        return this.parameterPorts.keySet();
    }

    public static final class Builder {
        private URI uri;
        private final Map<String, XProcPortInfo> inputPorts = Maps.newHashMap();
        private final Map<String, XProcPortInfo> parameterPorts = Maps.newHashMap();
        private final Map<String, XProcPortInfo> outputPorts = Maps.newHashMap();
        private final Map<QName, XProcOptionInfo> options = Maps.newLinkedHashMap();

        public Builder withURI(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withPort(XProcPortInfo port) {
            switch (port.getKind()) {
                case INPUT: {
                    this.inputPorts.put(port.getName(), port);
                    break;
                }
                case OUTPUT: {
                    this.outputPorts.put(port.getName(), port);
                    break;
                }
                case PARAMETER: {
                    this.parameterPorts.put(port.getName(), port);
                }
            }
            return this;
        }

        public Builder withOption(XProcOptionInfo option) {
            this.options.put(option.getName(), option);
            return this;
        }

        public final XProcPipelineInfo build() {
            return new XProcPipelineInfo(this.uri, this.inputPorts, this.parameterPorts, this.outputPorts, this.options);
        }
    }
}

