/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public class InputStreamIterator
implements Iterator<Byte> {
    private static final int BUFFER_SIZE = 131072;
    private final InputStream in;
    private final byte[] buffer = new byte[131072];
    private int read;
    private int index;
    private boolean isClosed;
    private final Consumer<IOException> ifFails;

    protected InputStreamIterator(InputStream in, Consumer<IOException> ifFails) {
        this.in = Objects.requireNonNull(in);
        this.ifFails = ifFails;
    }

    public InputStreamIterator(Path in, Consumer<IOException> ifFails) {
        this(InputStreamIterator.silenceException(in), ifFails);
    }

    public InputStreamIterator(URL in, Consumer<IOException> ifFails) {
        this(InputStreamIterator.silenceException(in), ifFails);
    }

    public InputStreamIterator(File in, Consumer<IOException> ifFails) {
        this(in.toPath(), ifFails);
    }

    private static InputStream silenceException(Path p) {
        try {
            return Files.newInputStream(p, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static InputStream silenceException(URL in) {
        try {
            return in.openStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void readNext() {
        if (!this.isClosed) {
            try {
                this.read = this.in.read(this.buffer);
                if (this.read < 131072) {
                    this.isClosed = true;
                    this.in.close();
                }
            }
            catch (IOException e) {
                this.ifFails.accept(e);
            }
        } else {
            this.read = -1;
        }
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.index == this.read) {
            this.readNext();
        }
        return this.read != -1;
    }

    @Override
    public Byte next() {
        if (this.index < this.read) {
            return this.buffer[this.index++];
        }
        throw new NoSuchElementException();
    }
}

