/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.util.stream;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.danilopianini.util.InputStreamIterator;

public final class Streams {
    private Streams() {
    }

    public static Stream<Byte> fileToByteStream(File in, Consumer<IOException> onFailure) {
        return Streams.iteratorToStream(new InputStreamIterator(in, onFailure));
    }

    public static Stream<Byte> fileToByteStream(Path in, Consumer<IOException> onFailure) {
        return Streams.iteratorToStream(new InputStreamIterator(in, onFailure));
    }

    public static Stream<Byte> fileToByteStream(URL in, Consumer<IOException> onFailure) {
        return Streams.iteratorToStream(new InputStreamIterator(in, onFailure));
    }

    public static <E> Stream<E> flatten(E target, Function<? super E, ? extends Stream<? extends E>> extractor) {
        return Stream.concat(Stream.of(target), extractor.apply(target).flatMap(el -> Streams.flatten(el, extractor)));
    }

    public static <T> Stream<T> iteratorToStream(Iterator<T> in) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(in, 16), false);
    }
}

