/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.gradle.gitsemver;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.danilopianini.gradle.gitsemver.SemanticVersion;
import org.danilopianini.gradle.gitsemver.UpdateType;
import org.danilopianini.gradle.gitsemver.source.GitCommandValueSource;
import org.danilopianini.gradle.gitsemver.source.Parameters;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 I2\u00020\u0001:\u0001IB\u00b5\u0002\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u0012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f\u0012\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u0012\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u0012\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f\u0012\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u0012\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u001a\b\u0002\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0004\b#\u0010$J \u00108\u001a\u0002092\u0018\u0010:\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0!\u0012\u0004\u0012\u00020\"0 J\b\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u0004\u0018\u00010<J\u0006\u0010>\u001a\u00020\u000bJ\u0006\u0010?\u001a\u000209J\u0006\u0010@\u001a\u000209J#\u0010A\u001a\u0004\u0018\u00010\u000b2\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0C\"\u00020\u000bH\u0004\u00a2\u0006\u0002\u0010DJ#\u0010E\u001a\u0004\u0018\u00010\u000b2\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0C\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010DJ'\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000b0G2\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0C\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010HR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010&R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010&R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010&R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010&R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010&R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010&R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010&R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010&R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010&R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010&R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010&R \u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0!\u0012\u0004\u0012\u00020\"0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u00104\u001a$\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b06\u00a2\u0006\u0002\b7\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b705X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/danilopianini/gradle/gitsemver/GitSemVerExtension;", "", "project", "Lorg/gradle/api/Project;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "projectDir", "Ljava/io/File;", "version", "", "logger", "Lorg/slf4j/Logger;", "minimumVersion", "Lorg/gradle/api/provider/Property;", "developmentIdentifier", "noTagIdentifier", "fullHash", "", "maxVersionLength", "", "developmentCounterLength", "enforceSemanticVersioning", "computeReleaseVersion", "preReleaseSeparator", "buildMetadataSeparator", "distanceCounterRadix", "versionPrefix", "includeLightweightTags", "forceVersionPropertyName", "updateStrategy", "Lkotlin/Function1;", "", "Lorg/danilopianini/gradle/gitsemver/UpdateType;", "<init>", "(Lorg/gradle/api/Project;Lorg/gradle/api/provider/ProviderFactory;Lorg/gradle/api/model/ObjectFactory;Ljava/io/File;Ljava/lang/String;Lorg/slf4j/Logger;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Property;Lkotlin/jvm/functions/Function1;)V", "getMinimumVersion", "()Lorg/gradle/api/provider/Property;", "getDevelopmentIdentifier", "getNoTagIdentifier", "getFullHash", "getMaxVersionLength", "getDevelopmentCounterLength", "getEnforceSemanticVersioning", "getComputeReleaseVersion", "getPreReleaseSeparator", "getBuildMetadataSeparator", "getDistanceCounterRadix", "getVersionPrefix", "getIncludeLightweightTags", "getForceVersionPropertyName", "versions", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lkotlin/Pair;", "Lkotlin/jvm/internal/EnhancedNullability;", "commitNameBasedUpdateStrategy", "", "strategy", "computeMinVersion", "Lorg/danilopianini/gradle/gitsemver/SemanticVersion;", "findClosestTag", "computeVersion", "assignGitSemanticVersion", "excludeLightweightTags", "runCommand", "cmd", "", "([Ljava/lang/String;)Ljava/lang/String;", "processCommand", "createValueSourceProvider", "Lorg/gradle/api/provider/Provider;", "([Ljava/lang/String;)Lorg/gradle/api/provider/Provider;", "Companion", "git-sensitive-semantic-versioning-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGitSemVerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSemVerExtension.kt\norg/danilopianini/gradle/gitsemver/GitSemVerExtension\n+ 2 GitSemVerExtension.kt\norg/danilopianini/gradle/gitsemver/GitSemVerExtension$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,296:1\n285#2:297\n285#2:299\n285#2:301\n285#2:303\n285#2:305\n285#2:307\n285#2:309\n285#2:311\n285#2:313\n285#2:315\n285#2:317\n285#2:319\n285#2:321\n285#2:323\n1#3:298\n1#3:300\n1#3:302\n1#3:304\n1#3:306\n1#3:308\n1#3:310\n1#3:312\n1#3:314\n1#3:316\n1#3:318\n1#3:320\n1#3:322\n1#3:324\n1#3:327\n37#4,2:325\n*S KotlinDebug\n*F\n+ 1 GitSemVerExtension.kt\norg/danilopianini/gradle/gitsemver/GitSemVerExtension\n*L\n51#1:297\n52#1:299\n53#1:301\n54#1:303\n55#1:305\n56#1:307\n57#1:309\n58#1:311\n59#1:313\n60#1:315\n61#1:317\n62#1:319\n63#1:321\n64#1:323\n51#1:298\n52#1:300\n53#1:302\n54#1:304\n55#1:306\n56#1:308\n57#1:310\n58#1:312\n59#1:314\n60#1:316\n61#1:318\n62#1:320\n63#1:322\n64#1:324\n136#1:325,2\n*E\n"})
public class GitSemVerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProviderFactory providerFactory;
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final File projectDir;
    @NotNull
    private final String version;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Property<String> minimumVersion;
    @NotNull
    private final Property<String> developmentIdentifier;
    @NotNull
    private final Property<String> noTagIdentifier;
    @NotNull
    private final Property<Boolean> fullHash;
    @NotNull
    private final Property<Integer> maxVersionLength;
    @NotNull
    private final Property<Integer> developmentCounterLength;
    @NotNull
    private final Property<Boolean> enforceSemanticVersioning;
    @NotNull
    private final Property<Boolean> computeReleaseVersion;
    @NotNull
    private final Property<String> preReleaseSeparator;
    @NotNull
    private final Property<String> buildMetadataSeparator;
    @NotNull
    private final Property<Integer> distanceCounterRadix;
    @NotNull
    private final Property<String> versionPrefix;
    @NotNull
    private final Property<Boolean> includeLightweightTags;
    @NotNull
    private final Property<String> forceVersionPropertyName;
    @NotNull
    private Function1<? super List<String>, ? extends UpdateType> updateStrategy;
    @NotNull
    private final LoadingCache<Pair<String, String>, String> versions;
    @NotNull
    public static final String EXTENSION_NAME = "gitSemVer";
    private static final int DEFAULT_RADIX = 36;

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning, @NotNull Property<Boolean> computeReleaseVersion, @NotNull Property<String> preReleaseSeparator, @NotNull Property<String> buildMetadataSeparator, @NotNull Property<Integer> distanceCounterRadix, @NotNull Property<String> versionPrefix, @NotNull Property<Boolean> includeLightweightTags, @NotNull Property<String> forceVersionPropertyName, @NotNull Function1<? super List<String>, ? extends UpdateType> updateStrategy) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        Intrinsics.checkNotNullParameter(computeReleaseVersion, (String)"computeReleaseVersion");
        Intrinsics.checkNotNullParameter(preReleaseSeparator, (String)"preReleaseSeparator");
        Intrinsics.checkNotNullParameter(buildMetadataSeparator, (String)"buildMetadataSeparator");
        Intrinsics.checkNotNullParameter(distanceCounterRadix, (String)"distanceCounterRadix");
        Intrinsics.checkNotNullParameter(versionPrefix, (String)"versionPrefix");
        Intrinsics.checkNotNullParameter(includeLightweightTags, (String)"includeLightweightTags");
        Intrinsics.checkNotNullParameter(forceVersionPropertyName, (String)"forceVersionPropertyName");
        Intrinsics.checkNotNullParameter(updateStrategy, (String)"updateStrategy");
        this.project = project;
        this.providerFactory = providerFactory;
        this.objectFactory = objectFactory;
        this.projectDir = projectDir;
        this.version = version;
        this.logger = logger;
        this.minimumVersion = minimumVersion;
        this.developmentIdentifier = developmentIdentifier;
        this.noTagIdentifier = noTagIdentifier;
        this.fullHash = fullHash;
        this.maxVersionLength = maxVersionLength;
        this.developmentCounterLength = developmentCounterLength;
        this.enforceSemanticVersioning = enforceSemanticVersioning;
        this.computeReleaseVersion = computeReleaseVersion;
        this.preReleaseSeparator = preReleaseSeparator;
        this.buildMetadataSeparator = buildMetadataSeparator;
        this.distanceCounterRadix = distanceCounterRadix;
        this.versionPrefix = versionPrefix;
        this.includeLightweightTags = includeLightweightTags;
        this.forceVersionPropertyName = forceVersionPropertyName;
        this.updateStrategy = updateStrategy;
        Caffeine caffeine = Caffeine.newBuilder();
        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        LoadingCache loadingCache = caffeine.expireAfterAccess(duration).build(new CacheLoader(this){
            final /* synthetic */ GitSemVerExtension this$0;
            {
                this.this$0 = $receiver;
            }

            public final String load(Pair<String, String> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<unused var>");
                return this.this$0.computeVersion();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.versions = loadingCache;
    }

    public /* synthetic */ GitSemVerExtension(Project project, ProviderFactory providerFactory, ObjectFactory objectFactory, File file, String string, Logger logger, Property property, Property property2, Property property3, Property property4, Property property5, Property property6, Property property7, Property property8, Property property9, Property property10, Property property11, Property property12, Property property13, Property property14, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Companion this_$iv;
        boolean bl;
        Property $this$propertyWithDefault_u24lambda_u240$iv;
        ObjectFactory $this$propertyWithDefault$iv;
        Property property15;
        boolean $i$f$propertyWithDefault;
        Object default$iv;
        if ((n & 0x40) != 0) {
            Companion companion = Companion;
            ObjectFactory objectFactory2 = objectFactory;
            default$iv = "0.1.0";
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(String.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property16 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property16, (String)"apply(...)");
            property = property16;
        }
        if ((n & 0x80) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = "dev";
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(String.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property17 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property17, (String)"apply(...)");
            property2 = property17;
        }
        if ((n & 0x100) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = "archeo";
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(String.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property18 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property18, (String)"apply(...)");
            property3 = property18;
        }
        if ((n & 0x200) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = false;
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(Boolean.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property19 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property19, (String)"apply(...)");
            property4 = property19;
        }
        if ((n & 0x400) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = Integer.MAX_VALUE;
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(Integer.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property20 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property20, (String)"apply(...)");
            property5 = property20;
        }
        if ((n & 0x800) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = 2;
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(Integer.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property21 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property21, (String)"apply(...)");
            property6 = property21;
        }
        if ((n & 0x1000) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = true;
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(Boolean.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property22 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property22, (String)"apply(...)");
            property7 = property22;
        }
        if ((n & 0x2000) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = false;
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(Boolean.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property23 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property23, (String)"apply(...)");
            property8 = property23;
        }
        if ((n & 0x4000) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = "-";
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(String.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property24 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property24, (String)"apply(...)");
            property9 = property24;
        }
        if ((n & 0x8000) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = "+";
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(String.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property25 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property25, (String)"apply(...)");
            property10 = property25;
        }
        if ((n & 0x10000) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = 36;
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(Integer.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property26 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property26, (String)"apply(...)");
            property11 = property26;
        }
        if ((n & 0x20000) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = "";
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(String.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property27 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property27, (String)"apply(...)");
            property12 = property27;
        }
        if ((n & 0x40000) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = true;
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(Boolean.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property28 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property28, (String)"apply(...)");
            property13 = property28;
        }
        if ((n & 0x80000) != 0) {
            this_$iv = Companion;
            $this$propertyWithDefault$iv = objectFactory;
            default$iv = "forceVersion";
            $i$f$propertyWithDefault = false;
            $this$propertyWithDefault_u24lambda_u240$iv = property15 = $this$propertyWithDefault$iv.property(String.class);
            bl = false;
            $this$propertyWithDefault_u24lambda_u240$iv.convention(default$iv);
            Property property29 = property15;
            Intrinsics.checkNotNullExpressionValue((Object)property29, (String)"apply(...)");
            property14 = property29;
        }
        if ((n & 0x100000) != 0) {
            function1 = GitSemVerExtension::_init_$lambda$0;
        }
        this(project, providerFactory, objectFactory, file, string, logger, (Property<String>)property, (Property<String>)property2, (Property<String>)property3, (Property<Boolean>)property4, (Property<Integer>)property5, (Property<Integer>)property6, (Property<Boolean>)property7, (Property<Boolean>)property8, (Property<String>)property9, (Property<String>)property10, (Property<Integer>)property11, (Property<String>)property12, (Property<Boolean>)property13, (Property<String>)property14, (Function1<? super List<String>, ? extends UpdateType>)function1);
    }

    @NotNull
    public final Property<String> getMinimumVersion() {
        return this.minimumVersion;
    }

    @NotNull
    public final Property<String> getDevelopmentIdentifier() {
        return this.developmentIdentifier;
    }

    @NotNull
    public final Property<String> getNoTagIdentifier() {
        return this.noTagIdentifier;
    }

    @NotNull
    public final Property<Boolean> getFullHash() {
        return this.fullHash;
    }

    @NotNull
    public final Property<Integer> getMaxVersionLength() {
        return this.maxVersionLength;
    }

    @NotNull
    public final Property<Integer> getDevelopmentCounterLength() {
        return this.developmentCounterLength;
    }

    @NotNull
    public final Property<Boolean> getEnforceSemanticVersioning() {
        return this.enforceSemanticVersioning;
    }

    @NotNull
    public final Property<Boolean> getComputeReleaseVersion() {
        return this.computeReleaseVersion;
    }

    @NotNull
    public final Property<String> getPreReleaseSeparator() {
        return this.preReleaseSeparator;
    }

    @NotNull
    public final Property<String> getBuildMetadataSeparator() {
        return this.buildMetadataSeparator;
    }

    @NotNull
    public final Property<Integer> getDistanceCounterRadix() {
        return this.distanceCounterRadix;
    }

    @NotNull
    public final Property<String> getVersionPrefix() {
        return this.versionPrefix;
    }

    @NotNull
    public final Property<Boolean> getIncludeLightweightTags() {
        return this.includeLightweightTags;
    }

    @NotNull
    public final Property<String> getForceVersionPropertyName() {
        return this.forceVersionPropertyName;
    }

    public final void commitNameBasedUpdateStrategy(@NotNull Function1<? super List<String>, ? extends UpdateType> strategy) {
        Intrinsics.checkNotNullParameter(strategy, (String)"strategy");
        this.updateStrategy = strategy;
    }

    private final SemanticVersion computeMinVersion() {
        String minVersion = (String)this.minimumVersion.get();
        Intrinsics.checkNotNull((Object)minVersion);
        SemanticVersion semanticVersion = SemanticVersion.Companion.fromStringOrNull(minVersion);
        SemanticVersion minSemVer = semanticVersion != null ? semanticVersion.withoutBuildMetadata() : null;
        if (minSemVer == null) {
            boolean bl = false;
            String string = "Invalid minimum version does not conform to Semantic Versioning 2.0: " + minVersion;
            throw new IllegalArgumentException(string.toString());
        }
        if (!minSemVer.getBuildMetadata().isEmpty()) {
            this.logger.warn("Minimum version " + minSemVer + " build metadata will be ignored.");
        }
        return minSemVer;
    }

    @Nullable
    public final SemanticVersion findClosestTag() {
        Sequence sequence;
        Sequence sequence2;
        Set set;
        Object object = new String[]{"git", "rev-list", "HEAD"};
        Object object2 = this.runCommand((String)object);
        if ((object2 != null && (object2 = StringsKt.lines((CharSequence)((CharSequence)object2))) != null ? CollectionsKt.toSet((Iterable)((Iterable)object2)) : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        Set reachableCommits = set;
        Regex tagMatcher = new Regex("^(\\w*)\\s+(" + ((Boolean)this.includeLightweightTags.get() != false ? "commit|" : "") + "tag)\\s+refs/tags/" + this.versionPrefix.get() + "((0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?)$");
        this.logger.debug("Reachable commits: " + reachableCommits);
        String[] stringArray = new String[]{"git", "for-each-ref", "refs/tags", "--sort=-version:refname"};
        object = this.runCommand(stringArray);
        return object != null && (stringArray = StringsKt.lineSequence((CharSequence)((CharSequence)object))) != null && (sequence2 = SequencesKt.mapNotNull((Sequence)stringArray, arg_0 -> GitSemVerExtension.findClosestTag$lambda$2(tagMatcher, arg_0))) != null && (sequence = SequencesKt.mapNotNull((Sequence)sequence2, arg_0 -> GitSemVerExtension.findClosestTag$lambda$5(this, reachableCommits, arg_0))) != null ? (SemanticVersion)SequencesKt.firstOrNull((Sequence)sequence) : null;
    }

    @NotNull
    public final String computeVersion() {
        String string;
        String identifier;
        String hash;
        SemanticVersion closestTag = this.findClosestTag();
        this.logger.debug("Closest SemVer tag: " + closestTag);
        Boolean fullHash = (Boolean)this.fullHash.get();
        String[] stringArray = new String[]{" "};
        List printCommitCommand = StringsKt.split$default((CharSequence)("git rev-parse " + (fullHash != false ? "" : "--short ") + "HEAD"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Collection $this$toTypedArray$iv = printCommitCommand;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        String string2 = this.runCommand(Arrays.copyOf(stringArray2, stringArray2.length));
        if (string2 == null) {
            string2 = hash = String.valueOf(System.currentTimeMillis());
        }
        if (closestTag == null) {
            SemanticVersion base = this.computeMinVersion();
            identifier = (String)this.noTagIdentifier.orElse((Object)"").get();
            Boolean computeReleaseVersion22 = (Boolean)this.computeReleaseVersion.get();
            Intrinsics.checkNotNull((Object)identifier);
            String separator = StringsKt.isBlank((CharSequence)identifier) ? "" : (String)this.preReleaseSeparator.get();
            String buildSeparator = (String)this.buildMetadataSeparator.get();
            if (computeReleaseVersion22.booleanValue()) {
                String string3 = String.valueOf(base);
                Object object = this.maxVersionLength.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                string = StringsKt.take((String)string3, (int)((Number)object).intValue());
            } else {
                String string4 = base + separator + identifier + buildSeparator + hash;
                Object object = this.maxVersionLength.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                string = StringsKt.take((String)string4, (int)((Number)object).intValue());
            }
        } else {
            String[] computeReleaseVersion22;
            Long distance;
            if (!closestTag.getBuildMetadata().isEmpty()) {
                this.logger.warn("Build metadata of closest tag " + closestTag + " will be ignored.");
            }
            if ((distance = (identifier = this.runCommand(computeReleaseVersion22 = new String[]{"git", "rev-list", "--count", this.versionPrefix.get() + closestTag + "..HEAD"})) != null ? Long.valueOf(Long.parseLong(identifier)) : null) == null) {
                boolean bl = false;
                String string5 = "Bug in git SemVer plugin: [distance? " + distance + "]. Please report at: https://github.com/DanySK/git-sensitive-semantic-versioning-gradle-plugin/issues";
                throw new IllegalArgumentException(string5.toString());
            }
            long computeReleaseVersion22 = 0L;
            if (distance == computeReleaseVersion22) {
                string = closestTag.toString();
            } else {
                SemanticVersion base = closestTag.withoutBuildMetadata();
                String[] stringArray3 = new String[]{"git", "log", "--oneline", "-" + distance, "--no-decorate", "--format=%s"};
                String buildSeparator = this.runCommand(stringArray3);
                List list = buildSeparator != null ? StringsKt.lines((CharSequence)buildSeparator) : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List lastCommits = list;
                SemanticVersion currentVersion = ((UpdateType)((Object)this.updateStrategy.invoke((Object)lastCommits))).incrementVersion(base);
                String devString = (String)this.developmentIdentifier.get();
                Boolean computeReleaseVersion = (Boolean)this.computeReleaseVersion.get();
                Intrinsics.checkNotNull((Object)devString);
                String separator = StringsKt.isBlank((CharSequence)devString) ? "" : (String)this.preReleaseSeparator.get();
                long l = distance;
                Object object = this.distanceCounterRadix.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                String distanceString = GitSemVerExtension.Companion.withRadix(l, ((Number)object).intValue(), (Integer)this.developmentCounterLength.get());
                String buildSeparator2 = (String)this.buildMetadataSeparator.get();
                if (computeReleaseVersion.booleanValue()) {
                    String string6 = String.valueOf(currentVersion);
                    Object object2 = this.maxVersionLength.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                    string = StringsKt.take((String)string6, (int)((Number)object2).intValue());
                } else {
                    String string7 = currentVersion + separator + devString + distanceString + buildSeparator2 + hash;
                    Object object3 = this.maxVersionLength.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                    string = StringsKt.take((String)string7, (int)((Number)object3).intValue());
                }
            }
        }
        return string;
    }

    public final void assignGitSemanticVersion() {
        String string;
        Object object;
        Object object2;
        Object v = this.project.getProperties().get(this.forceVersionPropertyName.get());
        Object forcedVersion = v != null ? v.toString() : null;
        if (forcedVersion != null) {
            object2 = new Object[]{this.project.getName(), forcedVersion, this.forceVersionPropertyName.get()};
            this.project.getLogger().lifecycle("Forcing {} version to {} as per property '{}'", object2);
            object = forcedVersion;
        } else {
            String string2;
            String[] stringArray = new String[]{"git", "rev-parse", "--show-toplevel"};
            String repoLocation = this.runCommand(stringArray);
            String[] stringArray2 = new String[]{"git", "rev-list", "HEAD", "-n", "1"};
            String headCommitHash = this.runCommand(stringArray2);
            if (repoLocation != null && headCommitHash != null) {
                string2 = (String)this.versions.get((Object)TuplesKt.to((Object)repoLocation, (Object)headCommitHash));
            } else {
                this.project.getLogger().warn("Could not detect both the git repository location ({}) and the HEAD commit hash ({}). The version will be forcibly recomputed.", (Object)repoLocation, (Object)headCommitHash);
                string2 = this.computeVersion();
            }
            object2 = string2;
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        Object computedVersion = object;
        SemanticVersion resultingVersion = SemanticVersion.Companion.fromStringOrNull((String)computedVersion);
        if (resultingVersion == null) {
            String error = "Invalid Semantic Versioning 2.0 version: " + this.version;
            if (((Boolean)this.enforceSemanticVersioning.get()).booleanValue()) {
                throw new IllegalStateException(error.toString());
            }
            this.logger.warn(error);
            string = computedVersion;
        } else {
            string = resultingVersion.toString();
        }
        this.project.setVersion((Object)string);
    }

    public final void excludeLightweightTags() {
        this.includeLightweightTags.set((Object)false);
    }

    @Nullable
    protected final String runCommand(String ... cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return this.processCommand(Arrays.copyOf(cmd, cmd.length));
    }

    private final String processCommand(String ... cmd) {
        String string;
        Object object = this.createValueSourceProvider(Arrays.copyOf(cmd, cmd.length)).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String it = string = ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
        boolean bl = false;
        return ((CharSequence)it).length() > 0 ? string : null;
    }

    private final Provider<String> createValueSourceProvider(String ... cmd) {
        Provider provider = this.providerFactory.of(GitCommandValueSource.class, arg_0 -> GitSemVerExtension.createValueSourceProvider$lambda$11(arg_0 -> GitSemVerExtension.createValueSourceProvider$lambda$10(this, cmd, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"of(...)");
        return provider;
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning, @NotNull Property<Boolean> computeReleaseVersion, @NotNull Property<String> preReleaseSeparator, @NotNull Property<String> buildMetadataSeparator, @NotNull Property<Integer> distanceCounterRadix, @NotNull Property<String> versionPrefix, @NotNull Property<Boolean> includeLightweightTags, @NotNull Property<String> forceVersionPropertyName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        Intrinsics.checkNotNullParameter(computeReleaseVersion, (String)"computeReleaseVersion");
        Intrinsics.checkNotNullParameter(preReleaseSeparator, (String)"preReleaseSeparator");
        Intrinsics.checkNotNullParameter(buildMetadataSeparator, (String)"buildMetadataSeparator");
        Intrinsics.checkNotNullParameter(distanceCounterRadix, (String)"distanceCounterRadix");
        Intrinsics.checkNotNullParameter(versionPrefix, (String)"versionPrefix");
        Intrinsics.checkNotNullParameter(includeLightweightTags, (String)"includeLightweightTags");
        Intrinsics.checkNotNullParameter(forceVersionPropertyName, (String)"forceVersionPropertyName");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, enforceSemanticVersioning, computeReleaseVersion, preReleaseSeparator, buildMetadataSeparator, distanceCounterRadix, versionPrefix, includeLightweightTags, forceVersionPropertyName, null, 0x100000, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning, @NotNull Property<Boolean> computeReleaseVersion, @NotNull Property<String> preReleaseSeparator, @NotNull Property<String> buildMetadataSeparator, @NotNull Property<Integer> distanceCounterRadix, @NotNull Property<String> versionPrefix, @NotNull Property<Boolean> includeLightweightTags) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        Intrinsics.checkNotNullParameter(computeReleaseVersion, (String)"computeReleaseVersion");
        Intrinsics.checkNotNullParameter(preReleaseSeparator, (String)"preReleaseSeparator");
        Intrinsics.checkNotNullParameter(buildMetadataSeparator, (String)"buildMetadataSeparator");
        Intrinsics.checkNotNullParameter(distanceCounterRadix, (String)"distanceCounterRadix");
        Intrinsics.checkNotNullParameter(versionPrefix, (String)"versionPrefix");
        Intrinsics.checkNotNullParameter(includeLightweightTags, (String)"includeLightweightTags");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, enforceSemanticVersioning, computeReleaseVersion, preReleaseSeparator, buildMetadataSeparator, distanceCounterRadix, versionPrefix, includeLightweightTags, null, null, 0x180000, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning, @NotNull Property<Boolean> computeReleaseVersion, @NotNull Property<String> preReleaseSeparator, @NotNull Property<String> buildMetadataSeparator, @NotNull Property<Integer> distanceCounterRadix, @NotNull Property<String> versionPrefix) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        Intrinsics.checkNotNullParameter(computeReleaseVersion, (String)"computeReleaseVersion");
        Intrinsics.checkNotNullParameter(preReleaseSeparator, (String)"preReleaseSeparator");
        Intrinsics.checkNotNullParameter(buildMetadataSeparator, (String)"buildMetadataSeparator");
        Intrinsics.checkNotNullParameter(distanceCounterRadix, (String)"distanceCounterRadix");
        Intrinsics.checkNotNullParameter(versionPrefix, (String)"versionPrefix");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, enforceSemanticVersioning, computeReleaseVersion, preReleaseSeparator, buildMetadataSeparator, distanceCounterRadix, versionPrefix, null, null, null, 0x1C0000, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning, @NotNull Property<Boolean> computeReleaseVersion, @NotNull Property<String> preReleaseSeparator, @NotNull Property<String> buildMetadataSeparator, @NotNull Property<Integer> distanceCounterRadix) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        Intrinsics.checkNotNullParameter(computeReleaseVersion, (String)"computeReleaseVersion");
        Intrinsics.checkNotNullParameter(preReleaseSeparator, (String)"preReleaseSeparator");
        Intrinsics.checkNotNullParameter(buildMetadataSeparator, (String)"buildMetadataSeparator");
        Intrinsics.checkNotNullParameter(distanceCounterRadix, (String)"distanceCounterRadix");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, enforceSemanticVersioning, computeReleaseVersion, preReleaseSeparator, buildMetadataSeparator, distanceCounterRadix, null, null, null, null, 0x1E0000, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning, @NotNull Property<Boolean> computeReleaseVersion, @NotNull Property<String> preReleaseSeparator, @NotNull Property<String> buildMetadataSeparator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        Intrinsics.checkNotNullParameter(computeReleaseVersion, (String)"computeReleaseVersion");
        Intrinsics.checkNotNullParameter(preReleaseSeparator, (String)"preReleaseSeparator");
        Intrinsics.checkNotNullParameter(buildMetadataSeparator, (String)"buildMetadataSeparator");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, enforceSemanticVersioning, computeReleaseVersion, preReleaseSeparator, buildMetadataSeparator, null, null, null, null, null, 0x1F0000, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning, @NotNull Property<Boolean> computeReleaseVersion, @NotNull Property<String> preReleaseSeparator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        Intrinsics.checkNotNullParameter(computeReleaseVersion, (String)"computeReleaseVersion");
        Intrinsics.checkNotNullParameter(preReleaseSeparator, (String)"preReleaseSeparator");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, enforceSemanticVersioning, computeReleaseVersion, preReleaseSeparator, null, null, null, null, null, null, 2064384, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning, @NotNull Property<Boolean> computeReleaseVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        Intrinsics.checkNotNullParameter(computeReleaseVersion, (String)"computeReleaseVersion");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, enforceSemanticVersioning, computeReleaseVersion, null, null, null, null, null, null, null, 2080768, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength, @NotNull Property<Boolean> enforceSemanticVersioning) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        Intrinsics.checkNotNullParameter(enforceSemanticVersioning, (String)"enforceSemanticVersioning");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, enforceSemanticVersioning, null, null, null, null, null, null, null, null, 2088960, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength, @NotNull Property<Integer> developmentCounterLength) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        Intrinsics.checkNotNullParameter(developmentCounterLength, (String)"developmentCounterLength");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, developmentCounterLength, null, null, null, null, null, null, null, null, null, 0x1FF000, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash, @NotNull Property<Integer> maxVersionLength) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        Intrinsics.checkNotNullParameter(maxVersionLength, (String)"maxVersionLength");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, maxVersionLength, null, null, null, null, null, null, null, null, null, null, 2095104, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier, @NotNull Property<Boolean> fullHash) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        Intrinsics.checkNotNullParameter(fullHash, (String)"fullHash");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, fullHash, null, null, null, null, null, null, null, null, null, null, null, 2096128, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier, @NotNull Property<String> noTagIdentifier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        Intrinsics.checkNotNullParameter(noTagIdentifier, (String)"noTagIdentifier");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, noTagIdentifier, null, null, null, null, null, null, null, null, null, null, null, null, 2096640, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion, @NotNull Property<String> developmentIdentifier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        Intrinsics.checkNotNullParameter(developmentIdentifier, (String)"developmentIdentifier");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, developmentIdentifier, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x1FFF00, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger, @NotNull Property<String> minimumVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(minimumVersion, (String)"minimumVersion");
        this(project, providerFactory, objectFactory, projectDir, version, logger, minimumVersion, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2097024, null);
    }

    @JvmOverloads
    public GitSemVerExtension(@NotNull Project project, @NotNull ProviderFactory providerFactory, @NotNull ObjectFactory objectFactory, @NotNull File projectDir, @NotNull String version, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this(project, providerFactory, objectFactory, projectDir, version, logger, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 2097088, null);
    }

    private static final UpdateType _init_$lambda$0(List list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        return UpdateType.PATCH;
    }

    private static final MatchResult.Destructured findClosestTag$lambda$2(Regex $tagMatcher, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MatchResult matchResult = $tagMatcher.matchEntire((CharSequence)it);
        return matchResult != null ? matchResult.getDestructured() : null;
    }

    private static final SemanticVersion findClosestTag$lambda$5(GitSemVerExtension this$0, Set $reachableCommits, MatchResult.Destructured destructured) {
        SemanticVersion semanticVersion;
        String[] actualRef;
        String[] stringArray;
        Object object;
        Intrinsics.checkNotNullParameter((Object)destructured, (String)"<destruct>");
        String[] commit = (String[])destructured.getMatch().getGroupValues().get(1);
        String type = (String)destructured.getMatch().getGroupValues().get(2);
        String semVer = (String)destructured.getMatch().getGroupValues().get(3);
        String major = (String)destructured.getMatch().getGroupValues().get(4);
        String minor = (String)destructured.getMatch().getGroupValues().get(5);
        String patch = (String)destructured.getMatch().getGroupValues().get(6);
        String option = (String)destructured.getMatch().getGroupValues().get(7);
        String build = (String)destructured.getMatch().getGroupValues().get(8);
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"commit")) {
            object = commit;
        } else if (Intrinsics.areEqual((Object)string, (Object)"tag")) {
            stringArray = new String[]{"git", "rev-list", "-n1", this$0.versionPrefix.get() + semVer};
            object = this$0.runCommand(stringArray);
        } else {
            throw new IllegalStateException(("Unknown tag ref type '" + type + "' (expected 'tag' or 'commit')").toString());
        }
        String[] it = stringArray = (actualRef = object);
        boolean bl = false;
        Object object2 = CollectionsKt.contains((Iterable)$reachableCommits, (Object)it) ? stringArray : null;
        if (object2 != null) {
            it = object2;
            boolean bl2 = false;
            semanticVersion = new SemanticVersion(major, minor, patch, option, build);
        } else {
            semanticVersion = null;
        }
        return semanticVersion;
    }

    private static final Unit createValueSourceProvider$lambda$10$lambda$8(GitSemVerExtension this$0, String[] $cmd, Parameters params) {
        params.getCommands().set((Provider)this$0.objectFactory.listProperty(String.class).value((Iterable)ArraysKt.asList((Object[])$cmd)));
        params.getDirectory().set((Object)this$0.projectDir);
        return Unit.INSTANCE;
    }

    private static final void createValueSourceProvider$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createValueSourceProvider$lambda$10(GitSemVerExtension this$0, String[] $cmd, ValueSourceSpec it) {
        it.parameters(arg_0 -> GitSemVerExtension.createValueSourceProvider$lambda$10$lambda$9(arg_0 -> GitSemVerExtension.createValueSourceProvider$lambda$10$lambda$8(this$0, $cmd, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void createValueSourceProvider$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u0002H\nH\u0082\b\u00a2\u0006\u0002\u0010\rJ%\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/danilopianini/gradle/gitsemver/GitSemVerExtension$Companion;", "", "<init>", "()V", "EXTENSION_NAME", "", "DEFAULT_RADIX", "", "propertyWithDefault", "Lorg/gradle/api/provider/Property;", "T", "Lorg/gradle/api/model/ObjectFactory;", "default", "(Lorg/gradle/api/model/ObjectFactory;Ljava/lang/Object;)Lorg/gradle/api/provider/Property;", "withRadix", "", "radix", "digits", "(JILjava/lang/Integer;)Ljava/lang/String;", "git-sensitive-semantic-versioning-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nGitSemVerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSemVerExtension.kt\norg/danilopianini/gradle/gitsemver/GitSemVerExtension$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n1#2:297\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final /* synthetic */ <T> Property<T> propertyWithDefault(ObjectFactory $this$propertyWithDefault, T t) {
            Property property;
            boolean $i$f$propertyWithDefault = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Property $this$propertyWithDefault_u24lambda_u240 = property = $this$propertyWithDefault.property(Object.class);
            boolean bl = false;
            $this$propertyWithDefault_u24lambda_u240.convention(t);
            Property property2 = property;
            Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"apply(...)");
            return property2;
        }

        private final String withRadix(long $this$withRadix, int radix, Integer digits) {
            String string = Long.toString($this$withRadix, CharsKt.checkRadix((int)radix));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String it = string;
            boolean bl = false;
            return digits == null || it.length() >= digits ? it : StringsKt.padStart((String)it, (int)digits, (char)'0');
        }

        static /* synthetic */ String withRadix$default(Companion companion, long l, int n, Integer n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = null;
            }
            return companion.withRadix(l, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

