/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.kotlinqa;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.danilopianini.kotlinqa.KotlinQAExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/danilopianini/kotlinqa/GenerateDetektConfiguration;", "Lorg/gradle/api/DefaultTask;", "extension", "Lorg/danilopianini/kotlinqa/KotlinQAExtension;", "<init>", "(Lorg/danilopianini/kotlinqa/KotlinQAExtension;)V", "detektConfigurationFile", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "getDetektConfigurationFile", "()Lorg/gradle/api/provider/Provider;", "generateDetektConfigurationFile", "", "Companion", "gradle-kotlin-qa"})
public class GenerateDetektConfiguration
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinQAExtension extension;
    @OutputFile
    @NotNull
    private final Provider<File> detektConfigurationFile;
    @NotNull
    private static final String detektConfigFile = "org/danilopianini/kotlinqa/detekt.yml";

    @Inject
    public GenerateDetektConfiguration(@NotNull KotlinQAExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.extension = extension;
        this.detektConfigurationFile = this.extension.getDetektConfigurationFile();
    }

    @NotNull
    public final Provider<File> getDetektConfigurationFile() {
        return this.detektConfigurationFile;
    }

    @TaskAction
    public final void generateDetektConfigurationFile() {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(detektConfigFile);
        if (uRL == null) {
            throw new IllegalStateException("Unable to read org/danilopianini/kotlinqa/detekt.yml from the classpath, is this a bug in the Kotlin QA plugin?".toString());
        }
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String configuration = new String(byArray, charset);
        File workDir = (File)this.extension.getWorkingDirectory().get();
        if (workDir.mkdirs()) {
            this.getLogger().debug("Created folder " + workDir.getAbsolutePath());
        } else {
            this.getLogger().debug("Folder " + workDir.getAbsolutePath() + " was already existing");
        }
        Object object = this.detektConfigurationFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        FilesKt.writeText$default((File)((File)object), (String)configuration, null, (int)2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/danilopianini/kotlinqa/GenerateDetektConfiguration$Companion;", "", "<init>", "()V", "detektConfigFile", "", "gradle-kotlin-qa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

