/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.io;

import java.io.File;

public abstract class AbstractFileScanner
implements Runnable {
    private final File file;
    private final boolean followH;

    public AbstractFileScanner(File f) {
        this(f, true);
    }

    public AbstractFileScanner(File f, boolean followHidden) {
        this.file = f;
        this.followH = followHidden;
    }

    protected abstract void finish();

    protected abstract void foundDirectory(File var1);

    protected abstract void foundFile(File var1);

    @Override
    public void run() {
        this.setup();
        this.scan(this.file);
        this.finish();
    }

    protected void scan(File f) {
        if (f.isDirectory() && (this.followH || !f.isHidden())) {
            this.foundDirectory(f);
            File[] list = f.listFiles();
            if (list != null) {
                for (File s : list) {
                    this.scan(s);
                }
            }
            this.exitDirectory(f);
        } else {
            this.foundFile(f);
        }
    }

    protected abstract void exitDirectory(File var1);

    protected abstract void setup();
}

