/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.danilopianini.concurrency.ThreadManager;
import org.danilopianini.io.AbstractFileSystemWatcher;

public abstract class AbstractRecursiveFileSystemWatcher
extends AbstractFileSystemWatcher {
    private static final String SLASH = System.getProperty("file.separator");
    private final Map<Path, AbstractRecursiveFileSystemWatcher> map = new ConcurrentHashMap<Path, AbstractRecursiveFileSystemWatcher>();
    private final ThreadManager tm;

    public AbstractRecursiveFileSystemWatcher(String dir, ThreadManager threadManager) throws IOException {
        super(dir);
        this.tm = threadManager;
        File[] files = this.getPath().toFile().listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isDirectory()) continue;
                Path p = FileSystems.getDefault().getPath(f.toString(), new String[0]);
                AbstractRecursiveFileSystemWatcher w = this.build(f);
                threadManager.addService(w);
                this.map.put(p, w);
            }
        }
    }

    public abstract AbstractRecursiveFileSystemWatcher build(File var1);

    @Override
    protected final void created(Path file) {
        File realfile = new File(this.getPath() + SLASH + file.toString());
        if (realfile.isDirectory()) {
            AbstractRecursiveFileSystemWatcher w = this.build(realfile);
            this.tm.addService(w);
            this.map.put(file, w);
        }
        this.createdFile(file);
    }

    protected abstract void createdFile(Path var1);

    @Override
    protected void deleted(Path file) {
        if (this.map.containsKey(file)) {
            this.map.remove(file).stopService();
        }
        this.deletedFile(file);
    }

    protected abstract void deletedFile(Path var1);

    protected abstract void finalizeStop();

    public ThreadManager getThreadManager() {
        return this.tm;
    }

    @Override
    public final void stopService() {
        super.stopService();
        for (Map.Entry<Path, AbstractRecursiveFileSystemWatcher> p : this.map.entrySet()) {
            p.getValue().stopService();
        }
        this.finalizeStop();
    }
}

