/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.io;

import com.google.common.base.Charsets;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import org.apache.commons.io.FileUtils;

public final class FileUtilities {
    private static final String BACKUP_EXTENSION = ".bak";

    public static <T extends Serializable> T cloneObject(T x) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream cout = new ObjectOutputStream(bout);
        cout.writeObject(x);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream cin = new ObjectInputStream(bin);
        return (T)((Serializable)cin.readObject());
    }

    public static <T extends Serializable> T deserializeObject(byte[] b) {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(b);
            ObjectInputStream cin = new ObjectInputStream(bin);
            return (T)((Serializable)cin.readObject());
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long fileCRC32sum(File f) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            int val;
            CRC32 crc = new CRC32();
            do {
                val = ((InputStream)is).read();
                crc.update(val);
            } while (val != -1);
            ((InputStream)is).close();
            long l = crc.getValue();
            return l;
        }
    }

    public static Serializable fileToObject(File f) throws IOException, ClassNotFoundException {
        if (f.exists()) {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));){
                Serializable res = (Serializable)ois.readObject();
                ois.close();
                Serializable serializable = res;
                return serializable;
            }
        }
        return null;
    }

    public static Object fileToObject(String path) throws IOException, ClassNotFoundException {
        return FileUtilities.fileToObject(new File(path));
    }

    @Deprecated
    public static String fileToString(File f) throws IOException {
        return FileUtils.readFileToString((File)f, (String)Charsets.UTF_8.name());
    }

    @Deprecated
    public static String fileToString(String path) throws IOException {
        return FileUtilities.fileToString(new File(path));
    }

    public static String fileUTF8ToString(String path) throws IOException {
        return FileUtilities.fileToString(path, Charsets.UTF_8);
    }

    public static String fileToString(String path, Charset c) throws IOException {
        return FileUtils.readFileToString((File)new File(path), (String)c.name());
    }

    public static boolean isInHiddenPath(File file) {
        boolean hidden = false;
        File f = file;
        do {
            hidden = f.isHidden();
            f = f.getParentFile();
        } while (!hidden && f != null);
        return hidden;
    }

    public static Image loadImage(String path) {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        URL fileLocation = loader.getResource(path);
        Image img = Toolkit.getDefaultToolkit().getImage(fileLocation);
        if (img != null) {
            return img;
        }
        return Toolkit.getDefaultToolkit().getImage(fileLocation);
    }

    public static void objectToFile(Object s, File f, boolean backup) throws IOException {
        String op = f.getAbsolutePath();
        if (backup && f.exists() && !f.renameTo(new File(op + BACKUP_EXTENSION))) {
            throw new IOException("Can not move " + op + " to " + op + BACKUP_EXTENSION);
        }
        File ef = new File(op);
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(ef));){
            oos.writeObject(s);
            oos.close();
        }
    }

    public static void objectToFile(Serializable s, String path, boolean backup) throws IOException {
        FileUtilities.objectToFile((Object)s, new File(path), backup);
    }

    public static byte[] serializeObject(Serializable x) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream cout = new ObjectOutputStream(bout);
            cout.writeObject(x);
            return bout.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    @Deprecated
    public static void stringToFile(String s, File f, boolean append) throws IOException {
        String op = f.getAbsolutePath();
        if (f.exists() && !f.renameTo(new File(op + BACKUP_EXTENSION))) {
            throw new IOException("Can not move " + op + " to " + op + BACKUP_EXTENSION);
        }
        FileUtils.writeStringToFile((File)f, (String)s);
    }

    public static void stringToFile(String string, String path) throws IOException {
        FileUtilities.stringToFile(string, path, false);
    }

    public static void stringToFile(String string, String path, boolean append) throws IOException {
        FileUtilities.stringToFile(string, new File(path), append);
    }

    private FileUtilities() {
    }
}

