/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.io;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.danilopianini.view.GUIUtilities;

public final class PrintUtility {
    private PrintUtility() {
    }

    public static boolean print(Component c) throws PrinterException {
        boolean printed = PrinterJob.getPrinterJob().printDialog();
        if (printed) {
            PrintUtility.quickprint(c);
        }
        return printed;
    }

    public static void quickprint(Component c) throws PrinterException {
        PrintableComponent p = new PrintableComponent(c);
        PrinterJob.getPrinterJob().setPrintable(p);
        PrinterJob.getPrinterJob().print();
    }

    private static final class PrintableComponent
    implements Printable {
        private final Component componentToBePrinted;

        PrintableComponent(Component component) {
            this.componentToBePrinted = component;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            if (pageIndex <= 0 && g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                pageFormat.setOrientation(0);
                g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                GUIUtilities.disableDoubleBuffering(this.componentToBePrinted);
                this.componentToBePrinted.paint(g2d);
                GUIUtilities.enableDoubleBuffering(this.componentToBePrinted);
                return 0;
            }
            return 1;
        }
    }
}

