/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.lang;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.danilopianini.io.FileUtilities;

public final class HashUtils {
    private static final HashFunction MURMUR32 = Hashing.murmur3_32();
    private static final HashFunction MURMUR128 = Hashing.murmur3_128();
    private static final Charset CHARSET = StandardCharsets.UTF_16;
    private static final int MASK_BYTE = 255;
    private static final int SHIFT3 = 24;
    private static final int SHIFT4 = 32;
    private static final int SHIFT5 = 40;
    private static final int SHIFT6 = 48;
    private static final int SHIFT7 = 56;

    public static int hash32(double data) {
        return MURMUR32.hashLong(Double.doubleToRawLongBits(data)).asInt();
    }

    public static int hash32(long data) {
        return MURMUR32.hashLong(data).asInt();
    }

    public static int hash32(float data) {
        return MURMUR32.hashInt(Float.floatToRawIntBits(data)).asInt();
    }

    public static int hash32(CharSequence data) {
        return MURMUR32.hashString(data, CHARSET).asInt();
    }

    public static int hash32(Integer data) {
        return data;
    }

    public static int hash32(Float data) {
        return HashUtils.hash32(data.floatValue());
    }

    public static int hash32(Double data) {
        return HashUtils.hash32((double)data);
    }

    public static int hash32(Long data) {
        return HashUtils.hash32((long)data);
    }

    public static int hash32(Object ... data) {
        Hasher h = MURMUR32.newHasher();
        if (data.length == 1) {
            HashUtils.populateHasher(data[0], h);
        } else {
            HashUtils.populateHasher(data, h);
        }
        return h.hash().asInt();
    }

    public static long hash64(double data) {
        return MURMUR128.hashLong(Double.doubleToRawLongBits(data)).asLong();
    }

    public static long hash64(long data) {
        return MURMUR128.hashLong(data).asLong();
    }

    public static long hash64(float data) {
        return HashUtils.hash32(data);
    }

    public static long hash64(CharSequence data) {
        return MURMUR128.hashString(data, CHARSET).asLong();
    }

    public static long hash64(Integer data) {
        return data.intValue();
    }

    public static long hash64(Float data) {
        return HashUtils.hash32(data);
    }

    public static long hash64(Double data) {
        return HashUtils.hash64((double)data);
    }

    public static long hash64(Long data) {
        return HashUtils.hash64((long)data);
    }

    public static long hash64(Object ... data) {
        Hasher h = MURMUR128.newHasher();
        if (data.length == 1) {
            HashUtils.populateHasher(data[0], h);
        } else {
            HashUtils.populateHasher(data, h);
        }
        return h.hash().asLong();
    }

    private static void populateHasher(Object data, Hasher h) {
        if (data != null) {
            if (data instanceof Number) {
                Number d = (Number)data;
                if (data instanceof Integer) {
                    h.putInt(d.intValue());
                } else if (data instanceof Double) {
                    h.putDouble(d.doubleValue());
                } else if (data instanceof Long) {
                    h.putLong(d.longValue());
                } else if (data instanceof Float) {
                    h.putFloat(d.floatValue());
                } else if (data instanceof Byte) {
                    h.putByte(d.byteValue());
                } else if (data instanceof Short) {
                    h.putShort(d.shortValue());
                } else {
                    h.putInt(data.hashCode());
                }
            } else if (data instanceof CharSequence) {
                h.putString((CharSequence)data, CHARSET);
            } else if (data.getClass().isArray()) {
                int size = Array.getLength(data);
                for (int i = 0; i < size; ++i) {
                    HashUtils.populateHasher(Array.get(data, i), h);
                }
            } else if (data instanceof Iterable) {
                for (Object o : (Iterable)data) {
                    HashUtils.populateHasher(o, h);
                }
            } else {
                h.putInt(data.hashCode());
            }
        }
    }

    public static int djb2int32(byte ... bytes) {
        int hash32 = 5381;
        for (byte b : bytes) {
            hash32 = hash32 * 33 ^ b;
        }
        return hash32;
    }

    public static int djb2int32(double ... bytes) {
        return HashUtils.djb2int32(HashUtils.toByta(bytes));
    }

    public static int djb2int32(int ... bytes) {
        return HashUtils.djb2int32(HashUtils.toByta(bytes));
    }

    @Deprecated
    public static int djb2int32obj(Serializable ... bytes) {
        return HashUtils.djb2int32(FileUtilities.serializeObject((Serializable)bytes));
    }

    public static long djb2long64(byte ... bytes) {
        long hash = 5381L;
        for (byte b : bytes) {
            hash = (hash << 5) + hash + (long)b;
        }
        return hash;
    }

    public static long djb2long64(double ... bytes) {
        return HashUtils.djb2long64(HashUtils.toByta(bytes));
    }

    public static long djb2long64(int ... bytes) {
        return HashUtils.djb2long64(HashUtils.toByta(bytes));
    }

    @Deprecated
    public static long djb2long64obj(Serializable ... bytes) {
        return HashUtils.djb2long64(FileUtilities.serializeObject((Serializable)bytes));
    }

    public static byte[] toByta(double data) {
        return HashUtils.toByta(Double.doubleToRawLongBits(data));
    }

    public static byte[] toByta(double[] data) {
        Objects.requireNonNull(data);
        byte[] byts = new byte[data.length * 8];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(HashUtils.toByta(data[i]), 0, byts, i * 8, 8);
        }
        return byts;
    }

    public static byte[] toByta(float data) {
        return HashUtils.toByta(Float.floatToRawIntBits(data));
    }

    public static byte[] toByta(float[] data) {
        Objects.requireNonNull(data);
        byte[] byts = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(HashUtils.toByta(data[i]), 0, byts, i * 4, 4);
        }
        return byts;
    }

    public static byte[] toByta(int data) {
        return new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] toByta(int[] data) {
        Objects.requireNonNull(data);
        byte[] byts = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(HashUtils.toByta(data[i]), 0, byts, i * 4, 4);
        }
        return byts;
    }

    public static byte[] toByta(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static byte[] toByta(long[] data) {
        Objects.requireNonNull(data);
        byte[] byts = new byte[data.length * 8];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(HashUtils.toByta(data[i]), 0, byts, i * 8, 8);
        }
        return byts;
    }

    public static boolean pointerEquals(Object a, Object b) {
        return System.identityHashCode(a) == System.identityHashCode(b);
    }

    private HashUtils() {
    }
}

