/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.lang;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.danilopianini.lang.CollectionWithCurrentElement;

public class ImmutableCollectionWithCurrentElement<E>
implements CollectionWithCurrentElement<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<E> col;
    private E cur;

    public ImmutableCollectionWithCurrentElement(Collection<E> origin, E current) {
        this.col = Collections.unmodifiableCollection(new ArrayList<E>(origin));
        this.setCurrent(current);
    }

    @Override
    public boolean add(E arg0) {
        return this.col.add(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        return this.col.addAll(arg0);
    }

    @Override
    public void clear() {
        this.col.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.col.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.col.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.col.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.col.iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        return this.col.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.col.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.col.retainAll(arg0);
    }

    @Override
    public int size() {
        return this.col.size();
    }

    @Override
    public Object[] toArray() {
        return this.col.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.col.toArray(arg0);
    }

    @Override
    public E getCurrent() {
        return this.cur;
    }

    @Override
    public final void setCurrent(E e) {
        if (!this.col.contains(e)) {
            throw new NoSuchElementException();
        }
        this.cur = e;
    }
}

