/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class ButtonTabComponent
extends JPanel {
    private static final long serialVersionUID = -1213910239175658021L;
    private static final byte BORDER_SIZE = 5;
    private static final MouseListener BUTTON_MOUSE_LISTENER = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };
    private final JTabbedPane pane;

    public ButtonTabComponent(final JTabbedPane tabbedPane, ActionListener closeListener) {
        super(new FlowLayout(0, 0, 0));
        if (tabbedPane == null) {
            throw new IllegalArgumentException("TabbedPane is null");
        }
        this.pane = tabbedPane;
        this.setOpaque(false);
        JLabel label = new JLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getText() {
                int i = tabbedPane.indexOfTabComponent(ButtonTabComponent.this);
                if (i != -1) {
                    return tabbedPane.getTitleAt(i);
                }
                return null;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton button = new TabButton();
        this.add(button);
        if (closeListener != null) {
            button.addActionListener(closeListener);
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -2443563189596390441L;
        private static final byte SIZE = 18;
        private static final byte DELTA = 5;
        private static final byte STROKE = 3;

        TabButton() {
            this.setPreferredSize(new Dimension(18, 18));
            this.setToolTipText("Close this tab");
            this.setActionCommand("CloseTab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(BUTTON_MOUSE_LISTENER);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (i != -1) {
                ButtonTabComponent.this.pane.remove(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            }
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(5, 5, this.getWidth() - 5 - 1, this.getHeight() - 5 - 1);
            g2.drawLine(this.getWidth() - 5 - 1, 5, 5, this.getHeight() - 5 - 1);
            g2.dispose();
        }
    }
}

