/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.view;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.danilopianini.lang.CollectionWithCurrentElement;
import org.danilopianini.lang.RangedInteger;
import org.danilopianini.view.CloseFrameWhenMouseExits;
import org.danilopianini.view.ExportForGUI;

public class ObjectModFrame
extends JFrame {
    private static final long serialVersionUID = 5816449414660853953L;
    private String actionCommand = "";
    private final AtomicInteger idgen = new AtomicInteger();
    private final List<ActionListener> listeners = Collections.synchronizedList(new ArrayList());

    private static boolean assignable(Class<?> clazz, Field field) throws IllegalAccessException {
        return clazz.isAssignableFrom(field.getType());
    }

    public ObjectModFrame(Object obj) throws IllegalAccessException {
        this.setType(Window.Type.POPUP);
        this.setAlwaysOnTop(true);
        JPanel contents = new JPanel();
        contents.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.addMouseListener(new CloseFrameWhenMouseExits(this));
        contents.setLayout(new BoxLayout(contents, 1));
        for (Field f : ObjectModFrame.getAllFields(new ArrayList<Field>(), obj.getClass())) {
            if (!f.isAnnotationPresent(ExportForGUI.class)) continue;
            String expName = f.getAnnotation(ExportForGUI.class).nameToExport();
            boolean accessible = f.isAccessible();
            if (!accessible) {
                ObjectModFrame.setAccess(f, true);
            }
            if (ObjectModFrame.assignable(RangedInteger.class, f)) {
                contents.add(new RangedIntegerGUIComponent(expName, (RangedInteger)f.get(obj)));
                continue;
            }
            if (Boolean.class.equals(f.getType()) || f.getType().equals(Boolean.TYPE)) {
                contents.add(new BooleanGUIComponent(expName, obj, f));
                continue;
            }
            if (String.class.equals(f.getType())) {
                contents.add(new StringGUIComponent(expName, obj, f));
                continue;
            }
            if (f.getType().isEnum()) {
                contents.add(new EnumGUIComponent(expName, obj, f));
                continue;
            }
            if (CollectionWithCurrentElement.class.isAssignableFrom(f.getType())) {
                contents.add(new CurrentCollectionGUIComponent(expName, obj, f));
                continue;
            }
            ObjectModFrame.setAccess(f, accessible);
        }
        this.getContentPane().add(contents);
        this.pack();
    }

    private static void setAccess(final Field f, final boolean accessible) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                f.setAccessible(accessible);
                return null;
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    private void notifyListeners() {
        ActionEvent e = new ActionEvent(this, this.idgen.getAndIncrement(), this.actionCommand);
        for (ActionListener a : this.listeners) {
            a.actionPerformed(e);
        }
    }

    public void setActionCommand(String ac) {
        this.actionCommand = ac;
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        if (type.getSuperclass() != null) {
            ObjectModFrame.getAllFields(fields, type.getSuperclass());
        }
        for (Field field : type.getDeclaredFields()) {
            fields.add(field);
        }
        return fields;
    }

    private class StringGUIComponent
    extends NoRefGUIComponent
    implements DocumentListener {
        private static final long serialVersionUID = -1557933366572097377L;
        private final JTextField text;

        StringGUIComponent(String name, Object obj, Field f) throws IllegalAccessException {
            super(obj, f);
            this.setLayout(new BoxLayout(this, 0));
            this.add(new JLabel(name));
            this.add(Box.createHorizontalStrut(10));
            this.text = new JTextField(f.get(obj).toString());
            this.add(this.text);
            this.text.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            this.update(this.text.getText());
        }
    }

    private class RangedIntegerGUIComponent
    extends JPanel
    implements ChangeListener {
        private static final long serialVersionUID = 4082696268464803253L;
        public static final int SLIDERS_MAJOR_TICKS = 10;
        private final RangedInteger n;
        private final JSlider slider = new JSlider();
        private final JLabel label = new JLabel();

        RangedIntegerGUIComponent(String name, RangedInteger num) {
            this.n = num;
            this.add(new JLabel(name));
            this.add(this.slider);
            this.add(this.label);
            int min = this.n.getMin();
            int max = this.n.getMax();
            this.slider.setMaximum(max);
            this.slider.setMinimum(min);
            this.slider.setMinorTickSpacing(1);
            this.slider.setMajorTickSpacing((max - min) / 10);
            this.slider.setValue(this.n.getVal());
            this.label.setText(Integer.toString(this.n.getVal()));
            this.slider.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.n.setVal(this.slider.getValue());
            this.label.setText(Integer.toString(this.n.getVal()));
            ObjectModFrame.this.pack();
            ObjectModFrame.this.notifyListeners();
        }
    }

    private abstract class NoRefGUIComponent
    extends JPanel {
        private static final long serialVersionUID = 7131340105783363250L;
        private final Field field;
        private final Object object;

        NoRefGUIComponent(Object obj, Field f) {
            this.field = f;
            this.object = obj;
        }

        protected Field getField() {
            return this.field;
        }

        protected Object getObject() {
            return this.object;
        }

        protected void update(Object fieldVal) {
            try {
                this.field.set(this.object, fieldVal);
                ObjectModFrame.this.notifyListeners();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private class CurrentCollectionGUIComponent
    extends NoRefGUIComponent
    implements ActionListener {
        private static final long serialVersionUID = 6031819767955928108L;
        private final JComboBox<?> box;
        private final CollectionWithCurrentElement<Object> col;

        CurrentCollectionGUIComponent(String name, Object obj, Field f) throws IllegalAccessException {
            super(obj, f);
            this.setLayout(new BoxLayout(this, 0));
            this.col = (CollectionWithCurrentElement)f.get(obj);
            this.box = new JComboBox<Object>(this.col.toArray());
            this.box.setSelectedItem(this.col.getCurrent());
            this.add(new JLabel(name));
            this.add(Box.createHorizontalStrut(10));
            this.add(this.box);
            this.box.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.col.setCurrent(this.box.getSelectedItem());
        }
    }

    private class EnumGUIComponent
    extends NoRefGUIComponent
    implements ActionListener {
        private static final long serialVersionUID = 3329099673991014137L;
        private final JComboBox<?> box;

        EnumGUIComponent(String name, Object obj, Field f) throws IllegalAccessException {
            super(obj, f);
            this.setLayout(new BoxLayout(this, 0));
            this.box = new JComboBox(f.getType().getEnumConstants());
            this.box.setSelectedItem(f.get(obj));
            this.add(new JLabel(name));
            this.add(Box.createHorizontalStrut(10));
            this.add(this.box);
            this.box.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update(this.box.getSelectedItem());
        }
    }

    private class BooleanGUIComponent
    extends NoRefGUIComponent
    implements ActionListener {
        private static final long serialVersionUID = -7149307455972615932L;
        private final JCheckBox box;

        BooleanGUIComponent(String name, Object obj, Field f) throws IllegalAccessException {
            super(obj, f);
            this.box = new JCheckBox(name, this.getField().getBoolean(this.getObject()));
            this.add(this.box);
            this.box.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update(this.box.isSelected());
        }
    }
}

