/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.jirf;

import com.google.common.primitives.Primitives;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.danilopianini.jirf.Factory;
import org.danilopianini.jirf.FactoryImpl;
import org.danilopianini.util.PrimitiveArrays;

public class FactoryBuilder {
    private final Factory factory = new FactoryImpl();
    private static final Function<Boolean, Integer> BOOL_TO_INT = b -> b != false ? 1 : 0;
    private static final Function<Integer, Boolean> INT_TO_BOOL = i -> i == 0;
    private final Semaphore mutex = new Semaphore(1);
    private boolean consumed;

    public FactoryBuilder withWideningConversions() {
        this.withAutoBoxing();
        this.factory.registerImplicit(Byte.TYPE, Short.TYPE, Number::shortValue);
        this.factory.registerImplicit(Byte.TYPE, Integer.TYPE, Number::intValue);
        this.factory.registerImplicit(Byte.TYPE, Long.TYPE, Number::longValue);
        this.factory.registerImplicit(Byte.TYPE, Float.TYPE, Number::floatValue);
        this.factory.registerImplicit(Byte.TYPE, Double.TYPE, Number::doubleValue);
        this.factory.registerImplicit(Short.TYPE, Integer.TYPE, Number::intValue);
        this.factory.registerImplicit(Short.TYPE, Long.TYPE, Number::longValue);
        this.factory.registerImplicit(Short.TYPE, Float.TYPE, Number::floatValue);
        this.factory.registerImplicit(Short.TYPE, Double.TYPE, Number::doubleValue);
        this.factory.registerImplicit(Character.TYPE, Integer.TYPE, Character::getNumericValue);
        this.factory.registerImplicit(Character.TYPE, Long.TYPE, c -> Character.getNumericValue(c.charValue()));
        this.factory.registerImplicit(Character.TYPE, Float.TYPE, c -> Float.valueOf(Character.getNumericValue(c.charValue())));
        this.factory.registerImplicit(Character.TYPE, Double.TYPE, c -> Character.getNumericValue(c.charValue()));
        this.factory.registerImplicit(Integer.TYPE, Long.TYPE, Number::longValue);
        this.factory.registerImplicit(Integer.TYPE, Float.TYPE, Number::floatValue);
        this.factory.registerImplicit(Integer.TYPE, Double.TYPE, Number::doubleValue);
        this.factory.registerImplicit(Long.TYPE, Float.TYPE, Number::floatValue);
        this.factory.registerImplicit(Long.TYPE, Double.TYPE, Number::doubleValue);
        this.factory.registerImplicit(Float.TYPE, Double.TYPE, Number::doubleValue);
        return this;
    }

    public <S> FactoryBuilder withAutoBoxing() {
        Primitives.allPrimitiveTypes().stream().filter(t -> !Void.TYPE.equals(t)).forEach(p -> {
            this.factory.registerImplicit(p, Primitives.wrap((Class)p), Function.identity());
            this.factory.registerImplicit(Primitives.wrap((Class)p), p, Function.identity());
        });
        return this;
    }

    public FactoryBuilder withNarrowingConversions() {
        this.withWideningConversions();
        this.factory.registerImplicit(Short.TYPE, Byte.TYPE, Number::byteValue);
        this.factory.registerImplicit(Integer.TYPE, Short.TYPE, Number::shortValue);
        this.factory.registerImplicit(Long.TYPE, Integer.TYPE, Number::intValue);
        this.factory.registerImplicit(Float.TYPE, Long.TYPE, Number::longValue);
        this.factory.registerImplicit(Double.TYPE, Long.TYPE, Number::longValue);
        this.factory.registerImplicit(Double.TYPE, Float.TYPE, Number::floatValue);
        return this;
    }

    public FactoryBuilder withArrayBoxing() {
        this.factory.registerImplicit(boolean[].class, Boolean[].class, ArrayUtils::toObject);
        this.factory.registerImplicit(byte[].class, Byte[].class, ArrayUtils::toObject);
        this.factory.registerImplicit(short[].class, Short[].class, ArrayUtils::toObject);
        this.factory.registerImplicit(int[].class, Integer[].class, ArrayUtils::toObject);
        this.factory.registerImplicit(long[].class, Long[].class, ArrayUtils::toObject);
        this.factory.registerImplicit(double[].class, Double[].class, ArrayUtils::toObject);
        this.factory.registerImplicit(float[].class, Float[].class, ArrayUtils::toObject);
        this.factory.registerImplicit(Boolean[].class, boolean[].class, ArrayUtils::toPrimitive);
        this.factory.registerImplicit(Byte[].class, byte[].class, ArrayUtils::toPrimitive);
        this.factory.registerImplicit(Short[].class, short[].class, ArrayUtils::toPrimitive);
        this.factory.registerImplicit(Integer[].class, int[].class, ArrayUtils::toPrimitive);
        this.factory.registerImplicit(Long[].class, long[].class, ArrayUtils::toPrimitive);
        this.factory.registerImplicit(Double[].class, double[].class, ArrayUtils::toPrimitive);
        this.factory.registerImplicit(Float[].class, float[].class, ArrayUtils::toPrimitive);
        return this;
    }

    public FactoryBuilder withBooleanIntConversions() {
        this.factory.registerImplicit(Boolean.TYPE, Integer.TYPE, BOOL_TO_INT);
        this.factory.registerImplicit(Integer.TYPE, Boolean.TYPE, INT_TO_BOOL);
        this.factory.registerImplicit(Boolean.class, Integer.class, BOOL_TO_INT);
        this.factory.registerImplicit(Integer.class, Boolean.class, INT_TO_BOOL);
        return this;
    }

    public FactoryBuilder withAutomaticToString() {
        this.factory.registerImplicit(Object.class, String.class, Object::toString);
        return this;
    }

    public FactoryBuilder withArrayWideningConversions() {
        this.withArrayBoxing();
        this.factory.registerImplicit(byte[].class, short[].class, PrimitiveArrays::toShortArray);
        this.factory.registerImplicit(byte[].class, int[].class, PrimitiveArrays::toIntArray);
        this.factory.registerImplicit(byte[].class, long[].class, PrimitiveArrays::toLongArray);
        this.factory.registerImplicit(byte[].class, float[].class, PrimitiveArrays::toFloatArray);
        this.factory.registerImplicit(byte[].class, double[].class, PrimitiveArrays::toDoubleArray);
        this.factory.registerImplicit(short[].class, int[].class, PrimitiveArrays::toIntArray);
        this.factory.registerImplicit(short[].class, long[].class, PrimitiveArrays::toLongArray);
        this.factory.registerImplicit(short[].class, float[].class, PrimitiveArrays::toFloatArray);
        this.factory.registerImplicit(short[].class, double[].class, PrimitiveArrays::toDoubleArray);
        this.factory.registerImplicit(char[].class, int[].class, PrimitiveArrays::toIntArray);
        this.factory.registerImplicit(char[].class, long[].class, PrimitiveArrays::toLongArray);
        this.factory.registerImplicit(char[].class, float[].class, PrimitiveArrays::toFloatArray);
        this.factory.registerImplicit(char[].class, double[].class, PrimitiveArrays::toDoubleArray);
        this.factory.registerImplicit(int[].class, long[].class, PrimitiveArrays::toLongArray);
        this.factory.registerImplicit(int[].class, float[].class, PrimitiveArrays::toFloatArray);
        this.factory.registerImplicit(int[].class, double[].class, PrimitiveArrays::toDoubleArray);
        this.factory.registerImplicit(long[].class, float[].class, PrimitiveArrays::toFloatArray);
        this.factory.registerImplicit(long[].class, double[].class, PrimitiveArrays::toDoubleArray);
        this.factory.registerImplicit(float[].class, double[].class, PrimitiveArrays::toDoubleArray);
        return this;
    }

    public FactoryBuilder withArrayNarrowingConversions() {
        this.withArrayWideningConversions();
        this.factory.registerImplicit(Byte[].class, Number[].class, Function.identity());
        this.factory.registerImplicit(Short[].class, Number[].class, Function.identity());
        this.factory.registerImplicit(Integer[].class, Number[].class, Function.identity());
        this.factory.registerImplicit(Long[].class, Number[].class, Function.identity());
        this.factory.registerImplicit(Float[].class, Number[].class, Function.identity());
        this.factory.registerImplicit(Double[].class, Number[].class, Function.identity());
        this.factory.registerImplicit(Number[].class, byte[].class, PrimitiveArrays::toByteArray);
        this.factory.registerImplicit(Number[].class, short[].class, PrimitiveArrays::toShortArray);
        this.factory.registerImplicit(Number[].class, int[].class, PrimitiveArrays::toIntArray);
        this.factory.registerImplicit(Number[].class, long[].class, PrimitiveArrays::toLongArray);
        this.factory.registerImplicit(Number[].class, float[].class, PrimitiveArrays::toFloatArray);
        this.factory.registerImplicit(Number[].class, double[].class, PrimitiveArrays::toDoubleArray);
        return this;
    }

    public FactoryBuilder withArrayBooleanIntConversions() {
        this.withArrayBoxing();
        this.factory.registerImplicit(boolean[].class, int[].class, PrimitiveArrays::toIntArray);
        this.factory.registerImplicit(int[].class, boolean[].class, PrimitiveArrays::toBooleanArray);
        this.factory.registerImplicit(Boolean[].class, Integer[].class, ba -> (Integer[])Arrays.stream(ba).map(BOOL_TO_INT).toArray(Integer[]::new));
        this.factory.registerImplicit(Integer[].class, Boolean[].class, ba -> (Boolean[])Arrays.stream(ba).map(INT_TO_BOOL).toArray(Boolean[]::new));
        return this;
    }

    public FactoryBuilder withArrayListConversions(Class<?> ... classes) {
        this.withArrayBoxing();
        for (Class<?> clazz : classes) {
            if (!clazz.isArray()) {
                throw new IllegalArgumentException("Only array classes can be mapped to Lists");
            }
            this.factory.registerImplicit(clazz, Object[].class, x -> (Object[])x);
            Class<?> componentType = clazz.getComponentType();
            this.factory.registerImplicit(Object[].class, clazz, x -> {
                Object array = Array.newInstance(componentType, ((Object[])x).length);
                for (int i = 0; i < ((Object[])x).length; ++i) {
                    Array.set(array, i, this.factory.convertOrFail(componentType, x[i]));
                }
                return array;
            });
        }
        this.factory.registerImplicit(Object[].class, List.class, Arrays::asList);
        this.factory.registerImplicit(List.class, Object[].class, List::toArray);
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This method must return the built object")
    public Factory build() {
        this.checkConsumed();
        return this.factory;
    }

    private void checkConsumed() {
        this.mutex.acquireUninterruptibly();
        if (this.consumed) {
            throw new IllegalStateException("This builder has already been used.");
        }
        this.consumed = true;
        this.mutex.release();
    }
}

