/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.jirf;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.danilopianini.jirf.CreationResult;
import org.danilopianini.jirf.Factory;
import org.danilopianini.jirf.FunctionEdge;
import org.danilopianini.jirf.ImmutableCreationResult;
import org.danilopianini.jirf.InstancingImpossibleException;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;

final class FactoryImpl
implements Factory {
    private final Map<Class<?>, Object> singletons = new LinkedHashMap();
    private final Graph<Class<?>, FunctionEdge> implicits = new DefaultDirectedGraph(null, null, false);
    private static final String UNCHECKED = "unchecked";
    private final LoadingCache<Pair<Class<?>, List<Class<?>>>, List<Pair<Constructor<?>, InstancingImpossibleException>>> loader = CacheBuilder.newBuilder().build(new CacheLoader<Pair<Class<?>, List<Class<?>>>, List<Pair<Constructor<?>, InstancingImpossibleException>>>(){

        @Nonnull
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"}, justification="False positive, there's no throws clause")
        public List<Pair<Constructor<?>, InstancingImpossibleException>> load(@Nonnull Pair<Class<?>, List<Class<?>>> key) {
            Constructor<?>[] constructors = ((Class)key.getKey()).getConstructors();
            List argumentTypes = (List)key.getValue();
            return Arrays.stream(constructors).map(c -> new ConstructorBenchmark(c, argumentTypes)).sorted().map(it -> new ImmutablePair(it.constructor, (Object)(it.score >= 0 ? null : new InstancingImpossibleException(it.constructor, "discarded because incompatible with provided parameters " + argumentTypes.stream().map(argType -> argType == null ? "null" : argType.getSimpleName()).collect(Collectors.toList()))))).collect(Collectors.toList());
        }
    });

    FactoryImpl() {
    }

    @Override
    public <E> CreationResult<E> build(Class<E> clazz, List<?> args) {
        this.registerHierarchy(clazz);
        ImmutableCreationResult.Builder<Object> resultBuilder = new ImmutableCreationResult.Builder<Object>();
        Optional<E> fromStatic = this.getFromStaticSources(clazz);
        if (fromStatic.isPresent()) {
            resultBuilder.withResult(fromStatic.get());
            return resultBuilder.build();
        }
        List argumentTypes = args.stream().map(it -> it == null ? null : it.getClass()).collect(Collectors.toList());
        List sortedConstructors = (List)this.loader.getUnchecked((Object)new ImmutablePair(clazz, argumentTypes));
        for (Pair maybeException : sortedConstructors) {
            Constructor constructor = (Constructor)maybeException.getKey();
            InstancingImpossibleException exception = (InstancingImpossibleException)maybeException.getValue();
            if (exception == null) {
                Object result = this.createBestEffort(constructor, args);
                if (result instanceof InstancingImpossibleException) {
                    resultBuilder.withFailure(constructor, (InstancingImpossibleException)result);
                    continue;
                }
                resultBuilder.withResult(result);
                return resultBuilder.build();
            }
            resultBuilder.withFailure(constructor, exception);
        }
        return resultBuilder.build();
    }

    @Override
    public <E> CreationResult<E> build(Class<E> clazz, Object ... parameters) {
        return this.build(clazz, Arrays.asList(parameters));
    }

    @Override
    public <I, O> Optional<O> convert(Class<O> destination, I source) {
        return this.findConversionChain(Objects.requireNonNull(source.getClass()), Objects.requireNonNull(destination)).map(chain -> {
            Object in = source;
            for (FunctionEdge implicit : chain.getEdgeList()) {
                in = implicit.getFunction().apply(in);
            }
            return in;
        });
    }

    private <E> Optional<E> getSingleton(Class<? super E> clazz) {
        return Optional.ofNullable(this.singletons.get(clazz));
    }

    private <E> Optional<E> getFromStaticSources(Class<E> clazz) {
        return this.getSingleton(clazz);
    }

    private Object createBestEffort(Constructor<?> constructor, List<?> params) {
        LinkedList paramsLeft = new LinkedList(params);
        Class<?>[] expectedTypes = constructor.getParameterTypes();
        Object[] actualArgs = new Object[expectedTypes.length];
        boolean varArgs = constructor.isVarArgs();
        for (int i = 0; i < expectedTypes.length; ++i) {
            Class<?> expected = expectedTypes[i];
            Optional<?> single = this.getFromStaticSources(expected);
            if (single.isPresent()) {
                actualArgs[i] = single.get();
                continue;
            }
            if (varArgs && i == expectedTypes.length - 1) {
                Object lastParam;
                Object converted;
                Class<?> type = expected.getComponentType();
                Object varargs = null;
                if (paramsLeft.size() == 1 && !((converted = this.convertIfNeeded(lastParam = paramsLeft.peek(), expected, constructor)) instanceof InstancingImpossibleException)) {
                    paramsLeft.pop();
                    varargs = converted;
                }
                int left = paramsLeft.size();
                varargs = varargs == null ? Array.newInstance(type, left) : varargs;
                for (int pn = 0; pn < left; ++pn) {
                    Object param = this.convertIfNeeded(paramsLeft.pop(), type, constructor);
                    if (param instanceof InstancingImpossibleException) {
                        return param;
                    }
                    Array.set(varargs, pn, param);
                }
                actualArgs[i] = varargs;
                continue;
            }
            Object param = this.convertIfNeeded(paramsLeft.pop(), expected, constructor);
            if (param instanceof InstancingImpossibleException) {
                return param;
            }
            actualArgs[i] = param;
        }
        try {
            return constructor.newInstance(actualArgs);
        }
        catch (Exception e) {
            return new InstancingImpossibleException(constructor, (Throwable)e);
        }
    }

    private Object convertIfNeeded(Object param, Class<?> expected, Constructor<?> constructor) {
        if (param == null || expected.isAssignableFrom(param.getClass())) {
            return param;
        }
        Optional<?> result = this.convert(expected, param);
        if (result.isPresent()) {
            return result.get();
        }
        return new InstancingImpossibleException(constructor, "Couldn't convert " + param + " from " + param.getClass().getName() + " to " + expected.getName());
    }

    private <S, D> Optional<GraphPath<Class<?>, FunctionEdge>> findConversionChain(Class<S> source, Class<D> destination) {
        this.registerHierarchy(source);
        this.registerHierarchy(destination);
        return Optional.ofNullable(DijkstraShortestPath.findPathBetween(this.implicits, source, destination));
    }

    @Override
    public Map<Class<?>, Object> getSingletonObjects() {
        return Collections.unmodifiableMap(this.singletons);
    }

    @Override
    public <S, D> void registerImplicit(Class<S> source, Class<D> target, Function<? super S, ? extends D> implicit) {
        this.registerHierarchy(source);
        this.registerHierarchy(target);
        this.addEdge(source, target, implicit);
    }

    private <S, D> void addEdge(Class<S> source, Class<D> target, Function<? super S, ? extends D> implicit) {
        this.loader.invalidateAll();
        this.implicits.removeEdge(source, target);
        if (!this.implicits.addEdge(source, target, (Object)new FunctionEdge(source, target, implicit))) {
            throw new IllegalStateException("edge from " + source + " to " + target + " was not added.This is likely a bug in jirf.");
        }
    }

    private <T> void registerHierarchy(Class<T> x) {
        assert (x != null);
        if (!this.implicits.containsVertex(x)) {
            this.implicits.addVertex(x);
            Class<T> superclass = x.getSuperclass();
            if (superclass != null) {
                this.registerHierarchy(superclass);
                this.addEdge(x, superclass, Function.identity());
            } else if (x.isInterface()) {
                this.addEdge(x, Object.class, Function.identity());
            }
            for (Class<?> iface : x.getInterfaces()) {
                this.registerHierarchy(iface);
                this.addEdge(x, iface, Function.identity());
            }
        }
    }

    @Override
    public <E> void registerSingleton(Class<? super E> lowerBound, Class<? super E> upperBound, E object) {
        this.register(this.singletons, Objects.requireNonNull(lowerBound), Objects.requireNonNull(upperBound), Objects.requireNonNull(object).getClass(), object);
    }

    @Override
    public <E> void registerSingleton(Class<? super E> bound, E object) {
        this.registerSingleton(Objects.requireNonNull(object).getClass(), bound, object);
    }

    @Override
    public <E> void registerSingleton(E object) {
        this.registerSingleton(Objects.requireNonNull(object).getClass(), object);
    }

    private static void checkSuperclass(Class<?> lower, Class<?> upper) {
        if (!upper.isAssignableFrom(lower)) {
            throw new IllegalArgumentException(upper + " must be a superclass of " + lower);
        }
    }

    private <E, O> void register(Map<Class<?>, O> map, Class<? super E> lowerbound, Class<? super E> upperbound, Class<? super E> clazz, O object) {
        FactoryImpl.checkSuperclass(Objects.requireNonNull(clazz), Objects.requireNonNull(lowerbound));
        FactoryImpl.checkSuperclass(lowerbound, Objects.requireNonNull(upperbound));
        for (Class<E> c = lowerbound; c != null && upperbound.isAssignableFrom(c); c = c.getSuperclass()) {
            if (map.put(c, Objects.requireNonNull(object)) != null) continue;
            this.loader.invalidateAll();
        }
        if (upperbound.isInterface()) {
            boolean lowerboundIsInterface = lowerbound.isInterface();
            for (Class type : ClassUtils.getAllInterfaces(clazz)) {
                if (!upperbound.isAssignableFrom(type) || lowerboundIsInterface && !type.isAssignableFrom(lowerbound) || map.put(type, object) != null) continue;
                this.loader.invalidateAll();
            }
        }
    }

    @Override
    public <I, O> O convertOrFail(Class<O> clazz, I target) {
        return this.convert(clazz, target).orElseThrow(() -> new IllegalArgumentException("Unable to convert " + target + " to " + clazz));
    }

    @Override
    public <E> boolean deregisterSingleton(E object) {
        Iterator<Object> regSingletons = this.singletons.values().iterator();
        boolean found = false;
        while (regSingletons.hasNext()) {
            Object singleton = regSingletons.next();
            if (!singleton.equals(object)) continue;
            regSingletons.remove();
            this.loader.invalidateAll();
            found = true;
        }
        return found;
    }

    private final class ConstructorBenchmark<T>
    implements Comparable<ConstructorBenchmark<T>> {
        private final Constructor<T> constructor;
        private final int score;

        ConstructorBenchmark(Constructor<T> constructor, List<Class<?>> args) {
            this.constructor = constructor;
            Class[] filteredParams = (Class[])Arrays.stream(constructor.getParameterTypes()).filter(clazz -> !FactoryImpl.this.singletons.containsKey(clazz)).toArray(Class[]::new);
            this.score = this.computeScore(filteredParams, args);
        }

        @Override
        public int compareTo(ConstructorBenchmark<T> o) {
            return this.score == o.score ? this.constructor.toString().compareTo(o.constructor.toString()) : Integer.compare(this.score, o.score);
        }

        private int computeScore(Class<?>[] filteredParams, List<Class<?>> argumentTypes) {
            int argsSize = argumentTypes.size();
            int numDiff = argsSize - filteredParams.length;
            if (numDiff == 0 || numDiff == -1 && this.constructor.isVarArgs()) {
                int tempScore = 0;
                for (int i = 0; i < argsSize; ++i) {
                    Class<?> argumentType = argumentTypes.get(i);
                    Class<?> expected = filteredParams[i];
                    if (argumentType == null) {
                        if (!expected.isPrimitive()) continue;
                        return -1;
                    }
                    if (expected.isAssignableFrom(argumentType)) continue;
                    tempScore += FactoryImpl.this.findConversionChain(argumentType, expected).map(GraphPath::getLength).orElse(FactoryImpl.this.implicits.edgeSet().size()).intValue();
                }
                return tempScore;
            }
            return numDiff > 0 ? Short.MAX_VALUE + numDiff : -1;
        }

        public boolean equals(Object obj) {
            return obj instanceof ConstructorBenchmark && this.constructor.equals(((ConstructorBenchmark)obj).constructor) && this.score == ((ConstructorBenchmark)obj).score;
        }

        public int hashCode() {
            return this.constructor.hashCode() ^ this.score;
        }

        public String toString() {
            return this.constructor + "->" + this.score;
        }
    }
}

