/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.jirf;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.danilopianini.jirf.CreationResult;
import org.danilopianini.jirf.InstancingImpossibleException;

public final class ImmutableCreationResult<T>
implements CreationResult<T> {
    private final T result;
    private final ImmutableMap<Constructor<T>, InstancingImpossibleException> exceptions;

    private ImmutableCreationResult(@Nullable T result, @Nonnull ImmutableMap<Constructor<T>, InstancingImpossibleException> exceptions) {
        this.result = result;
        this.exceptions = exceptions;
    }

    @Override
    public Optional<T> getCreatedObject() {
        return Optional.ofNullable(this.result);
    }

    @Override
    public T getCreatedObjectOrThrowException() {
        return this.getCreatedObject().orElseThrow(() -> {
            NoSuchElementException exception = new NoSuchElementException();
            for (InstancingImpossibleException entry : this.exceptions.values()) {
                exception.addSuppressed(entry);
            }
            throw exception;
        });
    }

    public String toString() {
        Optional<T> result = this.getCreatedObject();
        return "Result{" + (result.isPresent() ? result.get() : this.exceptions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableCreationResult that = (ImmutableCreationResult)o;
        return new EqualsBuilder().append(this.result, that.result).append(this.exceptions, that.exceptions).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.result).append(this.exceptions).toHashCode();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="the field is immutable")
    public ImmutableMap<Constructor<T>, InstancingImpossibleException> getExceptions() {
        return this.exceptions;
    }

    public static final class Builder<T> {
        private boolean isBuilt;
        private final ImmutableMap.Builder<Constructor<T>, InstancingImpossibleException> mapBuilder = new ImmutableMap.Builder();
        private T result;

        public Builder<T> withFailure(@Nonnull Constructor<T> constructor, @Nonnull InstancingImpossibleException error) {
            this.consistencyCheck();
            this.mapBuilder.put(constructor, (Object)error);
            return this;
        }

        public Builder<T> withResult(@Nonnull T result) {
            if (this.result != null) {
                throw new IllegalStateException("The result of this build has already been set.");
            }
            this.result = result;
            return this;
        }

        private void consistencyCheck() {
            if (this.isBuilt) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " cannot be modified after build(but can be used multiple times with the same configuration)");
            }
        }

        public ImmutableCreationResult<T> build() {
            this.isBuilt = true;
            return new ImmutableCreationResult<T>(this.result, this.mapBuilder.build());
        }
    }
}

