/*
 * Decompiled with CFR 0.152.
 */
package khttp.extensions;

import java.io.File;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import khttp.structures.files.FileLike;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a&\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u0002H\t0\b0\u0007\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\bH\u0000\u001a6\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r*\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u0010\u001a7\u0010\u0011\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r*\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u0012\u001a\u0002H\f2\u0006\u0010\u0013\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u0014\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u001a\u0010\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007*\u00020\u0016\u001a\u0014\u0010\u0019\u001a\u00020\u000b*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0000\u00a8\u0006\u001c"}, d2={"fileLike", "Lkhttp/structures/files/FileLike;", "Ljava/io/File;", "name", "", "Ljava/nio/file/Path;", "getSuperclasses", "", "Ljava/lang/Class;", "T", "putAllIfAbsentWithNull", "", "K", "V", "", "other", "", "putIfAbsentWithNull", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "split", "", "delimiter", "splitLines", "writeAndFlush", "Ljava/io/Writer;", "string", "khttp"})
public final class ExtensionsKt {
    @NotNull
    public static final FileLike fileLike(@NotNull File $this$fileLike, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$fileLike, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new FileLike(name, $this$fileLike);
    }

    public static /* synthetic */ FileLike fileLike$default(File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fun File.fileLike(name: \u2026e) = FileLike(name, this)");
            string = string2;
        }
        return ExtensionsKt.fileLike(file, string);
    }

    @NotNull
    public static final FileLike fileLike(@NotNull Path $this$fileLike) {
        Intrinsics.checkNotNullParameter((Object)$this$fileLike, (String)"<this>");
        return new FileLike($this$fileLike);
    }

    @NotNull
    public static final FileLike fileLike(@NotNull Path $this$fileLike, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$fileLike, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new FileLike(name, $this$fileLike);
    }

    @NotNull
    public static final FileLike fileLike(@NotNull String $this$fileLike, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$fileLike, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new FileLike(name, $this$fileLike);
    }

    public static final void writeAndFlush(@NotNull Writer $this$writeAndFlush, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAndFlush, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        $this$writeAndFlush.write(string);
        $this$writeAndFlush.flush();
    }

    @NotNull
    public static final List<byte[]> splitLines(@NotNull byte[] $this$splitLines) {
        Intrinsics.checkNotNullParameter((Object)$this$splitLines, (String)"<this>");
        if ($this$splitLines.length == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<byte[]> lines = new ArrayList<byte[]>();
        int lastSplit = 0;
        int skip = 0;
        int n = $this$splitLines.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            byte by = $this$splitLines[i];
            if (skip > 0) {
                int n2 = skip;
                skip = n2 + -1;
                continue;
            }
            if (by == 10) {
                lines.add(ArraysKt.sliceArray((byte[])$this$splitLines, (IntRange)new IntRange(lastSplit, i2 - 1)));
                lastSplit = i2 + 1;
                continue;
            }
            if (by != 13 || i2 + 1 >= $this$splitLines.length || $this$splitLines[i2 + 1] != 10) continue;
            skip = 1;
            lines.add(ArraysKt.sliceArray((byte[])$this$splitLines, (IntRange)new IntRange(lastSplit, i2 - 1)));
            lastSplit = i2 + 2;
        }
        ((Collection)lines).add(ArraysKt.sliceArray((byte[])$this$splitLines, (IntRange)new IntRange(lastSplit, $this$splitLines.length - 1)));
        return lines;
    }

    @NotNull
    public static final List<byte[]> split(@NotNull byte[] $this$split, @NotNull byte[] delimiter) {
        Intrinsics.checkNotNullParameter((Object)$this$split, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        ArrayList lines = new ArrayList();
        int lastSplit = 0;
        int skip = 0;
        int n = 0;
        int n2 = $this$split.length - 1;
        if (n <= n2) {
            int i;
            do {
                i = n++;
                if (skip > 0) {
                    int n3 = skip;
                    skip = n3 + -1;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)ArraysKt.toList((byte[])ArraysKt.sliceArray((byte[])$this$split, (IntRange)new IntRange(i, i + delimiter.length - 1))), (Object)ArraysKt.toList((byte[])delimiter))) continue;
                skip = delimiter.length;
                ((Collection)lines).add(ArraysKt.sliceArray((byte[])$this$split, (IntRange)new IntRange(lastSplit, i - 1)));
                lastSplit = i + delimiter.length;
            } while (i != n2);
        }
        ((Collection)lines).add(ArraysKt.sliceArray((byte[])$this$split, (IntRange)new IntRange(lastSplit, $this$split.length - 1)));
        return lines;
    }

    @NotNull
    public static final <T> List<Class<? super T>> getSuperclasses(@NotNull Class<T> $this$getSuperclasses) {
        Intrinsics.checkNotNullParameter($this$getSuperclasses, (String)"<this>");
        ArrayList<Class<T>> list = new ArrayList<Class<T>>();
        for (Class<T> superclass = $this$getSuperclasses.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            list.add(superclass);
        }
        return list;
    }

    public static final <K, V> void putIfAbsentWithNull(@NotNull Map<K, V> $this$putIfAbsentWithNull, K key, V value) {
        Intrinsics.checkNotNullParameter($this$putIfAbsentWithNull, (String)"<this>");
        if (!$this$putIfAbsentWithNull.containsKey(key)) {
            $this$putIfAbsentWithNull.put(key, value);
        }
    }

    public static final <K, V> void putAllIfAbsentWithNull(@NotNull Map<K, V> $this$putAllIfAbsentWithNull, @NotNull Map<K, ? extends V> other) {
        Intrinsics.checkNotNullParameter($this$putAllIfAbsentWithNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        for (Map.Entry<K, V> entry : other.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            ExtensionsKt.putIfAbsentWithNull($this$putAllIfAbsentWithNull, key, value);
        }
    }
}

