/*
 * Decompiled with CFR 0.152.
 */
package khttp.requests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.IDN;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import khttp.extensions.ExtensionsKt;
import khttp.requests.Request;
import khttp.structures.authorization.Authorization;
import khttp.structures.files.FileLike;
import khttp.structures.maps.CaseInsensitiveMutableMap;
import khttp.structures.parameters.Parameters;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0001DB\u00b1\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\tH\u0002J\u0010\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u0003H\u0002J\f\u0010;\u001a\u00020<*\u00020<H\u0002J1\u0010=\u001a\u00020\u0003\"\u0004\b\u0000\u0010>*\u0002H>2\u0018\u0010?\u001a\u0014\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u00020B0@H\u0002\u00a2\u0006\u0002\u0010CR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\"\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010%R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0016\u0010\n\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010'R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010%R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010\u0012\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001eR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010/\u00a8\u0006E"}, d2={"Lkhttp/requests/GenericRequest;", "Lkhttp/requests/Request;", "method", "", "url", "params", "", "headers", "data", "", "json", "auth", "Lkhttp/structures/authorization/Authorization;", "cookies", "timeout", "", "allowRedirects", "", "stream", "files", "", "Lkhttp/structures/files/FileLike;", "sslContext", "Ljavax/net/ssl/SSLContext;", "hostnameVerifier", "Ljavax/net/ssl/HostnameVerifier;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;Lkhttp/structures/authorization/Authorization;Ljava/util/Map;DLjava/lang/Boolean;ZLjava/util/List;Ljavax/net/ssl/SSLContext;Ljavax/net/ssl/HostnameVerifier;)V", "_body", "", "getAllowRedirects", "()Z", "getAuth", "()Lkhttp/structures/authorization/Authorization;", "body", "getBody", "()[B", "getCookies", "()Ljava/util/Map;", "getData", "()Ljava/lang/Object;", "getFiles", "()Ljava/util/List;", "getHeaders", "getHostnameVerifier", "()Ljavax/net/ssl/HostnameVerifier;", "getJson", "getMethod", "()Ljava/lang/String;", "getParams", "getSslContext", "()Ljavax/net/ssl/SSLContext;", "getStream", "getTimeout", "()D", "getUrl", "coerceToJSON", "any", "makeRoute", "route", "toIDN", "Ljava/net/URL;", "withJSONWriter", "T", "converter", "Lkotlin/Function2;", "Lorg/json/JSONWriter;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/String;", "Companion", "khttp"})
public final class GenericRequest
implements Request {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String method;
    @NotNull
    private final Map<String, String> params;
    @Nullable
    private final Object json;
    @Nullable
    private final Authorization auth;
    @Nullable
    private final Map<String, String> cookies;
    private final double timeout;
    private final boolean stream;
    @NotNull
    private final List<FileLike> files;
    @Nullable
    private final SSLContext sslContext;
    @NotNull
    private final String url;
    @NotNull
    private final Map<String, String> headers;
    @Nullable
    private final Object data;
    private final boolean allowRedirects;
    @NotNull
    private final HostnameVerifier hostnameVerifier;
    @Nullable
    private byte[] _body;
    @NotNull
    private static final Map<String, String> DEFAULT_HEADERS;
    @NotNull
    private static final Map<String, String> DEFAULT_DATA_HEADERS;
    @NotNull
    private static final Map<String, String> DEFAULT_FORM_HEADERS;
    @NotNull
    private static final Map<String, String> DEFAULT_UPLOAD_HEADERS;
    @NotNull
    private static final Map<String, String> DEFAULT_JSON_HEADERS;

    /*
     * WARNING - void declaration
     */
    public GenericRequest(@NotNull String method, @NotNull String url, @NotNull Map<String, String> params, @NotNull Map<String, String> headers, @Nullable Object data, @Nullable Object json, @Nullable Authorization auth, @Nullable Map<String, String> cookies, double timeout, @Nullable Boolean allowRedirects, boolean stream, @NotNull List<FileLike> files, @Nullable SSLContext sslContext, @Nullable HostnameVerifier hostnameVerifier) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Authorization auth2;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.method = method;
        this.params = params;
        this.json = json;
        this.auth = auth;
        this.cookies = cookies;
        this.timeout = timeout;
        this.stream = stream;
        this.files = files;
        this.sslContext = sslContext;
        Boolean bl = allowRedirects;
        boolean bl2 = this.allowRedirects = bl != null ? bl : !Intrinsics.areEqual((Object)this.getMethod(), (Object)"HEAD");
        HostnameVerifier hostnameVerifier2 = hostnameVerifier;
        if (hostnameVerifier2 == null) {
            hostnameVerifier2 = GenericRequest::hostnameVerifier$lambda-0;
        }
        this.hostnameVerifier = hostnameVerifier2;
        this.url = this.makeRoute(url);
        Object[] objectArray = new String[]{"http", "https"};
        if (!SetsKt.setOf((Object[])objectArray).contains(new URI(this.getUrl()).getScheme())) {
            throw new IllegalArgumentException("Invalid schema. Only http:// and https:// are supported.");
        }
        Object json2 = this.getJson();
        CaseInsensitiveMutableMap mutableHeaders = new CaseInsensitiveMutableMap(MapsKt.toSortedMap(headers));
        if (json2 == null) {
            this.data = data;
            if (data != null && this.getFiles().isEmpty()) {
                if (data instanceof Map) {
                    ExtensionsKt.putAllIfAbsentWithNull(mutableHeaders, DEFAULT_FORM_HEADERS);
                } else {
                    ExtensionsKt.putAllIfAbsentWithNull(mutableHeaders, DEFAULT_DATA_HEADERS);
                }
            }
        } else {
            this.data = this.coerceToJSON(json2);
            ExtensionsKt.putAllIfAbsentWithNull(mutableHeaders, DEFAULT_JSON_HEADERS);
        }
        ExtensionsKt.putAllIfAbsentWithNull(mutableHeaders, DEFAULT_HEADERS);
        if (!((Collection)this.getFiles()).isEmpty()) {
            ExtensionsKt.putAllIfAbsentWithNull(mutableHeaders, DEFAULT_UPLOAD_HEADERS);
            if (((Map)mutableHeaders).containsKey("Content-Type")) {
                String string;
                Map map = mutableHeaders;
                String string2 = "Content-Type";
                String string3 = (String)mutableHeaders.get((Object)"Content-Type");
                if (string3 != null) {
                    String string4 = string3;
                    Object[] objectArray2 = new Object[1];
                    String string5 = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"randomUUID().toString()");
                    objectArray2[0] = StringsKt.replace$default((String)string5, (String)"-", (String)"", (boolean)false, (int)4, null);
                    String string6 = String.format(string4, Arrays.copyOf(objectArray2, objectArray2.length));
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(this, *args)");
                } else {
                    string = null;
                }
                String string7 = string;
                map.put(string2, string7);
            }
        }
        if ((auth2 = this.getAuth()) != null) {
            Pair<String, String> header = auth2.getHeader();
            ((Map)mutableHeaders).put(header.getFirst(), header.getSecond());
        }
        Map $this$filterValues$iv = mutableHeaders;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl3 = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl4 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl5 = false;
            Object v = it.getValue();
            Intrinsics.checkNotNull(v);
            String string = (String)v;
            map2.put(k, string);
        }
        Map nonNullHeaders = MapsKt.toSortedMap((Map)destination$iv$iv);
        this.headers = new CaseInsensitiveMutableMap(nonNullHeaders);
    }

    @Override
    @NotNull
    public String getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    @Nullable
    public Object getJson() {
        return this.json;
    }

    @Override
    @Nullable
    public Authorization getAuth() {
        return this.auth;
    }

    @Override
    @Nullable
    public Map<String, String> getCookies() {
        return this.cookies;
    }

    @Override
    public double getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean getStream() {
        return this.stream;
    }

    @Override
    @NotNull
    public List<FileLike> getFiles() {
        return this.files;
    }

    @Override
    @Nullable
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    @Nullable
    public Object getData() {
        return this.data;
    }

    @Override
    public boolean getAllowRedirects() {
        return this.allowRedirects;
    }

    @Override
    @NotNull
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] getBody() {
        if (this._body == null) {
            Object data;
            Object object;
            String[] $this$mapValuesTo$iv$iv;
            Iterator destination$iv$iv;
            Object requestData = this.getData();
            List<FileLike> files = this.getFiles();
            if (requestData == null && files.isEmpty()) {
                if (this._body == null) {
                    throw new IllegalStateException("Set to null by another thread");
                }
                this._body = new byte[0];
                return this._body;
            }
            if (requestData != null) {
                if (requestData instanceof Map && !(requestData instanceof Parameters)) {
                    void $this$mapValues$iv;
                    Object object2;
                    Object it;
                    Object object3;
                    void $this$mapKeysTo$iv$iv;
                    Map $this$mapKeys$iv = (Map)requestData;
                    boolean $i$f$mapKeys = false;
                    Map map = $this$mapKeys$iv;
                    destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                    boolean bl = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        object3 = destination$iv$iv;
                        boolean bl2 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        object2 = String.valueOf(it.getKey());
                        Map map2 = object3;
                        boolean bl22 = false;
                        it = it$iv$iv.getValue();
                        map2.put(object2, it);
                    }
                    $this$mapKeys$iv = destination$iv$iv;
                    boolean $i$f$mapValues = false;
                    $this$mapKeysTo$iv$iv = $this$mapValues$iv;
                    destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean bl3 = false;
                    $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it2;
                        void it$iv$iv;
                        it = (Map.Entry)element$iv$iv$iv;
                        Iterator iterator = destination$iv$iv;
                        boolean bl4 = false;
                        object2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        object3 = iterator;
                        boolean bl32 = false;
                        String string = String.valueOf(it2.getValue());
                        object3.put(k, string);
                    }
                    Iterator iterator = destination$iv$iv;
                    object = new Parameters((Map<String, String>)((Object)iterator));
                } else {
                    object = requestData;
                }
            } else {
                object = data = null;
            }
            if (data != null && !((Collection)files).isEmpty() && !(data instanceof Map)) {
                boolean $i$a$-require-GenericRequest$body$232 = false;
                String $i$a$-require-GenericRequest$body$232 = "data must be a Map";
                throw new IllegalArgumentException($i$a$-require-GenericRequest$body$232.toString());
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            if (!((Collection)files).isEmpty()) {
                String string = this.getHeaders().get("Content-Type");
                Intrinsics.checkNotNull((Object)string);
                $this$mapValuesTo$iv$iv = new String[]{"boundary="};
                String boundary = (String)StringsKt.split$default((CharSequence)string, (String[])$this$mapValuesTo$iv$iv, (boolean)false, (int)0, (int)6, null).get(1);
                destination$iv$iv = bytes;
                Charset charset = Charsets.UTF_8;
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)destination$iv$iv), charset);
                if (data != null) {
                    for (Map.Entry entry : ((Map)data).entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        ExtensionsKt.writeAndFlush(writer, "--" + boundary + "\r\n");
                        String keyString = String.valueOf(key);
                        ExtensionsKt.writeAndFlush(writer, "Content-Disposition: form-data; name=\"" + keyString + "\"\r\n\r\n");
                        ExtensionsKt.writeAndFlush(writer, String.valueOf(value));
                        ExtensionsKt.writeAndFlush(writer, "\r\n");
                    }
                }
                Iterable $this$forEach$iv = files;
                boolean bl = false;
                for (Object element$iv : $this$forEach$iv) {
                    FileLike it = (FileLike)element$iv;
                    boolean bl5 = false;
                    ExtensionsKt.writeAndFlush(writer, "--" + boundary + "\r\n");
                    ExtensionsKt.writeAndFlush(writer, "Content-Disposition: form-data; name=\"" + it.getFieldName() + "\"; filename=\"" + it.getFileName() + "\"\r\n\r\n");
                    bytes.write(it.getContents());
                    ExtensionsKt.writeAndFlush(writer, "\r\n");
                }
                ExtensionsKt.writeAndFlush(writer, "--" + boundary + "--\r\n");
                writer.close();
            } else if (!(data instanceof File) && !(data instanceof InputStream)) {
                String string = String.valueOf(data);
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                bytes.write(byArray);
            }
            this._body = bytes.toByteArray();
        }
        if (this._body == null) {
            throw new IllegalStateException("Set to null by another thread");
        }
        return this._body;
    }

    /*
     * WARNING - void declaration
     */
    private final String coerceToJSON(Object any) {
        if (any instanceof JSONObject || any instanceof JSONArray) {
            return any.toString();
        }
        if (any instanceof Map) {
            void $this$mapKeysTo$iv$iv;
            Map $this$mapKeys$iv = (Map)any;
            boolean $i$f$mapKeys = false;
            Map map = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = String.valueOf(it.getKey());
                Map map3 = map2;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map3.put(string, entry);
            }
            Map map4 = destination$iv$iv;
            String string = new JSONObject(map4).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject(any.mapKeys {\u2026.toString() }).toString()");
            return string;
        }
        if (any instanceof Collection) {
            String string = new JSONArray((Collection)any).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONArray(any).toString()");
            return string;
        }
        if (any instanceof Iterable) {
            return this.withJSONWriter(any, (Function2)new Function2<JSONWriter, Iterable<?>, Unit>(any){
                final /* synthetic */ Object $any;
                {
                    this.$any = $any;
                    super(2);
                }

                public final void invoke(@NotNull JSONWriter jsonWriter, @NotNull Iterable<?> iterable) {
                    Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
                    Intrinsics.checkNotNullParameter(iterable, (String)"<anonymous parameter 1>");
                    jsonWriter.array();
                    for (T thing : (Iterable)this.$any) {
                        jsonWriter.value(thing);
                    }
                    jsonWriter.endArray();
                }
            });
        }
        if (any instanceof Object[]) {
            String string = new JSONArray(any).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONArray(any).toString()");
            return string;
        }
        throw new IllegalArgumentException("Could not coerce " + any.getClass().getSimpleName() + " to JSON.");
    }

    private final <T> String withJSONWriter(T $this$withJSONWriter, Function2<? super JSONWriter, ? super T, Unit> converter) {
        StringWriter stringWriter = new StringWriter();
        JSONWriter writer = new JSONWriter((Appendable)stringWriter);
        converter.invoke((Object)writer, $this$withJSONWriter);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringWriter.toString()");
        return string;
    }

    private final URL toIDN(URL $this$toIDN) {
        Field field;
        String newHost = IDN.toASCII($this$toIDN.getHost());
        Field $this$toIDN_u24lambda_u2d8 = field = $this$toIDN.getClass().getDeclaredField("host");
        boolean bl = false;
        $this$toIDN_u24lambda_u2d8.setAccessible(true);
        field.set($this$toIDN, newHost);
        Field $this$toIDN_u24lambda_u2d9 = field = $this$toIDN.getClass().getDeclaredField("authority");
        boolean bl2 = false;
        $this$toIDN_u24lambda_u2d9.setAccessible(true);
        field.set($this$toIDN, $this$toIDN.getPort() == -1 ? $this$toIDN.getHost() : $this$toIDN.getHost() + ':' + $this$toIDN.getPort());
        String query = $this$toIDN.getQuery() == null ? (String)null : URLDecoder.decode($this$toIDN.getQuery(), "UTF-8");
        return new URL(new URI($this$toIDN.getProtocol(), $this$toIDN.getUserInfo(), $this$toIDN.getHost(), $this$toIDN.getPort(), $this$toIDN.getPath(), query, $this$toIDN.getRef()).toASCIIString());
    }

    private final String makeRoute(String route) {
        String string = this.toIDN(new URL(route + (!this.getParams().isEmpty() ? "" + '?' + new Parameters(this.getParams()) : ""))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URL(route + if (this.par\u2026se \"\").toIDN().toString()");
        return string;
    }

    private static final boolean hostnameVerifier$lambda-0(String hostname, SSLSession session) {
        return StringsKt.equals((String)hostname, (String)session.getPeerHost(), (boolean)true);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept", (Object)"*/*"), TuplesKt.to((Object)"Accept-Encoding", (Object)"gzip, deflate"), TuplesKt.to((Object)"User-Agent", (Object)"khttp/1.0.0-SNAPSHOT")};
        DEFAULT_HEADERS = MapsKt.mapOf((Pair[])pairArray);
        DEFAULT_DATA_HEADERS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"text/plain"));
        DEFAULT_FORM_HEADERS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/x-www-form-urlencoded"));
        DEFAULT_UPLOAD_HEADERS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"multipart/form-data; boundary=%s"));
        DEFAULT_JSON_HEADERS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json"));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkhttp/requests/GenericRequest$Companion;", "", "()V", "DEFAULT_DATA_HEADERS", "", "", "getDEFAULT_DATA_HEADERS", "()Ljava/util/Map;", "DEFAULT_FORM_HEADERS", "getDEFAULT_FORM_HEADERS", "DEFAULT_HEADERS", "getDEFAULT_HEADERS", "DEFAULT_JSON_HEADERS", "getDEFAULT_JSON_HEADERS", "DEFAULT_UPLOAD_HEADERS", "getDEFAULT_UPLOAD_HEADERS", "khttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getDEFAULT_HEADERS() {
            return DEFAULT_HEADERS;
        }

        @NotNull
        public final Map<String, String> getDEFAULT_DATA_HEADERS() {
            return DEFAULT_DATA_HEADERS;
        }

        @NotNull
        public final Map<String, String> getDEFAULT_FORM_HEADERS() {
            return DEFAULT_FORM_HEADERS;
        }

        @NotNull
        public final Map<String, String> getDEFAULT_UPLOAD_HEADERS() {
            return DEFAULT_UPLOAD_HEADERS;
        }

        @NotNull
        public final Map<String, String> getDEFAULT_JSON_HEADERS() {
            return DEFAULT_JSON_HEADERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

