/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.gradle.mavencentral;

import java.time.Duration;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.danilopianini.gradle.mavencentral.NexusStatefulOperation;
import org.danilopianini.gradle.mavencentral.Repository;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/danilopianini/gradle/mavencentral/InitializeNexusClient;", "Lorg/gradle/api/DefaultTask;", "repoToConfigure", "Lorg/danilopianini/gradle/mavencentral/Repository;", "nexusUrl", "", "(Lorg/danilopianini/gradle/mavencentral/Repository;Ljava/lang/String;)V", "nexusClient", "Lorg/danilopianini/gradle/mavencentral/NexusStatefulOperation;", "getNexusClient", "()Lorg/danilopianini/gradle/mavencentral/NexusStatefulOperation;", "setNexusClient", "(Lorg/danilopianini/gradle/mavencentral/NexusStatefulOperation;)V", "getNexusUrl", "()Ljava/lang/String;", "getRepoToConfigure", "()Lorg/danilopianini/gradle/mavencentral/Repository;", "initializeClient", "", "publish-on-central"})
public class InitializeNexusClient
extends DefaultTask {
    @Input
    @NotNull
    private final Repository repoToConfigure;
    @Input
    @NotNull
    private final String nexusUrl;
    @Internal
    public NexusStatefulOperation nexusClient;

    @Inject
    public InitializeNexusClient(@NotNull Repository repoToConfigure, @NotNull String nexusUrl) {
        Intrinsics.checkNotNullParameter((Object)repoToConfigure, (String)"repoToConfigure");
        Intrinsics.checkNotNullParameter((Object)nexusUrl, (String)"nexusUrl");
        this.repoToConfigure = repoToConfigure;
        this.nexusUrl = nexusUrl;
    }

    @NotNull
    public final Repository getRepoToConfigure() {
        return this.repoToConfigure;
    }

    @NotNull
    public final String getNexusUrl() {
        return this.nexusUrl;
    }

    @NotNull
    public final NexusStatefulOperation getNexusClient() {
        NexusStatefulOperation nexusStatefulOperation = this.nexusClient;
        if (nexusStatefulOperation != null) {
            return nexusStatefulOperation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nexusClient");
        return null;
    }

    public final void setNexusClient(@NotNull NexusStatefulOperation nexusStatefulOperation) {
        Intrinsics.checkNotNullParameter((Object)nexusStatefulOperation, (String)"<set-?>");
        this.nexusClient = nexusStatefulOperation;
    }

    @TaskAction
    public final void initializeClient() {
        Project project = this.getProject();
        String string = this.nexusUrl;
        String string2 = this.getProject().getGroup().toString();
        Property<String> property = this.repoToConfigure.getUser();
        Property<String> property2 = this.repoToConfigure.getPassword();
        Duration duration = this.repoToConfigure.getNexusTimeOut();
        Duration duration2 = this.repoToConfigure.getNexusConnectTimeOut();
        Intrinsics.checkNotNull((Object)project);
        this.setNexusClient(new NexusStatefulOperation(project, string, (Provider<String>)((Provider)property), (Provider<String>)((Provider)property2), duration, duration2, string2));
    }
}

