/*
 * Decompiled with CFR 0.152.
 */
package org.kaikikm.threadresloader;

import java.net.URL;
import java.net.URLClassLoader;

class AccessibleURLClassLoader
extends URLClassLoader {
    private static final URL[] EMPTY = new URL[0];

    AccessibleURLClassLoader(ClassLoader parent, URL ... urls) {
        super(urls, parent);
    }

    AccessibleURLClassLoader(ClassLoader parent) {
        this(parent, EMPTY);
    }

    AccessibleURLClassLoader(URL ... urls) {
        this(Thread.currentThread().getContextClassLoader(), urls);
    }

    AccessibleURLClassLoader() {
        this(EMPTY);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

