/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedEntityStatus;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServiceInstance;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.vsphere.PrivateCloud;

public class Dc
implements DataCenterServices {
    private PrivateCloud provider;

    Dc(@Nonnull PrivateCloud cloud) {
        this.provider = cloud;
    }

    @Nonnull
    private ProviderContext getContext() throws CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        return ctx;
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = this.provider.getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    @Nullable
    public DataCenter getDataCenter(@Nonnull String dcId) throws InternalException, CloudException {
        String regionId = this.getContext().getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was specified for this request.");
        }
        for (DataCenter dc : this.listDataCenters(regionId)) {
            if (!dcId.equals(dc.getProviderDataCenterId())) continue;
            return dc;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "data center";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "region";
    }

    @Nullable
    public Region getRegion(@Nonnull String regionId) throws InternalException, CloudException {
        for (Region region : this.listRegions()) {
            if (!region.getProviderRegionId().equals(regionId)) continue;
            return region;
        }
        return null;
    }

    @Nullable
    public ResourcePool getResourcePoolFromClusterId(@Nonnull ServiceInstance service, @Nonnull String dcId) throws CloudException, InternalException {
        ManagedEntity[] clusters;
        ServiceInstance instance = this.getServiceInstance();
        DataCenter dsdc = this.getDataCenter(dcId);
        if (dsdc == null) {
            return null;
        }
        Datacenter dc = this.getVmwareDatacenterFromVDCId(instance, dsdc.getRegionId());
        if (dc == null) {
            return null;
        }
        try {
            clusters = new InventoryNavigator((ManagedEntity)dc).searchManagedEntities("ClusterComputeResource");
        }
        catch (InvalidProperty e) {
            throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new CloudException("Error in processing request to cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in cluster processing request: " + e.getMessage());
        }
        for (ManagedEntity entity : clusters) {
            ClusterComputeResource cluster = (ClusterComputeResource)entity;
            if (!cluster.getName().equals(dcId)) continue;
            return cluster.getResourcePool();
        }
        return null;
    }

    @Nullable
    public Datacenter getVmwareDatacenterFromVDCId(@Nonnull ServiceInstance service, @Nonnull String dcId) throws CloudException, InternalException {
        Folder rootFolder = service.getRootFolder();
        try {
            return (Datacenter)new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntity("Datacenter", dcId);
        }
        catch (InvalidProperty e) {
            throw new InternalException("Invalid DC property: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new InternalException("Error talking to the cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in processing the request in the cluster: " + e.getMessage());
        }
    }

    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String regionId) throws InternalException, CloudException {
        if (!this.provider.isClusterBased()) {
            return this.listDataCentersFromVDCs(regionId);
        }
        return this.listDataCentersFromClusters(regionId);
    }

    @Nonnull
    private Collection<DataCenter> listDataCentersFromClusters(@Nonnull String regionId) throws InternalException, CloudException {
        ManagedEntity[] clusters;
        ArrayList<DataCenter> dataCenters = new ArrayList<DataCenter>();
        ServiceInstance instance = this.getServiceInstance();
        Datacenter dc = this.getVmwareDatacenterFromVDCId(instance, regionId);
        if (dc == null) {
            throw new CloudException("No such region: " + regionId);
        }
        try {
            clusters = new InventoryNavigator((ManagedEntity)dc).searchManagedEntities("ClusterComputeResource");
        }
        catch (InvalidProperty e) {
            throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new CloudException("Error in processing request to cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in cluster processing request: " + e.getMessage());
        }
        for (ManagedEntity entity : clusters) {
            ClusterComputeResource cluster = (ClusterComputeResource)entity;
            DataCenter dataCenter = this.toDataCenter(cluster, regionId);
            if (dataCenter == null) continue;
            dataCenters.add(dataCenter);
        }
        return dataCenters;
    }

    @Nonnull
    private Collection<DataCenter> listDataCentersFromVDCs(@Nonnull String regionId) throws InternalException, CloudException {
        ManagedEntity[] mes;
        ArrayList<DataCenter> dataCenters = new ArrayList<DataCenter>();
        ServiceInstance instance = this.getServiceInstance();
        Folder rootFolder = instance.getRootFolder();
        try {
            mes = new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntities("Datacenter");
        }
        catch (InvalidProperty e) {
            throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new CloudException("Error in processing request to cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in cluster processing request: " + e.getMessage());
        }
        if (mes == null || mes.length < 1) {
            return dataCenters;
        }
        for (ManagedEntity entity : mes) {
            DataCenter dc = this.toDataCenter((Datacenter)entity, regionId);
            if (dc == null) continue;
            dataCenters.add(dc);
        }
        return dataCenters;
    }

    @Nonnull
    public Collection<Region> listRegions() throws InternalException, CloudException {
        if (!this.provider.isClusterBased()) {
            return this.listRegionsFromEndpoints();
        }
        return this.listRegionsFromVDCs();
    }

    @Nonnull
    private Collection<Region> listRegionsFromVDCs() throws InternalException, CloudException {
        ManagedEntity[] mes;
        ArrayList<Region> regions = new ArrayList<Region>();
        ServiceInstance instance = this.getServiceInstance();
        Folder rootFolder = instance.getRootFolder();
        try {
            mes = new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntities("Datacenter");
        }
        catch (InvalidProperty e) {
            throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new CloudException("Error in processing request to cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in cluster processing request: " + e.getMessage());
        }
        if (mes == null || mes.length < 1) {
            return regions;
        }
        for (ManagedEntity entity : mes) {
            Region r = this.toRegion((Datacenter)entity);
            if (r == null) continue;
            regions.add(r);
        }
        return regions;
    }

    @Nonnull
    private String getRegionId(@Nonnull String endpoint) {
        try {
            URI uri = new URI(endpoint);
            return uri.getHost();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Nonnull
    private Collection<Region> listRegionsFromEndpoints() throws InternalException, CloudException {
        ArrayList<Region> regions = new ArrayList<Region>();
        String endpoint = this.getContext().getEndpoint();
        if (endpoint != null) {
            regions.add(this.toRegion(this.getRegionId(endpoint)));
        }
        return regions;
    }

    @Nullable
    private DataCenter toDataCenter(@Nullable ClusterComputeResource cluster, @Nonnull String regionId) {
        if (cluster == null) {
            return null;
        }
        ManagedEntityStatus status = cluster.getOverallStatus();
        DataCenter dc = new DataCenter();
        dc.setActive(true);
        dc.setActive(!status.equals((Object)ManagedEntityStatus.red));
        dc.setAvailable(true);
        dc.setName(cluster.getName());
        dc.setProviderDataCenterId(cluster.getName());
        dc.setRegionId(regionId);
        return dc;
    }

    @Nullable
    private DataCenter toDataCenter(@Nullable Datacenter dc, @Nonnull String regionId) {
        if (dc != null) {
            DataCenter dsDc = new DataCenter();
            dsDc.setActive(true);
            dsDc.setAvailable(true);
            dsDc.setName(dc.getName());
            dsDc.setProviderDataCenterId(dc.getName());
            dsDc.setRegionId(regionId);
            return dsDc;
        }
        return null;
    }

    @Nullable
    private Region toRegion(@Nullable Datacenter dc) {
        if (dc == null) {
            return null;
        }
        Region region = new Region();
        region.setActive(true);
        region.setAvailable(true);
        region.setJurisdiction("US");
        region.setName(dc.getName());
        region.setProviderRegionId(dc.getName());
        return region;
    }

    @Nonnull
    private Region toRegion(@Nonnull String regionId) {
        Region region = new Region();
        region.setActive(true);
        region.setAvailable(true);
        region.setName(regionId);
        region.setProviderRegionId(regionId);
        return region;
    }
}

