/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineGuestOsIdentifier;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.vsphere.PrivateCloud;

public class Template
extends AbstractImageSupport {
    private PrivateCloud provider;

    Template(@Nonnull PrivateCloud cloud) {
        super((CloudProvider)cloud);
        this.provider = cloud;
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = this.provider.getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        ServiceInstance service = this.getServiceInstance();
        VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(service, providerImageId);
        if (vm == null) {
            throw new CloudException("No such template: " + providerImageId);
        }
        try {
            vm.destroy_Task();
        }
        catch (RemoteException e) {
            throw new CloudException((Throwable)e);
        }
    }

    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        for (ImageClass cls : this.listSupportedImageClasses()) {
            for (MachineImage image : this.listImages(cls)) {
                if (!image.getProviderMachineImageId().equals(providerImageId)) continue;
                return image;
            }
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return "template";
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        return Collections.singletonList(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageType.VOLUME);
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private MachineImage toMachineImage(@Nullable VirtualMachine template) throws InternalException, CloudException {
        if (template != null) {
            Platform platform;
            VirtualMachineGuestOsIdentifier os;
            VirtualMachineConfigInfo vminfo;
            MachineImage image = new MachineImage();
            try {
                vminfo = template.getConfig();
            }
            catch (RuntimeException e) {
                return null;
            }
            try {
                os = VirtualMachineGuestOsIdentifier.valueOf((String)vminfo.getGuestId());
                platform = Platform.guess((String)vminfo.getGuestFullName());
            }
            catch (IllegalArgumentException e) {
                System.out.println("DEBUG: No such guest in enum: " + vminfo.getGuestId());
                os = null;
                platform = Platform.guess((String)vminfo.getGuestId());
            }
            if (os == null) {
                image.setArchitecture(vminfo.getGuestId().contains("64") ? Architecture.I32 : Architecture.I64);
            } else {
                image.setArchitecture(this.provider.getComputeServices().getVirtualMachineSupport().getArchitecture(os));
            }
            image.setImageClass(ImageClass.MACHINE);
            image.setDescription(template.getName());
            image.setName(template.getName());
            image.setProviderOwnerId(this.getContext().getAccountNumber());
            image.setPlatform(platform);
            image.setProviderMachineImageId(vminfo.getUuid());
            image.setType(MachineImageType.VOLUME);
            image.setProviderRegionId(this.getContext().getRegionId());
            image.setSoftware("");
            image.setTags(new HashMap());
            VirtualMachineRuntimeInfo runtime = template.getRuntime();
            VirtualMachinePowerState state = VirtualMachinePowerState.poweredOff;
            if (runtime != null) {
                state = runtime.getPowerState();
            }
            if (state.equals((Object)VirtualMachinePowerState.poweredOff)) {
                image.setCurrentState(MachineImageState.ACTIVE);
            } else {
                image.setCurrentState(MachineImageState.PENDING);
            }
            return image;
        }
        return null;
    }

    public boolean hasPublicLibrary() {
        return false;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        String vmId = options.getVirtualMachineId();
        if (vmId == null) {
            throw new CloudException("You must specify a virtual machine to capture");
        }
        ServiceInstance service = this.getServiceInstance();
        VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(service, vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine for imaging: " + vmId);
        }
        MachineImage img = this.toMachineImage(this.provider.getComputeServices().getVirtualMachineSupport().clone(service, vm, options.getName(), true));
        if (img == null) {
            throw new CloudException("Failed to identify newly created template");
        }
        if (task != null) {
            task.completeWithResult((Object)img);
        }
        return img;
    }

    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        ArrayList<ResourceStatus> status = new ArrayList<ResourceStatus>();
        for (MachineImage img : this.listImages(cls)) {
            status.add(new ResourceStatus(img.getProviderMachineImageId(), (Object)img.getCurrentState()));
        }
        return status;
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nullable ImageFilterOptions options) throws CloudException, InternalException {
        ManagedEntity[] mes;
        ArrayList<MachineImage> machineImages = new ArrayList<MachineImage>();
        ServiceInstance instance = this.getServiceInstance();
        Folder folder = this.provider.getVmFolder(instance);
        try {
            mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
        }
        catch (InvalidProperty e) {
            throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
        }
        catch (RuntimeFault e) {
            throw new CloudException("Error in processing request to cluster: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CloudException("Error in cluster processing request: " + e.getMessage());
        }
        if (mes != null && mes.length > 0) {
            for (ManagedEntity entity : mes) {
                MachineImage image;
                VirtualMachine template = (VirtualMachine)entity;
                if (template == null) continue;
                VirtualMachineConfigInfo cfg = null;
                try {
                    cfg = template.getConfig();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                if (cfg == null || !cfg.isTemplate() || (image = this.toMachineImage(template)) == null || options != null && !options.matches(image)) continue;
                machineImages.add(image);
            }
        }
        return machineImages;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.VMDK);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<MachineImage> searchMachineImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture) throws CloudException, InternalException {
        return this.searchImages(null, keyword, platform, architecture, new ImageClass[]{ImageClass.MACHINE});
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... imageClasses) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public boolean supportsCustomImages() {
        return true;
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return type.equals((Object)MachineImageType.VOLUME);
    }

    public boolean supportsImageSharing() {
        return false;
    }

    public boolean supportsImageSharingWithPublic() {
        return false;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return false;
    }
}

