/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import com.vmware.vim25.ArrayOfHostDatastoreBrowserSearchResults;
import com.vmware.vim25.FileInfo;
import com.vmware.vim25.HostDatastoreBrowserSearchResults;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecFileOperation;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceFileBackingInfo;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualLsiLogicSASController;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualSCSIController;
import com.vmware.vim25.VirtualSCSISharing;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.FileManager;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostDatastoreBrowser;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.compute.AbstractVolumeSupport;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCapabilities;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.StoragePool;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.vsphere.PrivateCloud;
import org.dasein.cloud.vsphere.compute.HardDiskCapabilities;
import org.dasein.cloud.vsphere.compute.Vm;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class HardDisk
extends AbstractVolumeSupport<PrivateCloud> {
    private PrivateCloud provider;
    private volatile transient HardDiskCapabilities capabilities;

    HardDisk(@Nonnull PrivateCloud provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = this.provider.getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    public VolumeCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new HardDiskCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return this.getCapabilities().getMinimumVolumeSize();
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "hard disk";
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        return this.getCapabilities().listPossibleDeviceIds(platform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(@Nonnull String volumeId, @Nonnull String toServer, @Nonnull String deviceId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"HardDisk.attach");
        try {
            try {
                String fileName;
                VirtualDeviceConfigSpec[] machineSpecs;
                ServiceInstance instance = this.getServiceInstance();
                Vm support = this.provider.getComputeServices().getVirtualMachineSupport();
                VirtualMachine vm = support.getVirtualMachine(instance, toServer);
                if (vm == null) {
                    throw new CloudException("Unable to find vm with id " + toServer);
                }
                Volume volume = this.getVolume(volumeId);
                VirtualDevice[] devices = vm.getConfig().getHardware().getDevice();
                int cKey = 1000;
                boolean scsiExists = false;
                for (VirtualDevice device : devices) {
                    if (!(device instanceof VirtualSCSIController) || scsiExists) continue;
                    cKey = device.getKey();
                    scsiExists = true;
                }
                if (!scsiExists) {
                    machineSpecs = new VirtualDeviceConfigSpec[2];
                    VirtualDeviceConfigSpec scsiSpec = new VirtualDeviceConfigSpec();
                    scsiSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                    VirtualLsiLogicSASController scsiCtrl = new VirtualLsiLogicSASController();
                    scsiCtrl.setKey(cKey);
                    scsiCtrl.setBusNumber(0);
                    scsiCtrl.setSharedBus(VirtualSCSISharing.noSharing);
                    scsiSpec.setDevice((VirtualDevice)scsiCtrl);
                    machineSpecs[0] = scsiSpec;
                } else {
                    machineSpecs = new VirtualDeviceConfigSpec[1];
                }
                VirtualDisk disk = new VirtualDisk();
                disk.controllerKey = cKey;
                disk.unitNumber = Integer.parseInt(deviceId);
                VirtualDeviceConfigSpec diskSpec = new VirtualDeviceConfigSpec();
                diskSpec.operation = VirtualDeviceConfigSpecOperation.add;
                diskSpec.device = disk;
                VirtualDiskFlatVer2BackingInfo diskFileBacking = new VirtualDiskFlatVer2BackingInfo();
                diskFileBacking.fileName = fileName = volume.getTag("filePath");
                diskFileBacking.diskMode = "persistent";
                diskFileBacking.thinProvisioned = true;
                disk.backing = diskFileBacking;
                if (!scsiExists) {
                    machineSpecs[1] = diskSpec;
                } else {
                    machineSpecs[0] = diskSpec;
                }
                VirtualMachineConfigSpec spec = new VirtualMachineConfigSpec();
                spec.setDeviceChange(machineSpecs);
                CloudException lastError = null;
                Task task = vm.reconfigVM_Task(spec);
                String status = task.waitForTask();
                if (!status.equals("success")) {
                    lastError = new CloudException("Failed to attach volume: " + task.getTaskInfo().getError().getLocalizedMessage());
                }
                if (lastError != null) {
                    throw lastError;
                }
            }
            catch (InvalidProperty e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.alterVirtualMachine");
        try {
            block22: {
                if (options.getProviderVirtualMachineId() == null) {
                    throw new CloudException("Volumes can only be created in the context of a vm for " + ((PrivateCloud)this.getProvider()).getCloudName() + ". ProviderVirtualMachineId cannot be null");
                }
                instance = this.getServiceInstance();
                vmSupport = ((PrivateCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport();
                vm = vmSupport.getVirtualMachine(instance, options.getProviderVirtualMachineId());
                if (vm == null) break block22;
                try {
                    machineSpecs = null;
                    devices = vm.getConfig().getHardware().getDevice();
                    cKey = 1000;
                    scsiExists = false;
                    numDisks = 0;
                    diskNames = new ArrayList<String>();
                    for (VirtualDevice device : devices) {
                        if (device instanceof VirtualSCSIController) {
                            if (scsiExists) continue;
                            cKey = device.getKey();
                            scsiExists = true;
                            continue;
                        }
                        if (!(device instanceof VirtualDisk)) continue;
                        ++numDisks;
                        vDisk = (VirtualDisk)device;
                        bkInfo = (VirtualDiskFlatVer2BackingInfo)vDisk.getBacking();
                        diskNames.add(bkInfo.getFileName());
                    }
                    if (!scsiExists) {
                        machineSpecs = new VirtualDeviceConfigSpec[2];
                        scsiSpec = new VirtualDeviceConfigSpec();
                        scsiSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                        scsiCtrl = new VirtualLsiLogicSASController();
                        scsiCtrl.setKey(cKey);
                        scsiCtrl.setBusNumber(0);
                        scsiCtrl.setSharedBus(VirtualSCSISharing.noSharing);
                        scsiSpec.setDevice((VirtualDevice)scsiCtrl);
                        machineSpecs[0] = scsiSpec;
                    } else {
                        machineSpecs = new VirtualDeviceConfigSpec[1];
                    }
                    disk = new VirtualDisk();
                    disk.controllerKey = cKey;
                    disk.unitNumber = numDisks;
                    disk.setCapacityInKB((long)(options.getVolumeSize().intValue() * 1000000));
                    diskSpec = new VirtualDeviceConfigSpec();
                    diskSpec.operation = VirtualDeviceConfigSpecOperation.add;
                    diskSpec.fileOperation = VirtualDeviceConfigSpecFileOperation.create;
                    diskSpec.device = disk;
                    diskFileBacking = new VirtualDiskFlatVer2BackingInfo();
                    fileName2 = "[" + vm.getDatastores()[0].getName() + "]" + vm.getName() + "/" + options.getName();
                    diskFileBacking.setFileName(fileName2);
                    diskFileBacking.setDiskMode("persistent");
                    diskFileBacking.setThinProvisioned(Boolean.valueOf(false));
                    diskFileBacking.setWriteThrough(Boolean.valueOf(false));
                    disk.backing = diskFileBacking;
                    if (!scsiExists) {
                        machineSpecs[1] = diskSpec;
                    } else {
                        machineSpecs[0] = diskSpec;
                    }
                    spec = new VirtualMachineConfigSpec();
                    spec.setDeviceChange(machineSpecs);
                    task = vm.reconfigVM_Task(spec);
                    status = task.waitForTask();
                    if (!status.equals("success")) ** GOTO lbl96
                    timeout = System.currentTimeMillis() + 1200000L;
                    while (System.currentTimeMillis() < timeout) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        vm = vmSupport.getVirtualMachine(instance, options.getProviderVirtualMachineId());
                        arr$ = devices = vm.getConfig().getHardware().getDevice();
                        len$ = arr$.length;
                        i$ = 0;
lbl76:
                        // 2 sources

                        while (i$ < len$) {
                            device = arr$[i$];
                            if (device instanceof VirtualDisk && !diskNames.contains(diskFileName = (bkInfo = (VirtualDiskFlatVer2BackingInfo)(vDisk = (VirtualDisk)device).getBacking()).getFileName())) {
                                var28_36 = diskFileName = diskFileName.substring(diskFileName.lastIndexOf("/") + 1);
                                return var28_36;
                            }
                            ** GOTO lbl-1000
                        }
                    }
                    ** GOTO lbl94
                }
                catch (InvalidProperty e) {
                    throw new CloudException((Throwable)e);
                }
                catch (RuntimeFault e) {
                    throw new InternalException((Throwable)e);
                }
                catch (RemoteException e) {
                    throw new CloudException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new CloudException((Throwable)e);
                }
lbl-1000:
                // 1 sources

                {
                    block23: {
                        ++i$;
                        ** GOTO lbl76
lbl94:
                        // 1 sources

                        lastError = new CloudException("Unable to identify new volume.");
                        break block23;
lbl96:
                        // 1 sources

                        lastError = new CloudException("Failed to create volume: " + task.getTaskInfo().getError().getLocalizedMessage());
                    }
                    if (lastError == null) throw new CloudException("No volume and no error");
                    throw lastError;
                }
            }
            var5_10 = null;
            return var5_10;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(@Nonnull String volumeId, boolean force) throws InternalException, CloudException {
        block15: {
            APITrace.begin((CloudProvider)this.provider, (String)"HardDisk.detach");
            try {
                ServiceInstance instance;
                Volume volume = this.getVolume(volumeId);
                if (volume.getProviderVirtualMachineId() == null) {
                    throw new CloudException("Volume not currently attached");
                }
                Vm support = this.provider.getComputeServices().getVirtualMachineSupport();
                VirtualMachine vm = support.getVirtualMachine(instance = this.getServiceInstance(), volume.getProviderVirtualMachineId());
                if (vm != null) {
                    try {
                        VirtualDeviceConfigSpec[] machineSpecs = new VirtualDeviceConfigSpec[1];
                        VirtualDevice[] devices = vm.getConfig().getHardware().getDevice();
                        int diskKey = 0;
                        int controller = 0;
                        boolean found = false;
                        for (VirtualDevice device : devices) {
                            if (!(device instanceof VirtualDisk)) continue;
                            VirtualDisk disk = (VirtualDisk)device;
                            VirtualDeviceFileBackingInfo info = (VirtualDeviceFileBackingInfo)disk.getBacking();
                            String filePath = info.getFileName();
                            String diskId = filePath.substring(info.getFileName().lastIndexOf("/") + 1);
                            if (diskId == null || diskId.equals("")) {
                                diskId = vm.getConfig().getInstanceUuid() + "-" + volume.getName();
                            }
                            if (!diskId.equals(volumeId)) continue;
                            diskKey = disk.getKey();
                            controller = disk.getControllerKey();
                            found = true;
                            break;
                        }
                        if (found) {
                            VirtualDeviceConfigSpec diskSpec = new VirtualDeviceConfigSpec();
                            diskSpec.setOperation(VirtualDeviceConfigSpecOperation.remove);
                            VirtualDisk vd = new VirtualDisk();
                            vd.setKey(diskKey);
                            vd.setControllerKey(Integer.valueOf(controller));
                            diskSpec.setDevice((VirtualDevice)vd);
                            machineSpecs[0] = diskSpec;
                            VirtualMachineConfigSpec spec = new VirtualMachineConfigSpec();
                            spec.setDeviceChange(machineSpecs);
                            CloudException lastError = null;
                            Task task = vm.reconfigVM_Task(spec);
                            String status = task.waitForTask();
                            if (!status.equals("success")) {
                                lastError = new CloudException("Failed to update VM: " + task.getTaskInfo().getError().getLocalizedMessage());
                            }
                            if (lastError != null) {
                                throw lastError;
                            }
                            break block15;
                        }
                        throw new CloudException("Couldn't find device " + volumeId + " to detach in vm " + vm.getName());
                    }
                    catch (InvalidProperty e) {
                        throw new CloudException((Throwable)e);
                    }
                    catch (RuntimeFault e) {
                        throw new InternalException((Throwable)e);
                    }
                    catch (RemoteException e) {
                        throw new CloudException((Throwable)e);
                    }
                    catch (InterruptedException e) {
                        throw new CloudException((Throwable)e);
                    }
                }
                throw new CloudException("Can't find vm with id " + vm.getConfig().getInstanceUuid());
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"HardDisk.listVolumes");
        try {
            ManagedEntity[] mes;
            ArrayList<Volume> list = new ArrayList<Volume>();
            ArrayList<String> fileNames = new ArrayList<String>();
            ProviderContext ctx = this.provider.getContext();
            if (ctx != null && ctx.getRegionId() == null) {
                throw new CloudException("Region id is not set");
            }
            ServiceInstance instance = this.getServiceInstance();
            Folder folder = this.provider.getVmFolder(instance);
            try {
                mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (mes != null && mes.length > 0) {
                for (ManagedEntity entity : mes) {
                    VirtualDevice[] devices;
                    String dc2;
                    VirtualMachine vm = (VirtualMachine)entity;
                    Platform guestOs = Platform.guess((String)vm.getConfig().getGuestFullName());
                    if (vm == null || vm.getConfig().isTemplate() || !vm.getRuntime().getPowerState().equals((Object)VirtualMachinePowerState.poweredOn)) continue;
                    try {
                        dc2 = vm.getResourcePool().getOwner().getName();
                    }
                    catch (RemoteException e) {
                        throw new CloudException((Throwable)e);
                    }
                    if (dc2 == null) {
                        List<Volume> e = Collections.emptyList();
                        return e;
                    }
                    DataCenter ourDC = this.provider.getDataCenterServices().getDataCenter(dc2);
                    String regionId = "";
                    regionId = ourDC == null ? (dc2 = dc2 + "-a") : ourDC.getRegionId();
                    for (VirtualDevice device : devices = vm.getConfig().getHardware().getDevice()) {
                        VirtualDisk disk;
                        Volume d;
                        if (!(device instanceof VirtualDisk) || (d = this.toVolume(disk = (VirtualDisk)device, vm.getConfig().getInstanceUuid(), dc2, regionId)) == null) continue;
                        d.setGuestOperatingSystem(guestOs);
                        list.add(d);
                        fileNames.add(d.getProviderVolumeId());
                    }
                }
            }
            Collection<StoragePool> pools = this.provider.getDataCenterServices().listStoragePools();
            Datacenter dc = this.provider.getDataCenterServices().getVmwareDatacenterFromVDCId(instance, ctx.getRegionId());
            for (Datastore ds : dc.getDatastores()) {
                String dataCenterId = null;
                for (StoragePool pool : pools) {
                    if (!pool.getStoragePoolName().equalsIgnoreCase(ds.getName())) continue;
                    dataCenterId = pool.getDataCenterId();
                    break;
                }
                HostDatastoreBrowser browser = ds.getBrowser();
                try {
                    Task task = browser.searchDatastoreSubFolders_Task("[" + ds.getName() + "]", null);
                    String status = task.waitForTask();
                    if (status.equals("success")) {
                        HostDatastoreBrowserSearchResults[] res;
                        ArrayOfHostDatastoreBrowserSearchResults result = (ArrayOfHostDatastoreBrowserSearchResults)task.getTaskInfo().getResult();
                        for (HostDatastoreBrowserSearchResults r : res = result.getHostDatastoreBrowserSearchResults()) {
                            FileInfo[] files = r.getFile();
                            if (files == null) continue;
                            for (FileInfo file : files) {
                                Volume d;
                                String filePath = file.getPath();
                                if (!filePath.endsWith(".vmdk") || filePath.endsWith("-flat.vmdk") || fileNames.contains(file.getPath()) || (d = this.toVolume(file, dataCenterId, ctx.getRegionId())) == null) continue;
                                d.setTag("filePath", r.getFolderPath() + d.getProviderVolumeId());
                                list.add(d);
                            }
                        }
                        continue;
                    }
                    throw new CloudException("Failed listing volumes: " + task.getTaskInfo().getError().getLocalizedMessage());
                }
                catch (InterruptedException e) {
                    throw new InternalException((Throwable)e);
                }
                catch (InvalidProperty e) {
                    throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
                }
                catch (RuntimeFault e) {
                    throw new CloudException("Error in processing request to cluster: " + e.getMessage());
                }
                catch (RemoteException e) {
                    throw new CloudException("Error in cluster processing request: " + e.getMessage());
                }
            }
            ArrayList<Volume> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getServiceInstance() != null;
    }

    public void remove(@Nonnull String volumeId) throws InternalException, CloudException {
        block10: {
            APITrace.begin((CloudProvider)this.provider, (String)"HardDisk.remove");
            try {
                Volume volume = null;
                Iterable<Volume> attachedVolumes = this.getAttachedVolumes();
                for (Volume v : attachedVolumes) {
                    if (!v.getProviderVolumeId().equals(volumeId)) continue;
                    throw new CloudException("Volume is attached to vm " + v.getProviderVirtualMachineId() + " - removing not allowed");
                }
                volume = this.getVolume(volumeId);
                if (volume != null) {
                    ServiceInstance instance = this.provider.getServiceInstance();
                    Datacenter dc = this.provider.getDataCenterServices().getVmwareDatacenterFromVDCId(instance, this.provider.getContext().getRegionId());
                    ManagedObjectReference mor = instance.getServiceContent().getFileManager();
                    if (mor.getType().equals("FileManager")) {
                        FileManager fileManager = new FileManager(instance.getServerConnection(), mor);
                        String filePath = volume.getTag("filePath");
                        fileManager.deleteDatastoreFile_Task(filePath, dc);
                        String flatfile = filePath.substring(0, filePath.indexOf(".vmdk")) + "-flat.vmdk";
                        fileManager.deleteDatastoreFile_Task(flatfile, dc);
                    }
                    break block10;
                }
                throw new CloudException("Unable to find volume with id " + volumeId);
            }
            catch (InvalidProperty e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Volume> getAttachedVolumes() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"HardDisk.getAttachedVolumes");
        try {
            ManagedEntity[] mes;
            ArrayList<Volume> list = new ArrayList<Volume>();
            ArrayList<String> fileNames = new ArrayList<String>();
            ProviderContext ctx = this.provider.getContext();
            if (ctx != null && ctx.getRegionId() == null) {
                throw new CloudException("Region id is not set");
            }
            ServiceInstance instance = this.getServiceInstance();
            Folder folder = this.provider.getVmFolder(instance);
            try {
                mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (mes != null && mes.length > 0) {
                for (ManagedEntity entity : mes) {
                    VirtualDevice[] devices;
                    String dc2;
                    VirtualMachine vm = (VirtualMachine)entity;
                    Platform guestOs = Platform.guess((String)vm.getConfig().getGuestFullName());
                    if (vm == null || vm.getConfig().isTemplate()) continue;
                    try {
                        dc2 = vm.getResourcePool().getOwner().getName();
                    }
                    catch (RemoteException e) {
                        throw new CloudException((Throwable)e);
                    }
                    if (dc2 == null) {
                        List<Volume> e = Collections.emptyList();
                        return e;
                    }
                    DataCenter ourDC = this.provider.getDataCenterServices().getDataCenter(dc2);
                    String regionId = "";
                    regionId = ourDC == null ? (dc2 = dc2 + "-a") : ourDC.getRegionId();
                    for (VirtualDevice device : devices = vm.getConfig().getHardware().getDevice()) {
                        VirtualDisk disk;
                        Volume d;
                        if (!(device instanceof VirtualDisk) || (d = this.toVolume(disk = (VirtualDisk)device, vm.getConfig().getInstanceUuid(), dc2, regionId)) == null || fileNames.contains(d.getTag("filePath"))) continue;
                        d.setGuestOperatingSystem(guestOs);
                        list.add(d);
                        fileNames.add(d.getTag("filePath"));
                    }
                }
            }
            ArrayList<Volume> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private Volume toVolume(@Nonnull VirtualDisk disk, @Nonnull String vmId, @Nonnull String dataCenterId, @Nonnull String regionId) {
        Volume volume = new Volume();
        VirtualDeviceFileBackingInfo info = (VirtualDeviceFileBackingInfo)disk.getBacking();
        String filePath = info.getFileName();
        String fileName = filePath.substring(info.getFileName().lastIndexOf("/") + 1);
        volume.setTag("filePath", filePath);
        volume.setProviderVolumeId(fileName);
        volume.setName(disk.getDeviceInfo().getLabel());
        volume.setProviderDataCenterId(dataCenterId);
        volume.setProviderRegionId(regionId);
        volume.setDescription(disk.getDeviceInfo().getSummary());
        volume.setCurrentState(VolumeState.AVAILABLE);
        volume.setDeleteOnVirtualMachineTermination(Boolean.valueOf(true));
        volume.setDeviceId(disk.getUnitNumber().toString());
        volume.setFormat(VolumeFormat.BLOCK);
        volume.setProviderVirtualMachineId(vmId);
        volume.setSize(new Storage((Number)disk.getCapacityInKB(), (StorageUnit)Storage.KILOBYTE));
        volume.setType(VolumeType.SSD);
        if (volume.getProviderVolumeId() == null) {
            volume.setProviderVolumeId(vmId + "-" + volume.getName());
        }
        if (volume.getDeviceId().equals("0")) {
            volume.setRootVolume(true);
        }
        return volume;
    }

    @Nullable
    private Volume toVolume(@Nonnull FileInfo disk, @Nullable String dataCenterId, @Nonnull String regionId) {
        Volume volume = new Volume();
        volume.setProviderVolumeId(disk.getPath());
        volume.setName(disk.getPath());
        volume.setProviderDataCenterId(dataCenterId);
        volume.setProviderRegionId(regionId);
        volume.setDescription(disk.getPath());
        volume.setCurrentState(VolumeState.AVAILABLE);
        volume.setDeleteOnVirtualMachineTermination(Boolean.valueOf(true));
        volume.setFormat(VolumeFormat.BLOCK);
        if (disk.getFileSize() != null) {
            volume.setSize(new Storage((Number)disk.getFileSize(), (StorageUnit)Storage.BYTE));
        }
        volume.setType(VolumeType.SSD);
        Calendar cal = disk.getModification();
        if (cal != null) {
            volume.setCreationTimestamp(cal.getTimeInMillis());
        }
        volume.setRootVolume(false);
        return volume;
    }
}

