/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeCapabilities;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.cloud.vsphere.PrivateCloud;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class HardDiskCapabilities
extends AbstractCapabilities<PrivateCloud>
implements VolumeCapabilities {
    public HardDiskCapabilities(@Nonnull PrivateCloud provider) {
        super((CloudProvider)provider);
    }

    public boolean canAttach(VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.RUNNING);
    }

    public boolean canDetach(VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.RUNNING);
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return 15;
    }

    public int getMaximumVolumeProductIOPS() throws InternalException, CloudException {
        return -2;
    }

    public int getMinimumVolumeProductIOPS() throws InternalException, CloudException {
        return -2;
    }

    public int getMaximumVolumeSizeIOPS() throws InternalException, CloudException {
        return -2;
    }

    public int getMinimumVolumeSizeIOPS() throws InternalException, CloudException {
        return -2;
    }

    @Nullable
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)2000, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public NamingConstraints getVolumeNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)5, (int)50);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "hard disk";
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> list = new ArrayList<String>();
        Integer i = 0;
        while (i <= 15) {
            if (i != 7) {
                list.add(i.toString());
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return list;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Requirement requiresVMOnCreate() throws InternalException, CloudException {
        return Requirement.REQUIRED;
    }
}

