/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.compute.AbstractAffinityGroupSupport;
import org.dasein.cloud.compute.AffinityGroup;
import org.dasein.cloud.compute.AffinityGroupCreateOptions;
import org.dasein.cloud.compute.AffinityGroupFilterOptions;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.vsphere.Dc;
import org.dasein.cloud.vsphere.PrivateCloud;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class Host
extends AbstractAffinityGroupSupport {
    private static final Logger log = PrivateCloud.getLogger(Host.class, "std");
    private PrivateCloud provider;

    Host(@Nonnull PrivateCloud provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    @Nonnull
    public AffinityGroup create(@Nonnull AffinityGroupCreateOptions options) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Unable to create physical hosts in vSphere");
    }

    public void delete(@Nonnull String affinityGroupId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Unable to delete physical hosts in vSphere");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public AffinityGroup get(@Nonnull String affinityGroupId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getAffinityGroup");
        try {
            HostSystem host = this.getHostSystemForAffinity(affinityGroupId);
            if (host != null) {
                String dataCenterId = null;
                for (ManagedEntity parent = host.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent instanceof ComputeResource) {
                        dataCenterId = parent.getName();
                        break;
                    }
                    if (!(parent instanceof Datacenter)) continue;
                    dataCenterId = parent.getName() + "-a";
                    break;
                }
                AffinityGroup affinityGroup = this.toAffinityGroup(host, dataCenterId);
                return affinityGroup;
            }
            AffinityGroup affinityGroup = null;
            return affinityGroup;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<AffinityGroup> list(@Nonnull AffinityGroupFilterOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listAffinityGroups");
        try {
            ProviderContext ctx = this.provider.getContext();
            ArrayList<AffinityGroup> possibles = new ArrayList<AffinityGroup>();
            String dc = options.getDataCenterId();
            ServiceInstance instance = this.getServiceInstance();
            Dc dcServices = this.provider.getDataCenterServices();
            Datacenter vdc = dcServices.getVmwareDatacenterFromVDCId(instance, ctx.getRegionId());
            try {
                for (ManagedEntity me : vdc.getHostFolder().getChildEntity()) {
                    ComputeResource cluster;
                    if (dc != null) {
                        if (!me.getName().equals(dc)) continue;
                        cluster = (ComputeResource)me;
                        for (HostSystem host : cluster.getHosts()) {
                            possibles.add(this.toAffinityGroup(host, dc));
                        }
                        continue;
                    }
                    cluster = (ComputeResource)me;
                    for (HostSystem host : cluster.getHosts()) {
                        possibles.add(this.toAffinityGroup(host, me.getName()));
                    }
                }
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
            ArrayList<AffinityGroup> arrayList = possibles;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public AffinityGroup modify(@Nonnull String affinityGroupId, @Nonnull AffinityGroupCreateOptions options) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Unable to modify hosts in vSphere");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostSystem getHostSystemForAffinity(@Nonnull String affinityGroupId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getHostSystemForAffinity");
        try {
            ManagedEntity me;
            ServiceInstance instance = this.getServiceInstance();
            Folder folder = this.provider.getVmFolder(instance);
            try {
                me = new InventoryNavigator((ManagedEntity)folder).searchManagedEntity("HostSystem", affinityGroupId);
            }
            catch (InvalidProperty e) {
                throw new CloudException("No host support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (me != null) {
                HostSystem host;
                HostSystem hostSystem = host = (HostSystem)me;
                return hostSystem;
            }
            HostSystem hostSystem = null;
            return hostSystem;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HostSystem> listHostSystems(@Nullable String datacenterId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listHostSystems");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)("hosts" + datacenterId), HostSystem.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
            ArrayList<HostSystem> hostSystems = (ArrayList<HostSystem>)cache.get(this.provider.getContext());
            if (hostSystems == null) {
                hostSystems = new ArrayList<HostSystem>();
                ProviderContext ctx = this.provider.getContext();
                ServiceInstance instance = this.getServiceInstance();
                Dc dcServices = this.provider.getDataCenterServices();
                Datacenter vdc = dcServices.getVmwareDatacenterFromVDCId(instance, ctx.getRegionId());
                try {
                    for (ManagedEntity me : vdc.getHostFolder().getChildEntity()) {
                        ComputeResource cluster;
                        if (datacenterId != null) {
                            if (!me.getName().equals(datacenterId)) continue;
                            cluster = (ComputeResource)me;
                            for (HostSystem host : cluster.getHosts()) {
                                hostSystems.add(host);
                            }
                            continue;
                        }
                        cluster = (ComputeResource)me;
                        for (HostSystem host : cluster.getHosts()) {
                            hostSystems.add(host);
                        }
                    }
                    cache.put(this.provider.getContext(), hostSystems);
                }
                catch (RemoteException e) {
                    throw new CloudException((Throwable)e);
                }
            }
            ArrayList<HostSystem> arrayList = hostSystems;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public Collection<Datastore> listDatastoresForHost(HostSystem host) throws CloudException, InternalException {
        ArrayList<Datastore> list = new ArrayList<Datastore>();
        try {
            Datastore[] datastores;
            for (Datastore datastore : datastores = host.getDatastores()) {
                list.add(datastore);
            }
        }
        catch (RemoteException e) {
            throw new CloudException((Throwable)e);
        }
        return list;
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = this.provider.getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    private AffinityGroup toAffinityGroup(@Nonnull HostSystem host, @Nonnull String dataCenterID) {
        String agID = host.getName();
        String agName = host.getName();
        String agDesc = "Affinity group for " + agName;
        long created = 0L;
        AffinityGroup ag = AffinityGroup.getInstance((String)agID, (String)agName, (String)agDesc, (String)dataCenterID, (Long)created);
        String status = host.getConfigStatus().toString();
        ag.setTag("status", status);
        return ag;
    }
}

