/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import com.vmware.vim25.CustomizationAdapterMapping;
import com.vmware.vim25.CustomizationDhcpIpGenerator;
import com.vmware.vim25.CustomizationFixedIp;
import com.vmware.vim25.CustomizationGlobalIPSettings;
import com.vmware.vim25.CustomizationGuiUnattended;
import com.vmware.vim25.CustomizationIPSettings;
import com.vmware.vim25.CustomizationIdentification;
import com.vmware.vim25.CustomizationIdentitySettings;
import com.vmware.vim25.CustomizationIpGenerator;
import com.vmware.vim25.CustomizationLinuxPrep;
import com.vmware.vim25.CustomizationName;
import com.vmware.vim25.CustomizationPassword;
import com.vmware.vim25.CustomizationSpec;
import com.vmware.vim25.CustomizationSysprep;
import com.vmware.vim25.CustomizationUserData;
import com.vmware.vim25.CustomizationVirtualMachineName;
import com.vmware.vim25.Description;
import com.vmware.vim25.GuestInfo;
import com.vmware.vim25.GuestNicInfo;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedEntityStatus;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceConnectInfo;
import com.vmware.vim25.VirtualE1000;
import com.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import com.vmware.vim25.VirtualHardware;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineConfigInfoDatastoreUrlPair;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineFileInfo;
import com.vmware.vim25.VirtualMachineGuestOsIdentifier;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineProductFilterOptions;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.vsphere.PrivateCloud;
import org.dasein.cloud.vsphere.compute.Host;
import org.dasein.cloud.vsphere.compute.VMCapabilities;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class Vm
extends AbstractVMSupport<PrivateCloud> {
    private static final Logger log = PrivateCloud.getLogger(Vm.class, "std");
    private volatile transient VMCapabilities capabilities;
    private Random random = new Random();
    private static Collection<Architecture> architectures;

    Vm(@Nonnull PrivateCloud provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = ((PrivateCloud)this.getProvider()).getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@Nonnull String serverId) throws InternalException, CloudException {
        block12: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.start");
            try {
                ServiceInstance instance = this.getServiceInstance();
                VirtualMachine vm = this.getVirtualMachine(instance, serverId);
                if (vm == null) break block12;
                try {
                    String datacenter = vm.getResourcePool().getOwner().getName();
                    Datacenter dc = this.getVmwareDatacenter(vm);
                    if (dc == null) {
                        throw new CloudException("Could not identify a deployment data center.");
                    }
                    HostSystem host = this.getHost(vm);
                    Task task = null;
                    task = host == null ? vm.powerOnVM_Task(this.getBestHost(dc, datacenter)) : vm.powerOnVM_Task(host);
                    String status = task.waitForTask();
                    if (!status.equals("success")) {
                        if (task.getTaskInfo().getError().getLocalizedMessage().contains("lock the file")) {
                            throw new CloudException("Failed to start VM: " + task.getTaskInfo().getError().getLocalizedMessage() + ". This vm may be using a disk file already in use");
                        }
                        throw new CloudException("Failed to start VM: " + task.getTaskInfo().getError().getLocalizedMessage());
                    }
                }
                catch (TaskInProgress e) {
                    throw new CloudException((Throwable)e);
                }
                catch (InvalidState e) {
                    throw new CloudException((Throwable)e);
                }
                catch (RuntimeFault e) {
                    throw new InternalException((Throwable)e);
                }
                catch (RemoteException e) {
                    throw new CloudException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    @Nonnull
    VirtualMachine clone(@Nonnull ServiceInstance instance, @Nonnull VirtualMachine vm, @Nonnull String name, boolean asTemplate) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.clone(ServiceInstance, VirtualMachine)");
        try {
            String dcId = this.getDataCenter(vm);
            if (dcId == null) {
                throw new CloudException("Virtual machine " + vm + " has no data center parent");
            }
            name = this.validateName(name);
            Datacenter dc = null;
            DataCenter ourDC = ((PrivateCloud)this.getProvider()).getDataCenterServices().getDataCenter(dcId);
            dc = ourDC != null ? ((PrivateCloud)this.getProvider()).getDataCenterServices().getVmwareDatacenterFromVDCId(instance, ourDC.getRegionId()) : ((PrivateCloud)this.getProvider()).getDataCenterServices().getVmwareDatacenterFromVDCId(instance, dcId);
            ResourcePool pool = vm.getResourcePool();
            if (dc == null) {
                throw new CloudException("Invalid DC for cloning operation: " + dcId);
            }
            Folder vmFolder = dc.getVmFolder();
            VirtualMachineConfigSpec config = new VirtualMachineConfigSpec();
            VirtualMachineProduct product = this.getProduct(vm.getConfig().getHardware());
            String[] sizeInfo = product.getProviderProductId().split(":");
            int cpuCount = Integer.parseInt(sizeInfo[0]);
            long memory = Long.parseLong(sizeInfo[1]);
            config.setName(name);
            config.setAnnotation(vm.getConfig().getAnnotation());
            config.setMemoryMB(Long.valueOf(memory));
            config.setNumCPUs(Integer.valueOf(cpuCount));
            VirtualMachineCloneSpec spec = new VirtualMachineCloneSpec();
            VirtualMachineRelocateSpec location = new VirtualMachineRelocateSpec();
            HostSystem host = this.getHost(vm);
            if (host == null) {
                location.setHost(this.getBestHost(dc, dcId).getConfig().getHost());
            } else {
                location.setHost(host.getConfig().getHost());
            }
            location.setPool(pool.getConfig().getEntity());
            spec.setLocation(location);
            spec.setPowerOn(false);
            spec.setTemplate(asTemplate);
            spec.setConfig(config);
            Task task = vm.cloneVM_Task(vmFolder, name, spec);
            String status = task.waitForTask();
            if (status.equals("success")) {
                VirtualMachine virtualMachine = (VirtualMachine)new InventoryNavigator((ManagedEntity)vmFolder).searchManagedEntity("VirtualMachine", name);
                return virtualMachine;
            }
            try {
                throw new CloudException("Failed to create VM: " + task.getTaskInfo().getError().getLocalizedMessage());
            }
            catch (InvalidProperty e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.dasein.cloud.compute.VirtualMachine alterVirtualMachineSize(@Nonnull String virtualMachineId, @Nullable String cpuCount, @Nullable String ramInMB) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.alterVirtualMachine");
        try {
            block17: {
                instance = this.getServiceInstance();
                vm = this.getVirtualMachine(instance, virtualMachineId);
                if (vm == null || cpuCount == null && ramInMB == null) break block17;
                try {
                    spec = new VirtualMachineConfigSpec();
                    if (ramInMB != null) {
                        memoryVal = Long.parseLong(ramInMB);
                        spec.setMemoryMB(Long.valueOf(memoryVal));
                    }
                    if (cpuCount != null) {
                        cpuCountVal = Integer.parseInt(cpuCount);
                        spec.setNumCPUs(Integer.valueOf(cpuCountVal));
                    }
                    if ((status = (task = vm.reconfigVM_Task(spec)).waitForTask()).equals("success")) {
                        timeout = System.currentTimeMillis() + 1200000L;
                        while (System.currentTimeMillis() < timeout) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            for (org.dasein.cloud.compute.VirtualMachine s : this.listVirtualMachines()) {
                                if (!s.getProviderVirtualMachineId().equals(virtualMachineId)) continue;
                                var17_20 = s;
                                return var17_20;
                            }
                        }
                    }
                    ** GOTO lbl39
                }
                catch (InvalidProperty e) {
                    throw new CloudException((Throwable)e);
                }
                catch (RuntimeFault e) {
                    throw new InternalException((Throwable)e);
                }
                catch (RemoteException e) {
                    throw new CloudException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new CloudException((Throwable)e);
                }
                {
                    block18: {
                        lastError = new CloudException("Unable to identify updated server.");
                        break block18;
lbl39:
                        // 1 sources

                        lastError = new CloudException("Failed to update VM: " + task.getTaskInfo().getError().getLocalizedMessage());
                    }
                    if (lastError == null) throw new CloudException("No server and no error");
                    throw lastError;
                }
            }
            var6_13 = null;
            return var6_13;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public org.dasein.cloud.compute.VirtualMachine clone(@Nonnull String serverId, @Nullable String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.clone");
        try {
            ServiceInstance instance = this.getServiceInstance();
            VirtualMachine vm = this.getVirtualMachine(instance, serverId);
            if (vm != null) {
                org.dasein.cloud.compute.VirtualMachine target = this.toServer(this.clone(instance, vm, name, false), description);
                if (target == null) {
                    throw new CloudException("Request appeared to succeed, but no VM was created");
                }
                if (powerOn) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    String id = target.getProviderVirtualMachineId();
                    if (id == null) {
                        throw new CloudException("Got a VM without an ID");
                    }
                    this.start(id);
                }
                org.dasein.cloud.compute.VirtualMachine virtualMachine = target;
                return virtualMachine;
            }
            throw new CloudException("No virtual machine " + serverId + ".");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VirtualMachineCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new VMCapabilities((PrivateCloud)this.getProvider());
        }
        return this.capabilities;
    }

    private ManagedEntity[] randomize(ManagedEntity[] source) {
        return source;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private org.dasein.cloud.compute.VirtualMachine defineFromTemplate(@Nonnull VMLaunchOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.define");
        try {
            ctx = ((PrivateCloud)this.getProvider()).getContext();
            if (ctx == null) {
                throw new InternalException("No context was set for this request");
            }
            instance = this.getServiceInstance();
            try {
                template = this.getTemplate(instance, options.getMachineImageId());
                if (template == null) {
                    throw new CloudException("No such template: " + options.getMachineImageId());
                }
                hostName = this.validateName(options.getHostName());
                dataCenterId = options.getDataCenterId();
                resourceProductStr = options.getStandardProductId();
                items = resourceProductStr.split(":");
                if (items.length == 3) {
                    options.withResourcePoolId(items[0]);
                }
                if (dataCenterId == null && (rid = ctx.getRegionId()) != null) {
                    for (DataCenter dsdc : ((PrivateCloud)this.getProvider()).getDataCenterServices().listDataCenters(rid)) {
                        dataCenterId = dsdc.getProviderDataCenterId();
                        if (this.random.nextInt() % 3 != 0) continue;
                    }
                }
                pools = null;
                vdc = null;
                if (dataCenterId != null) {
                    ourDC = ((PrivateCloud)this.getProvider()).getDataCenterServices().getDataCenter(dataCenterId);
                    if (ourDC != null) {
                        vdc = ((PrivateCloud)this.getProvider()).getDataCenterServices().getVmwareDatacenterFromVDCId(instance, ourDC.getRegionId());
                        if (vdc == null) {
                            throw new CloudException("Unable to identify VDC " + dataCenterId);
                        }
                        if (options.getResourcePoolId() == null && (pool = ((PrivateCloud)this.getProvider()).getDataCenterServices().getResourcePoolFromClusterId(instance, dataCenterId)) != null) {
                            pools = new ManagedEntity[]{pool};
                        }
                    } else {
                        vdc = ((PrivateCloud)this.getProvider()).getDataCenterServices().getVmwareDatacenterFromVDCId(instance, dataCenterId);
                        if (options.getResourcePoolId() == null) {
                            pools = new InventoryNavigator((ManagedEntity)vdc).searchManagedEntities("ResourcePool");
                        }
                    }
                }
                lastError = null;
                if (options.getResourcePoolId() != null) {
                    pool = ((PrivateCloud)this.getProvider()).getDataCenterServices().getVMWareResourcePool(options.getResourcePoolId());
                    if (pool == null) throw new CloudException("Unable to find resource pool with id " + options.getResourcePoolId());
                    pools = new ManagedEntity[]{pool};
                }
                arr$ = pools;
                len$ = arr$.length;
                i$ = 0;
lbl44:
                // 2 sources

                while (i$ < len$) {
                    var15_19 = arr$[i$];
                    pool = (ResourcePool)var15_19;
                    vmFolder = vdc.getVmFolder();
                    if (options.getVmFolderId() != null && (tmp = new InventoryNavigator((ManagedEntity)vmFolder).searchManagedEntity("Folder", options.getVmFolderId())) != null) {
                        vmFolder = (Folder)tmp;
                    }
                    config = new VirtualMachineConfigSpec();
                    vmInfo = options.getStandardProductId().split(":");
                    if (vmInfo.length == 2) {
                        cpuCount = Integer.parseInt(vmInfo[0]);
                        memory = Long.parseLong(vmInfo[1]);
                    } else {
                        cpuCount = Integer.parseInt(vmInfo[1]);
                        memory = Long.parseLong(vmInfo[2]);
                    }
                    config.setName(hostName);
                    config.setAnnotation(options.getMachineImageId());
                    config.setMemoryMB(Long.valueOf(memory));
                    config.setNumCPUs(Integer.valueOf(cpuCount));
                    vlan = options.getVlanId();
                    count = 0;
                    networkIndex = 0;
                    if (vlan != null) {
                        changeRequired = true;
                        keys = new Integer[count];
                        nics = template.getGuest().getNet();
                        if (nics != null) {
                            count = nics.length;
                            keys = new Integer[count];
                            for (i = 0; i < count; ++i) {
                                if (nics[i].getNetwork().equals(vlan)) {
                                    changeRequired = false;
                                    networkIndex = i;
                                    break;
                                }
                                keys[i] = nics[i].getDeviceConfigId();
                            }
                        } else {
                            Vm.log.warn((Object)("Unable to find network adapter info for template " + template.getName() + "(" + template.getConfig().getInstanceUuid() + ")"));
                        }
                        if (changeRequired) {
                            if (count > 0) {
                                machineSpecs = new VirtualDeviceConfigSpec[keys.length + 1];
                                for (j = 0; j < keys.length; ++j) {
                                    nicSpec = new VirtualDeviceConfigSpec();
                                    nicSpec.setOperation(VirtualDeviceConfigSpecOperation.remove);
                                    nic = new VirtualE1000();
                                    nic.setKey(keys[j].intValue());
                                    nicSpec.setDevice((VirtualDevice)nic);
                                    machineSpecs[j] = nicSpec;
                                }
                                nicSpec = new VirtualDeviceConfigSpec();
                                nicSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                                nic = new VirtualE1000();
                                nic.setConnectable(new VirtualDeviceConnectInfo());
                                nic.connectable.connected = true;
                                nic.connectable.startConnected = true;
                                info = new Description();
                                info.setLabel(vlan);
                                info.setSummary("Nic for network " + vlan);
                                nicBacking = new VirtualEthernetCardNetworkBackingInfo();
                                nicBacking.setDeviceName(vlan);
                                nic.setAddressType("generated");
                                nic.setBacking((VirtualDeviceBackingInfo)nicBacking);
                                nic.setKey(0);
                                nicSpec.setDevice((VirtualDevice)nic);
                                machineSpecs[keys.length] = nicSpec;
                                config.setDeviceChange(machineSpecs);
                            } else {
                                nicSpec = new VirtualDeviceConfigSpec();
                                nicSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                                nic = new VirtualE1000();
                                nic.setConnectable(new VirtualDeviceConnectInfo());
                                nic.connectable.connected = true;
                                nic.connectable.startConnected = true;
                                info = new Description();
                                info.setLabel(vlan);
                                info.setSummary("Nic for network " + vlan);
                                nicBacking = new VirtualEthernetCardNetworkBackingInfo();
                                nicBacking.setDeviceName(vlan);
                                nic.setAddressType("generated");
                                nic.setBacking((VirtualDeviceBackingInfo)nicBacking);
                                nic.setKey(0);
                                nicSpec.setDevice((VirtualDevice)nic);
                                machineSpecs = new VirtualDeviceConfigSpec[]{nicSpec};
                                config.setDeviceChange(machineSpecs);
                            }
                        }
                    }
                    location = new VirtualMachineRelocateSpec();
                    if (options.getAffinityGroupId() != null) {
                        agSupport = ((PrivateCloud)this.getProvider()).getComputeServices().getAffinityGroupSupport();
                        location.setHost(agSupport.getHostSystemForAffinity(options.getAffinityGroupId()).getConfig().getHost());
                    }
                    if (options.getStoragePoolId() != null) {
                        locationId = options.getStoragePoolId();
                        for (Datastore ds : datastores = vdc.getDatastores()) {
                            if (!ds.getName().equals(locationId)) continue;
                            location.setDatastore(ds.getMOR());
                            break;
                        }
                    }
                    location.setPool(pool.getConfig().getEntity());
                    isCustomised = false;
                    if (options.getPrivateIp() != null) {
                        isCustomised = true;
                        Vm.log.debug((Object)"isCustomised");
                    } else {
                        Vm.log.debug((Object)"notCustomised");
                    }
                    customizationSpec = new CustomizationSpec();
                    if (isCustomised) {
                        templatePlatform = template.getGuest().getGuestFullName();
                        if (templatePlatform == null) {
                            templatePlatform = template.getName();
                        }
                        if ((platform = Platform.guess((String)templatePlatform.toLowerCase())).isLinux()) {
                            lPrep = new CustomizationLinuxPrep();
                            lPrep.setDomain(options.getDnsDomain());
                            lPrep.setHostName((CustomizationName)new CustomizationVirtualMachineName());
                            customizationSpec.setIdentity((CustomizationIdentitySettings)lPrep);
                        } else if (platform.isWindows()) {
                            sysprep = new CustomizationSysprep();
                            guiCust = new CustomizationGuiUnattended();
                            guiCust.setAutoLogon(false);
                            guiCust.setAutoLogonCount(0);
                            password = new CustomizationPassword();
                            password.setPlainText(true);
                            password.setValue(options.getBootstrapPassword());
                            guiCust.setPassword(password);
                            sysprep.setGuiUnattended(guiCust);
                            identification = new CustomizationIdentification();
                            identification.setJoinWorkgroup(options.getWinWorkgroupName());
                            sysprep.setIdentification(identification);
                            userData = new CustomizationUserData();
                            userData.setComputerName((CustomizationName)new CustomizationVirtualMachineName());
                            userData.setFullName(options.getWinOwnerName());
                            userData.setOrgName(options.getWinOrgName());
                            userData.setProductId(options.getWinProductSerialNum());
                            sysprep.setUserData(userData);
                            customizationSpec.setIdentity((CustomizationIdentitySettings)sysprep);
                        } else {
                            Vm.log.error((Object)("Guest customisation could not take place as platform is not linux or windows: " + platform));
                            isCustomised = false;
                        }
                        if (isCustomised) {
                            globalIPSettings = new CustomizationGlobalIPSettings();
                            globalIPSettings.setDnsServerList(options.getDnsServerList());
                            globalIPSettings.setDnsSuffixList(options.getDnsSuffixList());
                            customizationSpec.setGlobalIPSettings(globalIPSettings);
                            nicMappings = new ArrayList<CustomizationAdapterMapping>();
                            for (i = 0; i < count; ++i) {
                                adapterMap = new CustomizationAdapterMapping();
                                if (i != networkIndex) {
                                    adapter = new CustomizationIPSettings();
                                    adapter.setDnsDomain(options.getDnsDomain());
                                    adapter.setIp((CustomizationIpGenerator)new CustomizationDhcpIpGenerator());
                                    adapterMap.setAdapter(adapter);
                                } else {
                                    adapter = new CustomizationIPSettings();
                                    adapter.setDnsDomain(options.getDnsDomain());
                                    adapter.setGateway(options.getGatewayList());
                                    fixedIp = new CustomizationFixedIp();
                                    fixedIp.setIpAddress(options.getPrivateIp());
                                    Vm.log.debug((Object)("custom IP: " + options.getPrivateIp()));
                                    adapter.setIp((CustomizationIpGenerator)fixedIp);
                                    if (options.getMetaData().containsKey("vSphereNetMaskNothingToSeeHere")) {
                                        netmask = (String)options.getMetaData().get("vSphereNetMaskNothingToSeeHere");
                                        adapter.setSubnetMask(netmask);
                                        Vm.log.debug((Object)("custom subnet mask: " + netmask));
                                    } else {
                                        adapter.setSubnetMask("255.255.252.0");
                                        Vm.log.debug((Object)"default subnet mask");
                                    }
                                    adapterMap.setAdapter(adapter);
                                }
                                nicMappings.add(adapterMap);
                            }
                            nicSettingMap = nicMappings.toArray(new CustomizationAdapterMapping[nicMappings.size()]);
                            customizationSpec.setNicSettingMap(nicSettingMap);
                        }
                    }
                    spec = new VirtualMachineCloneSpec();
                    spec.setLocation(location);
                    spec.setPowerOn(true);
                    spec.setTemplate(false);
                    spec.setConfig(config);
                    if (isCustomised) {
                        spec.setCustomization(customizationSpec);
                    }
                    if (!(status = (task = template.cloneVM_Task(vmFolder, hostName, spec)).waitForTask()).equals("success")) ** GOTO lbl247
                    timeout = System.currentTimeMillis() + 1200000L;
                    while (System.currentTimeMillis() < timeout) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        for (org.dasein.cloud.compute.VirtualMachine s : this.listVirtualMachines()) {
                            if (!s.getName().equals(hostName)) continue;
                            if (isCustomised && s.getPlatform().equals((Object)Platform.WINDOWS)) {
                                s.setRootPassword(options.getBootstrapPassword());
                            }
                            var36_61 = s;
                            return var36_61;
                        }
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl251
            }
            catch (InvalidProperty e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new InternalException((Throwable)e);
            }
lbl-1000:
            // 1 sources

            {
                block59: {
                    lastError = new CloudException("Unable to identify newly created server.");
                    break block59;
lbl247:
                    // 1 sources

                    lastError = new CloudException("Failed to create VM: " + task.getTaskInfo().getError().getLocalizedMessage());
                }
                ++i$;
                ** GOTO lbl44
lbl251:
                // 1 sources

                if (lastError == null) throw new CloudException("No server and no error");
                throw lastError;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private org.dasein.cloud.compute.VirtualMachine defineFromScratch(@Nonnull VMLaunchOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.define");
        try {
            ctx = ((PrivateCloud)this.getProvider()).getContext();
            if (ctx == null) {
                throw new InternalException("No context was set for this request");
            }
            instance = this.getServiceInstance();
            try {
                hostName = this.validateName(options.getHostName());
                dataCenterId = options.getDataCenterId();
                resourceProductStr = options.getStandardProductId();
                imageId = options.getMachineImageId();
                items = resourceProductStr.split(":");
                if (items.length == 3) {
                    options.withResourcePoolId(items[0]);
                }
                if (dataCenterId == null && (rid = ctx.getRegionId()) != null) {
                    for (DataCenter dsdc : ((PrivateCloud)this.getProvider()).getDataCenterServices().listDataCenters(rid)) {
                        dataCenterId = dsdc.getProviderDataCenterId();
                        if (this.random.nextInt() % 3 != 0) continue;
                    }
                }
                pools = null;
                vdc = null;
                if (dataCenterId != null) {
                    ourDC = ((PrivateCloud)this.getProvider()).getDataCenterServices().getDataCenter(dataCenterId);
                    if (ourDC != null) {
                        vdc = ((PrivateCloud)this.getProvider()).getDataCenterServices().getVmwareDatacenterFromVDCId(instance, ourDC.getRegionId());
                        if (vdc == null) {
                            throw new CloudException("Unable to identify VDC " + dataCenterId);
                        }
                        if (options.getResourcePoolId() == null && (pool = ((PrivateCloud)this.getProvider()).getDataCenterServices().getResourcePoolFromClusterId(instance, dataCenterId)) != null) {
                            pools = new ManagedEntity[]{pool};
                        }
                    } else {
                        vdc = ((PrivateCloud)this.getProvider()).getDataCenterServices().getVmwareDatacenterFromVDCId(instance, dataCenterId);
                        if (options.getResourcePoolId() == null) {
                            pools = new InventoryNavigator((ManagedEntity)vdc).searchManagedEntities("ResourcePool");
                        }
                    }
                }
                lastError = null;
                if (options.getResourcePoolId() != null) {
                    pool = ((PrivateCloud)this.getProvider()).getDataCenterServices().getVMWareResourcePool(options.getResourcePoolId());
                    if (pool == null) throw new CloudException("Unable to find resource pool with id " + options.getResourcePoolId());
                    pools = new ManagedEntity[]{pool};
                }
                arr$ = pools;
                len$ = arr$.length;
                i$ = 0;
lbl42:
                // 2 sources

                while (i$ < len$) {
                    var15_19 = arr$[i$];
                    pool = (ResourcePool)var15_19;
                    vmFolder = vdc.getVmFolder();
                    if (options.getVmFolderId() != null && (tmp = new InventoryNavigator((ManagedEntity)vmFolder).searchManagedEntity("Folder", options.getVmFolderId())) != null) {
                        vmFolder = (Folder)tmp;
                    }
                    config = new VirtualMachineConfigSpec();
                    vmInfo = options.getStandardProductId().split(":");
                    if (vmInfo.length == 2) {
                        cpuCount = Integer.parseInt(vmInfo[0]);
                        memory = Long.parseLong(vmInfo[1]);
                    } else {
                        cpuCount = Integer.parseInt(vmInfo[1]);
                        memory = Long.parseLong(vmInfo[2]);
                    }
                    config.setName(hostName);
                    config.setAnnotation(imageId);
                    config.setMemoryMB(Long.valueOf(memory));
                    config.setNumCPUs(Integer.valueOf(cpuCount));
                    config.setGuestId(imageId);
                    vmfi = new VirtualMachineFileInfo();
                    vmDataStoreName = null;
                    for (Datastore ds : datastores = vdc.getDatastores()) {
                        if (options.getStoragePoolId() != null) {
                            locationId = options.getStoragePoolId();
                            if (!ds.getName().equals(locationId)) continue;
                            vmDataStoreName = ds.getName();
                            break;
                        }
                        vmDataStoreName = ds.getName();
                        break;
                    }
                    if (vmDataStoreName == null) {
                        throw new CloudException("Unable to find a datastore for vm " + hostName);
                    }
                    vmfi.setVmPathName("[" + vmDataStoreName + "]");
                    config.setFiles(vmfi);
                    vlan = options.getVlanId();
                    if (vlan == null) throw new CloudException("You must choose a network when creating a vm from scratch");
                    nicSpec = new VirtualDeviceConfigSpec();
                    nicSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
                    nic = new VirtualE1000();
                    nic.setConnectable(new VirtualDeviceConnectInfo());
                    nic.connectable.connected = true;
                    nic.connectable.startConnected = true;
                    info = new Description();
                    info.setLabel(vlan);
                    info.setSummary("Nic for network " + vlan);
                    nicBacking = new VirtualEthernetCardNetworkBackingInfo();
                    nicBacking.setDeviceName(vlan);
                    nic.setAddressType("generated");
                    nic.setBacking((VirtualDeviceBackingInfo)nicBacking);
                    nic.setKey(0);
                    nicSpec.setDevice((VirtualDevice)nic);
                    machineSpecs = new VirtualDeviceConfigSpec[]{nicSpec};
                    config.setDeviceChange(machineSpecs);
                    host = null;
                    if (options.getAffinityGroupId() != null) {
                        agSupport = ((PrivateCloud)this.getProvider()).getComputeServices().getAffinityGroupSupport();
                        host = agSupport.getHostSystemForAffinity(options.getAffinityGroupId());
                    }
                    if (!(status = (task = vmFolder.createVM_Task(config, pool, host)).waitForTask()).equals("success")) ** GOTO lbl123
                    timeout = System.currentTimeMillis() + 1200000L;
                    while (System.currentTimeMillis() < timeout) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        for (org.dasein.cloud.compute.VirtualMachine s : this.listVirtualMachines()) {
                            if (!s.getName().equals(hostName)) continue;
                            var34_41 = s;
                            return var34_41;
                        }
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl127
            }
            catch (InvalidProperty e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new InternalException((Throwable)e);
            }
lbl-1000:
            // 1 sources

            {
                block33: {
                    lastError = new CloudException("Unable to identify newly created server.");
                    break block33;
lbl123:
                    // 1 sources

                    lastError = new CloudException("Failed to create VM: " + task.getTaskInfo().getError().getLocalizedMessage());
                }
                ++i$;
                ** GOTO lbl42
lbl127:
                // 1 sources

                if (lastError == null) throw new CloudException("No server and no error");
                throw lastError;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    Architecture getArchitecture(@Nonnull VirtualMachineGuestOsIdentifier os) {
        if (os.name().contains("64")) {
            return Architecture.I64;
        }
        return Architecture.I32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    HostSystem getBestHost(@Nonnull Datacenter forDatacenter, @Nonnull String clusterName) throws CloudException, RemoteException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.getBestHost");
        try {
            Collection<HostSystem> possibles = this.getPossibleHosts(forDatacenter, clusterName);
            if (possibles.isEmpty()) {
                HostSystem ohWell = null;
                for (ManagedEntity me : forDatacenter.getHostFolder().getChildEntity()) {
                    if (!me.getName().equals(clusterName)) continue;
                    ComputeResource cluster = (ComputeResource)me;
                    for (HostSystem host : cluster.getHosts()) {
                        if (host.getConfigStatus().equals((Object)ManagedEntityStatus.green)) {
                            HostSystem hostSystem = host;
                            return hostSystem;
                        }
                        if (ohWell != null && !host.getConfigStatus().equals((Object)ManagedEntityStatus.yellow)) continue;
                        ohWell = host;
                    }
                }
                if (ohWell == null) {
                    throw new CloudException("Insufficient capacity for this operation");
                }
                HostSystem hostSystem = ohWell;
                return hostSystem;
            }
            HostSystem hostSystem = possibles.iterator().next();
            return hostSystem;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Collection<HostSystem> getPossibleHosts(@Nonnull Datacenter dc, @Nonnull String clusterName) throws CloudException, RemoteException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.getPossibleHosts");
        try {
            ArrayList<HostSystem> possibles = new ArrayList<HostSystem>();
            for (ManagedEntity me : dc.getHostFolder().getChildEntity()) {
                if (!me.getName().equals(clusterName)) continue;
                ComputeResource cluster = (ComputeResource)me;
                for (HostSystem host : cluster.getHosts()) {
                    if (!host.getConfigStatus().equals((Object)ManagedEntityStatus.green)) continue;
                    possibles.add(host);
                }
            }
            ArrayList<HostSystem> arrayList = possibles;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getConsoleOutput(@Nonnull String serverId) throws InternalException, CloudException {
        return "";
    }

    @Nullable
    private String getDataCenter(@Nonnull VirtualMachine vm) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.getDataCenter");
        try {
            String string = vm.getResourcePool().getOwner().getName();
            return string;
        }
        catch (RemoteException e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<String> listFirewalls(@Nonnull String serverId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private HostSystem getHost(@Nonnull VirtualMachine vm) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"getHostForVM");
        try {
            String dc = this.getDataCenter(vm);
            ManagedObjectReference vmHost = vm.getRuntime().getHost();
            Host affinityGroupSupport = ((PrivateCloud)this.getProvider()).getComputeServices().getAffinityGroupSupport();
            Collection<HostSystem> hostSystems = affinityGroupSupport.listHostSystems(dc);
            for (HostSystem host : hostSystems) {
                if (!vmHost.getVal().equals(host.getMOR().getVal())) continue;
                HostSystem hostSystem = host;
                return hostSystem;
            }
            HostSystem hostSystem = null;
            return hostSystem;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualMachine getTemplate(@Nonnull ServiceInstance instance, @Nonnull String templateId) throws CloudException, RemoteException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.getTemplate");
        try {
            Folder folder = ((PrivateCloud)this.getProvider()).getVmFolder(instance);
            ManagedEntity[] mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
            if (mes != null && mes.length > 0) {
                for (ManagedEntity entity : mes) {
                    VirtualMachineConfigInfo vminfo;
                    VirtualMachine template = (VirtualMachine)entity;
                    if (template == null || (vminfo = template.getConfig()) == null || !vminfo.isTemplate() || !vminfo.getUuid().equals(templateId)) continue;
                    VirtualMachine virtualMachine = template;
                    return virtualMachine;
                }
            }
            VirtualMachine virtualMachine = null;
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.getProduct(String)");
        try {
            VirtualMachineProduct product2;
            for (VirtualMachineProduct product2 : this.listProducts(null, Architecture.I64)) {
                if (!product2.getProviderProductId().equals(productId)) continue;
                VirtualMachineProduct virtualMachineProduct = product2;
                return virtualMachineProduct;
            }
            for (VirtualMachineProduct product2 : this.listProducts(null, Architecture.I32)) {
                if (!product2.getProviderProductId().equals(productId)) continue;
                VirtualMachineProduct virtualMachineProduct = product2;
                return virtualMachineProduct;
            }
            String[] parts = productId.split(":");
            product2 = new VirtualMachineProduct();
            product2.setCpuCount(Integer.parseInt(parts[0]));
            product2.setRamSize(new Storage((Number)Integer.parseInt(parts[1]), (StorageUnit)Storage.MEGABYTE));
            product2.setDescription("Custom product " + parts[0] + " CPU, " + parts[1] + " RAM");
            product2.setName(parts[0] + " CPU/" + parts[1] + " MB RAM");
            product2.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
            product2.setProviderProductId(parts[0] + ":" + parts[1]);
            VirtualMachineProduct virtualMachineProduct = product2;
            return virtualMachineProduct;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public org.dasein.cloud.compute.VirtualMachine getVirtualMachine(@Nonnull String serverId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.getVirtualMachine");
        try {
            ServiceInstance instance = this.getServiceInstance();
            VirtualMachine vm = this.getVirtualMachine(instance, serverId);
            if (vm == null) {
                org.dasein.cloud.compute.VirtualMachine virtualMachine = null;
                return virtualMachine;
            }
            org.dasein.cloud.compute.VirtualMachine virtualMachine = this.toServer(vm, null);
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private VirtualMachineProduct getProduct(@Nonnull VirtualHardware hardware) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.getProduct(VirtualHardware)");
        VirtualMachineProduct product = this.getProduct(hardware.getNumCPU() + ":" + hardware.getMemoryMB());
        if (product == null) {
            int cpu = hardware.getNumCPU();
            int ram = hardware.getMemoryMB();
            int disk = 1;
            product = new VirtualMachineProduct();
            product.setCpuCount(cpu);
            product.setDescription("Custom product " + cpu + " CPU, " + ram + " RAM");
            product.setName(cpu + " CPU/" + ram + " MB RAM");
            product.setRootVolumeSize(new Storage((Number)disk, (StorageUnit)Storage.GIGABYTE));
            product.setProviderProductId(cpu + ":" + ram);
        }
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<VirtualMachineProduct> listProducts(VirtualMachineProductFilterOptions options, Architecture architecture) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.listProducts(VirtualMachineProductFilterOptions, Architecture)");
        try {
            ArrayList<VirtualMachineProduct> allVirtualMachineProducts = new ArrayList<VirtualMachineProduct>();
            Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"resourcePools", org.dasein.cloud.dc.ResourcePool.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
            ArrayList<org.dasein.cloud.dc.ResourcePool> rps = (ArrayList<org.dasein.cloud.dc.ResourcePool>)cache.get(this.getContext());
            if (rps == null) {
                Collection<DataCenter> dcs = ((PrivateCloud)this.getProvider()).getDataCenterServices().listDataCenters(this.getContext().getRegionId());
                rps = new ArrayList<org.dasein.cloud.dc.ResourcePool>();
                for (DataCenter dc : dcs) {
                    Collection<org.dasein.cloud.dc.ResourcePool> pools = ((PrivateCloud)this.getProvider()).getDataCenterServices().listResourcePools(dc.getProviderDataCenterId());
                    rps.addAll(pools);
                }
                cache.put(this.getContext(), rps);
            }
            if (architecture != null) {
                for (Architecture a : this.getCapabilities().listSupportedArchitectures()) {
                    VirtualMachineProduct product;
                    if (!a.equals((Object)architecture)) continue;
                    if (a.equals((Object)Architecture.I32)) {
                        for (int cpu : new int[]{1, 2}) {
                            for (int ram : new int[]{512, 1024, 2048}) {
                                product = new VirtualMachineProduct();
                                product.setCpuCount(cpu);
                                product.setDescription("Custom product " + architecture + " - " + cpu + " CPU, " + ram + "MB RAM");
                                product.setName(cpu + " CPU/" + ram + " MB RAM");
                                product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                                product.setProviderProductId(cpu + ":" + ram);
                                product.setRamSize(new Storage((Number)ram, (StorageUnit)Storage.MEGABYTE));
                                allVirtualMachineProducts.add(product);
                                for (org.dasein.cloud.dc.ResourcePool pool : rps) {
                                    product = new VirtualMachineProduct();
                                    product.setCpuCount(cpu);
                                    product.setDescription("Custom product " + architecture + " - " + cpu + " CPU, " + ram + "MB RAM");
                                    product.setName("Pool " + pool.getName() + "/" + cpu + " CPU/" + ram + " MB RAM");
                                    product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                                    product.setProviderProductId(pool.getProvideResourcePoolId() + ":" + cpu + ":" + ram);
                                    product.setRamSize(new Storage((Number)ram, (StorageUnit)Storage.MEGABYTE));
                                    allVirtualMachineProducts.add(product);
                                }
                            }
                        }
                        continue;
                    }
                    for (int cpu : new int[]{1, 2, 4, 8}) {
                        for (int ram : new int[]{1024, 2048, 4096, 10240, 20480}) {
                            product = new VirtualMachineProduct();
                            product.setCpuCount(cpu);
                            product.setDescription("Custom product " + architecture + " - " + cpu + " CPU, " + ram + "MB RAM");
                            product.setName(cpu + " CPU/" + ram + " MB RAM");
                            product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                            product.setProviderProductId(cpu + ":" + ram);
                            product.setRamSize(new Storage((Number)ram, (StorageUnit)Storage.MEGABYTE));
                            allVirtualMachineProducts.add(product);
                            for (org.dasein.cloud.dc.ResourcePool pool : rps) {
                                product = new VirtualMachineProduct();
                                product.setCpuCount(cpu);
                                product.setDescription("Custom product " + architecture + " - " + cpu + " CPU, " + ram + "MB RAM");
                                product.setName("Pool " + pool.getName() + "/" + cpu + " CPU/" + ram + " MB RAM");
                                product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                                product.setProviderProductId(pool.getProvideResourcePoolId() + ":" + cpu + ":" + ram);
                                product.setRamSize(new Storage((Number)ram, (StorageUnit)Storage.MEGABYTE));
                                allVirtualMachineProducts.add(product);
                            }
                        }
                    }
                }
            } else {
                for (int cpu : new int[]{1, 2, 4, 8}) {
                    for (int ram : new int[]{512, 1024, 2048, 4096, 10240, 20480}) {
                        VirtualMachineProduct product = new VirtualMachineProduct();
                        product.setCpuCount(cpu);
                        product.setDescription("Custom product " + architecture + " - " + cpu + " CPU, " + ram + "MB RAM");
                        product.setName(cpu + " CPU/" + ram + " MB RAM");
                        product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                        product.setProviderProductId(cpu + ":" + ram);
                        product.setRamSize(new Storage((Number)ram, (StorageUnit)Storage.MEGABYTE));
                        allVirtualMachineProducts.add(product);
                        for (org.dasein.cloud.dc.ResourcePool pool : rps) {
                            product = new VirtualMachineProduct();
                            product.setCpuCount(cpu);
                            product.setDescription("Custom product " + architecture + " - " + cpu + " CPU, " + ram + "MB RAM");
                            product.setName("Pool " + pool.getName() + "/" + cpu + " CPU/" + ram + " MB RAM");
                            product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                            product.setProviderProductId(pool.getProvideResourcePoolId() + ":" + cpu + ":" + ram);
                            product.setRamSize(new Storage((Number)ram, (StorageUnit)Storage.MEGABYTE));
                            allVirtualMachineProducts.add(product);
                        }
                    }
                }
            }
            if (options != null) {
                ArrayList<VirtualMachineProduct> filteredProducts = new ArrayList<VirtualMachineProduct>();
                for (VirtualMachineProduct product : allVirtualMachineProducts) {
                    if (!options.matches(product)) continue;
                    filteredProducts.add(product);
                }
                ArrayList<VirtualMachineProduct> arrayList = filteredProducts;
                return arrayList;
            }
            ArrayList<VirtualMachineProduct> arrayList = allVirtualMachineProducts;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        return this.getCapabilities().listSupportedArchitectures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.listVirtualMachineStatus");
        try {
            ManagedEntity[] mes;
            ServiceInstance instance = this.getServiceInstance();
            Folder folder = ((PrivateCloud)this.getProvider()).getVmFolder(instance);
            ArrayList<ResourceStatus> servers = new ArrayList<ResourceStatus>();
            try {
                mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (mes != null && mes.length > 0) {
                for (ManagedEntity entity : mes) {
                    ResourceStatus server = this.toStatus((VirtualMachine)entity);
                    if (server == null) continue;
                    servers.add(server);
                }
            }
            ArrayList<ResourceStatus> arrayList = servers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    VirtualMachine getVirtualMachine(@Nonnull ServiceInstance instance, @Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.getVirtualMachine(ServiceInstance, String)");
        try {
            ManagedEntity[] mes;
            Folder folder = ((PrivateCloud)this.getProvider()).getVmFolder(instance);
            try {
                mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (mes != null && mes.length > 0) {
                for (ManagedEntity entity : mes) {
                    VirtualMachineConfigInfo cfg;
                    VirtualMachine vm = (VirtualMachine)entity;
                    VirtualMachineConfigInfo virtualMachineConfigInfo = cfg = vm == null ? null : vm.getConfig();
                    if (cfg == null || !cfg.getInstanceUuid().equals(vmId)) continue;
                    VirtualMachine virtualMachine = vm;
                    return virtualMachine;
                }
            }
            VirtualMachine virtualMachine = null;
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private Datacenter getVmwareDatacenter(@Nonnull VirtualMachine vm) throws CloudException {
        ManagedEntity parent = vm.getParent();
        if (parent == null) {
            parent = vm.getParentVApp();
        }
        while (parent != null) {
            if (parent instanceof Datacenter) {
                return (Datacenter)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public org.dasein.cloud.compute.VirtualMachine launch(@Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.launch");
        try {
            org.dasein.cloud.compute.VirtualMachine server;
            ServiceInstance instance = this.getServiceInstance();
            boolean isOSId = false;
            String imageId = withLaunchOptions.getMachineImageId();
            try {
                VirtualMachineGuestOsIdentifier os = VirtualMachineGuestOsIdentifier.valueOf((String)imageId);
                isOSId = true;
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("Couldn't find a match to os identifier so trying existing templates instead: " + imageId));
            }
            if (!isOSId) {
                try {
                    VirtualMachine template = this.getTemplate(instance, imageId);
                    if (template == null) {
                        throw new CloudException("No such template or guest os identifier: " + imageId);
                    }
                    server = this.defineFromTemplate(withLaunchOptions);
                }
                catch (RemoteException e) {
                    throw new CloudException((Throwable)e);
                }
            } else {
                server = this.defineFromScratch(withLaunchOptions);
            }
            org.dasein.cloud.compute.VirtualMachine virtualMachine = server;
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<org.dasein.cloud.compute.VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.listVirtualMachines");
        try {
            ManagedEntity[] mes;
            ServiceInstance instance = this.getServiceInstance();
            Folder folder = ((PrivateCloud)this.getProvider()).getVmFolder(instance);
            ArrayList<org.dasein.cloud.compute.VirtualMachine> servers = new ArrayList<org.dasein.cloud.compute.VirtualMachine>();
            try {
                mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (mes != null && mes.length > 0) {
                for (ManagedEntity entity : mes) {
                    org.dasein.cloud.compute.VirtualMachine server = this.toServer((VirtualMachine)entity, null);
                    if (server == null) continue;
                    servers.add(server);
                }
            }
            ArrayList<org.dasein.cloud.compute.VirtualMachine> arrayList = servers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(@Nonnull String serverId) throws InternalException, CloudException {
        block8: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.resume");
            try {
                ServiceInstance instance = this.getServiceInstance();
                VirtualMachine vm = this.getVirtualMachine(instance, serverId);
                if (vm == null) break block8;
                try {
                    vm.powerOnVM_Task(null);
                }
                catch (TaskInProgress e) {
                    throw new CloudException((Throwable)e);
                }
                catch (InvalidState e) {
                    throw new CloudException((Throwable)e);
                }
                catch (RuntimeFault e) {
                    throw new InternalException((Throwable)e);
                }
                catch (RemoteException e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        block8: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.stop");
            try {
                ServiceInstance instance = this.getServiceInstance();
                VirtualMachine vm = this.getVirtualMachine(instance, vmId);
                if (vm == null) break block8;
                try {
                    vm.powerOffVM_Task();
                }
                catch (TaskInProgress e) {
                    throw new CloudException((Throwable)e);
                }
                catch (InvalidState e) {
                    throw new CloudException((Throwable)e);
                }
                catch (RuntimeFault e) {
                    throw new InternalException((Throwable)e);
                }
                catch (RemoteException e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(@Nonnull String serverId) throws InternalException, CloudException {
        block8: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.suspend");
            try {
                ServiceInstance instance = this.getServiceInstance();
                VirtualMachine vm = this.getVirtualMachine(instance, serverId);
                if (vm == null) break block8;
                try {
                    vm.suspendVM_Task();
                }
                catch (TaskInProgress e) {
                    throw new CloudException((Throwable)e);
                }
                catch (InvalidState e) {
                    throw new CloudException((Throwable)e);
                }
                catch (RuntimeFault e) {
                    throw new InternalException((Throwable)e);
                }
                catch (RemoteException e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(@Nonnull String serverId) throws CloudException, InternalException {
        block9: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.reboot");
            try {
                String id = serverId;
                ServiceInstance instance = ((PrivateCloud)this.getProvider()).getServiceInstance();
                VirtualMachine vm = this.getVirtualMachine(instance, id);
                if (vm.getRuntime().getPowerState().equals((Object)VirtualMachinePowerState.poweredOn)) {
                    try {
                        vm.rebootGuest();
                        break block9;
                    }
                    catch (TaskInProgress e) {
                        throw new CloudException((Throwable)e);
                    }
                    catch (InvalidState e) {
                        throw new CloudException((Throwable)e);
                    }
                    catch (RuntimeFault e) {
                        throw new InternalException((Throwable)e);
                    }
                    catch (RemoteException e) {
                        throw new CloudException((Throwable)e);
                    }
                }
                throw new CloudException("Vm must be powered on before rebooting os");
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void powerOnAndOff(@Nonnull String serverId) {
        block8: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.powerOnAndOff");
            try {
                try {
                    ServiceInstance instance = ((PrivateCloud)this.getProvider()).getServiceInstance();
                    VirtualMachine vm = this.getVirtualMachine(instance, serverId);
                    HostSystem host = this.getHost(vm);
                    if (vm == null) break block8;
                    Task task = vm.powerOffVM_Task();
                    String status = task.waitForTask();
                    if (!status.equals("success")) {
                        System.err.println("Reboot failed: " + status);
                        break block8;
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    vm = this.getVirtualMachine(instance, serverId);
                    vm.powerOnVM_Task(host);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    public void terminate(@Nonnull String serverId) throws InternalException, CloudException {
        this.terminate(serverId, "");
    }

    public void terminate(@Nonnull String vmId, String explanation) throws InternalException, CloudException {
        final String id = vmId;
        ((PrivateCloud)this.getProvider()).hold();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Vm.this.terminateVm(id);
                }
                finally {
                    ((PrivateCloud)Vm.this.getProvider()).release();
                }
            }
        };
        t.setName("Terminate " + vmId);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateVm(@Nonnull String serverId) {
        block10: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Vm.terminateVm");
            try {
                try {
                    VirtualMachineRuntimeInfo runtime;
                    ServiceInstance instance = this.getServiceInstance();
                    VirtualMachine vm = this.getVirtualMachine(instance, serverId);
                    if (vm == null || (runtime = vm.getRuntime()) == null) break block10;
                    String status = "";
                    VirtualMachinePowerState state = runtime.getPowerState();
                    if (state != VirtualMachinePowerState.poweredOff) {
                        Task task = vm.powerOffVM_Task();
                        status = task.waitForTask();
                    }
                    if (!status.equals("") && !status.equals("success")) {
                        System.err.println("Termination failed: " + status);
                        break block10;
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    vm = this.getVirtualMachine(instance, serverId);
                    if (vm != null) {
                        vm.destroy_Task();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    private boolean isPublicIpAddress(@Nonnull String ipv4Address) {
        if (ipv4Address.startsWith("10.") || ipv4Address.startsWith("192.168") || ipv4Address.startsWith("169.254")) {
            return false;
        }
        if (ipv4Address.startsWith("172.")) {
            String[] parts = ipv4Address.split("\\.");
            if (parts.length != 4) {
                return true;
            }
            int x = Integer.parseInt(parts[1]);
            if (x >= 16 && x <= 31) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable VirtualMachine vm) {
        VirtualMachineConfigInfo vminfo;
        if (vm == null) {
            return null;
        }
        try {
            vminfo = vm.getConfig();
        }
        catch (RuntimeException e) {
            return null;
        }
        if (vminfo == null || vminfo.isTemplate()) {
            return null;
        }
        String id = vminfo.getInstanceUuid();
        if (id == null) {
            return null;
        }
        VirtualMachineRuntimeInfo runtime = vm.getRuntime();
        VmState vmState = VmState.PENDING;
        if (runtime != null) {
            VirtualMachinePowerState state = runtime.getPowerState();
            switch (state) {
                case suspended: {
                    vmState = VmState.SUSPENDED;
                    break;
                }
                case poweredOff: {
                    vmState = VmState.STOPPED;
                    break;
                }
                case poweredOn: {
                    vmState = VmState.RUNNING;
                    break;
                }
                default: {
                    System.out.println("DEBUG: Unknown vSphere server state: " + state);
                }
            }
        }
        return new ResourceStatus(id, (Object)vmState);
    }

    @Nullable
    private org.dasein.cloud.compute.VirtualMachine toServer(@Nullable VirtualMachine vm, @Nullable String description) throws InternalException, CloudException {
        if (vm != null) {
            VirtualMachineRuntimeInfo runtime;
            VirtualMachineConfigInfo vminfo;
            try {
                vminfo = vm.getConfig();
            }
            catch (RuntimeException e) {
                return null;
            }
            if (vminfo == null || vminfo.isTemplate()) {
                return null;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            VirtualMachineConfigInfoDatastoreUrlPair[] datastoreUrl = vminfo.getDatastoreUrl();
            for (int i = 0; i < datastoreUrl.length; ++i) {
                properties.put("datastore" + i, datastoreUrl[i].getName());
            }
            for (ManagedEntity parent = vm.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Folder)) continue;
                properties.put("vmFolder", parent.getName());
                break;
            }
            VirtualMachineGuestOsIdentifier os = VirtualMachineGuestOsIdentifier.valueOf((String)vminfo.getGuestId());
            org.dasein.cloud.compute.VirtualMachine server = new org.dasein.cloud.compute.VirtualMachine();
            HostSystem host = this.getHost(vm);
            if (host != null) {
                server.setAffinityGroupId(host.getName());
            }
            server.setName(vm.getName());
            server.setPlatform(Platform.guess((String)vminfo.getGuestFullName()));
            server.setProviderVirtualMachineId(vm.getConfig().getInstanceUuid());
            server.setPersistent(true);
            server.setImagable(true);
            server.setClonable(true);
            server.setArchitecture(this.getArchitecture(os));
            if (description == null) {
                description = vm.getName();
            }
            server.setDescription(description);
            server.setProductId(this.getProduct(vminfo.getHardware()).getProviderProductId());
            String imageId = vminfo.getAnnotation();
            if (imageId != null && imageId.length() > 0 && !imageId.contains(" ")) {
                server.setProviderMachineImageId(imageId);
            } else {
                server.setProviderMachineImageId(this.getContext().getAccountNumber() + "-unknown");
            }
            String dc = this.getDataCenter(vm);
            if (dc == null) {
                return null;
            }
            DataCenter ourDC = ((PrivateCloud)this.getProvider()).getDataCenterServices().getDataCenter(dc);
            if (ourDC != null) {
                server.setProviderDataCenterId(dc);
                server.setProviderRegionId(ourDC.getRegionId());
            } else if (dc.equals(this.getContext().getRegionId())) {
                server.setProviderDataCenterId(dc + "-a");
                server.setProviderRegionId(dc);
            } else {
                return null;
            }
            try {
                ResourcePool rp = vm.getResourcePool();
                if (rp != null) {
                    String id = ((PrivateCloud)this.getProvider()).getDataCenterServices().getIdForResourcePool(rp);
                    server.setResourcePoolId(id);
                }
            }
            catch (InvalidProperty ex) {
                throw new CloudException((Throwable)ex);
            }
            catch (RuntimeFault ex) {
                throw new CloudException((Throwable)ex);
            }
            catch (RemoteException ex) {
                throw new CloudException((Throwable)ex);
            }
            GuestInfo guest = vm.getGuest();
            if (guest != null) {
                GuestNicInfo[] nicInfoArray;
                if (guest.getHostName() != null) {
                    server.setPrivateDnsAddress(guest.getHostName());
                }
                if (guest.getIpAddress() != null) {
                    server.setProviderAssignedIpAddressId(guest.getIpAddress());
                }
                if ((nicInfoArray = guest.getNet()) != null && nicInfoArray.length > 0) {
                    ArrayList<RawAddress> pubIps = new ArrayList<RawAddress>();
                    ArrayList<RawAddress> privIps = new ArrayList<RawAddress>();
                    for (GuestNicInfo nicInfo : nicInfoArray) {
                        String[] ipAddresses;
                        String net = nicInfo.getNetwork();
                        if (net != null && server.getProviderVlanId() == null) {
                            server.setProviderVlanId(net);
                        }
                        if ((ipAddresses = nicInfo.getIpAddress()) == null) continue;
                        for (String ip : ipAddresses) {
                            if (ip == null) continue;
                            if (this.isPublicIpAddress(ip)) {
                                pubIps.add(new RawAddress(ip));
                                continue;
                            }
                            privIps.add(new RawAddress(ip));
                        }
                    }
                    if (privIps != null && privIps.size() > 0) {
                        RawAddress[] rawPriv = privIps.toArray(new RawAddress[privIps.size()]);
                        server.setPrivateAddresses(rawPriv);
                    }
                    if (pubIps != null && pubIps.size() > 0) {
                        RawAddress[] rawPub = pubIps.toArray(new RawAddress[pubIps.size()]);
                        server.setPublicAddresses(rawPub);
                    }
                }
            }
            if ((runtime = vm.getRuntime()) != null) {
                VirtualMachinePowerState state = runtime.getPowerState();
                if (server.getCurrentState() == null) {
                    switch (state) {
                        case suspended: {
                            server.setCurrentState(VmState.SUSPENDED);
                            break;
                        }
                        case poweredOff: {
                            server.setCurrentState(VmState.STOPPED);
                            break;
                        }
                        case poweredOn: {
                            server.setCurrentState(VmState.RUNNING);
                            server.setRebootable(true);
                        }
                    }
                }
                Calendar suspend = runtime.getSuspendTime();
                Calendar time = runtime.getBootTime();
                if (suspend == null || suspend.getTimeInMillis() < 1L) {
                    server.setLastPauseTimestamp(-1L);
                } else {
                    server.setLastPauseTimestamp(suspend.getTimeInMillis());
                    server.setCreationTimestamp(server.getLastPauseTimestamp());
                }
                if (time == null || time.getTimeInMillis() < 1L) {
                    server.setLastBootTimestamp(0L);
                } else {
                    server.setLastBootTimestamp(time.getTimeInMillis());
                    server.setCreationTimestamp(server.getLastBootTimestamp());
                }
            }
            server.setProviderOwnerId(this.getContext().getAccountNumber());
            server.setTags(properties);
            return server;
        }
        return null;
    }

    private String validateName(String name) {
        if ((name = name.toLowerCase().replaceAll("_", "-").replaceAll(" ", "")).length() <= 30) {
            return name;
        }
        return name.substring(0, 30);
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return ((PrivateCloud)this.getProvider()).getServiceInstance() != null;
    }
}

