/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.network;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.NetworkSummary;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.ServiceInstance;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Tag;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.network.AbstractVLANSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANCapabilities;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.vsphere.PrivateCloud;
import org.dasein.cloud.vsphere.network.VSphereNetworkCapabilities;

public class VSphereNetwork
extends AbstractVLANSupport {
    private PrivateCloud provider;
    private volatile transient VSphereNetworkCapabilities capabilities;

    VSphereNetwork(PrivateCloud provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = this.provider.getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    public VLANCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new VSphereNetworkCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "nic";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "network";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    @Nullable
    public String getAttachedInternetGatewayId(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public InternetGateway getInternetGatewayById(@Nonnull String gatewayId) throws CloudException, InternalException {
        return null;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Collection<InternetGateway> listInternetGateways(@Nullable String vlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public void removeInternetGatewayById(@Nonnull String id) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Internet gateways not supported in vSphere");
    }

    public void removeInternetGatewayTags(@Nonnull String internetGatewayId, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeRoutingTableTags(@Nonnull String routingTableId, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateRoutingTableTags(@Nonnull String routingTableId, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateInternetGatewayTags(@Nonnull String internetGatewayId, Tag ... tags) throws CloudException, InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Network.listVlans");
        try {
            ServiceInstance instance = this.getServiceInstance();
            ArrayList<VLAN> networkList = new ArrayList<VLAN>();
            String rid = this.getContext().getRegionId();
            if (rid != null) {
                Datacenter dc = this.provider.getDataCenterServices().getVmwareDatacenterFromVDCId(instance, rid);
                try {
                    Network[] nets = dc.getNetworks();
                    if (nets != null) {
                        for (int d = 0; d < nets.length; ++d) {
                            if (!nets[d].getMOR().getType().equals("Network")) continue;
                            networkList.add(this.toVlan(nets[d]));
                        }
                    }
                }
                catch (InvalidProperty e) {
                    throw new CloudException("No network support in cluster: " + e.getMessage());
                }
                catch (RuntimeFault e) {
                    throw new CloudException("Error in processing request to cluster: " + e.getMessage());
                }
                catch (RemoteException e) {
                    throw new CloudException("Error in cluster processing request: " + e.getMessage());
                }
            }
            ArrayList<VLAN> arrayList = networkList;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    private VLAN toVlan(Network network) throws InternalException, CloudException {
        if (network != null) {
            VLAN vlan = new VLAN();
            vlan.setName(network.getName());
            vlan.setDescription(vlan.getName() + "(" + network.getMOR().getVal() + ")");
            vlan.setProviderVlanId(vlan.getName());
            vlan.setCidr("");
            vlan.setProviderRegionId(this.getContext().getRegionId());
            vlan.setProviderOwnerId(this.getContext().getAccountNumber());
            vlan.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
            vlan.setVisibleScope(VisibleScope.ACCOUNT_REGION);
            NetworkSummary s = network.getSummary();
            vlan.setCurrentState(VLANState.PENDING);
            if (s.isAccessible()) {
                vlan.setCurrentState(VLANState.AVAILABLE);
            }
            return vlan;
        }
        return null;
    }
}

