/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Random;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.crypto.BLSPublicKey;
import org.bitcoinj.crypto.BLSSecretKey;
import org.bitcoinj.crypto.BLSSignature;
import org.dashj.bls.BLS;
import org.dashj.bls.InsecureSignature;
import org.dashj.bls.MessageHashVector;
import org.dashj.bls.PrivateKey;
import org.dashj.bls.PublicKey;
import org.dashj.bls.PublicKeyVector;

public class BLSVerifySignature {
    private static byte[] getRandomSeed(int size) {
        Random rand = new Random();
        BigInteger result = new BigInteger(size * 8 - 1, rand);
        byte[] bytes = new byte[32];
        System.arraycopy(result.toByteArray(), 0, bytes, 0, result.toByteArray().length);
        return bytes;
    }

    private static byte[] getSHA256Hash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(data);
            return hash;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static int sizeof(byte[] bytes) {
        return bytes.length;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("BLS-Signature Test");
        byte[] message = BLSVerifySignature.getRandomSeed(32);
        byte[] hash = BLSVerifySignature.getSHA256Hash(message);
        Sha256Hash sha256Hash = Sha256Hash.wrap((byte[])hash);
        String hashStr = sha256Hash.toString();
        System.out.println("message = " + Sha256Hash.wrap((byte[])message));
        Stopwatch watch = Stopwatch.createStarted();
        for (int i = 0; i < 1000000; ++i) {
            byte[] seed = BLSVerifySignature.getRandomSeed(32);
            PrivateKey sk1 = PrivateKey.FromSeed((byte[])seed, (long)32L);
            InsecureSignature sig1 = sk1.SignInsecure(message, (long)BLSVerifySignature.sizeof(message));
            PublicKey pk1 = sk1.GetPublicKey();
            Preconditions.checkState((boolean)sig1.Verify(hash, pk1), (String)("failed verification:" + sig1 + ".Verify(" + hashStr), (Object)(", " + pk1 + ") " + sk1));
            PublicKeyVector pks = new PublicKeyVector();
            pks.push_back(pk1);
            MessageHashVector messages = new MessageHashVector();
            messages.push_back(message);
            byte[] skBytes = sk1.Serialize();
            BLSSecretKey secretKey = new BLSSecretKey(skBytes);
            BLSSignature signature = secretKey.Sign(sha256Hash);
            BLSPublicKey publicKey = secretKey.GetPublicKey();
            ArrayList<BLSPublicKey> pks2 = new ArrayList<BLSPublicKey>(1);
            pks2.add(publicKey);
            ArrayList<Sha256Hash> messageList = new ArrayList<Sha256Hash>(1);
            messageList.add(sha256Hash);
            Preconditions.checkState((boolean)signature.verifyInsecureAggregated(pks2, messageList), (String)("failed verification 2:" + signature + ".Verify(" + hashStr), (Object)(", " + pk1 + ") " + sk1));
            if (i % 1000 != 0) continue;
            System.out.println("verifying " + i + " " + sk1.toString());
        }
        watch.stop();
        System.out.println("completed test in " + watch.toString());
    }

    static {
        BLS.Init();
    }
}

