/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.MemoryBlockStore;

public class DownloadBlockQuorumCommitment {
    public static void main(String[] args) throws BlockStoreException, ExecutionException, InterruptedException, IOException {
        System.out.println("Connecting to node");
        MainNetParams params = MainNetParams.get();
        MemoryBlockStore blockStore = new MemoryBlockStore((NetworkParameters)params);
        BlockChain chain = new BlockChain((NetworkParameters)params, (BlockStore)blockStore);
        PeerGroup peerGroup = new PeerGroup((NetworkParameters)params, (AbstractBlockChain)chain);
        peerGroup.addPeerDiscovery((PeerDiscovery)new DnsDiscovery((NetworkParameters)params));
        peerGroup.setUseLocalhostPeerWhenPossible(false);
        peerGroup.start();
        peerGroup.waitForPeers(10).get();
        Peer peer = peerGroup.getDownloadPeer();
        String hash = "00000000000000316f3f7c6cd53f70e63ee09bf94deea435c36503f5511a3e09";
        Sha256Hash blockHash = Sha256Hash.wrap((String)hash);
        ListenableFuture future = peer.getBlock(blockHash);
        System.out.println("Waiting for node to send us the requested block: " + blockHash);
        Block block = (Block)future.get();
        System.out.println(block);
        System.out.println("Has TRANSACTION_QUORUM_COMMITMENT: " + block.getTransactions().stream().anyMatch(transaction -> transaction.getType() == Transaction.Type.TRANSACTION_QUORUM_COMMITMENT));
        peerGroup.stopAsync();
    }
}

