/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.UnsafeByteArrayOutputStream;
import org.bitcoinj.core.Utils;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.MemoryBlockStore;

public class DownloadBlocks {
    public static void main(String[] args) throws BlockStoreException, ExecutionException, InterruptedException {
        System.out.println("Connecting to node");
        MainNetParams params = MainNetParams.get();
        MemoryBlockStore blockStore = new MemoryBlockStore((NetworkParameters)params);
        BlockChain chain = new BlockChain((NetworkParameters)params, (BlockStore)blockStore);
        PeerGroup peerGroup = new PeerGroup((NetworkParameters)params, (AbstractBlockChain)chain);
        peerGroup.addPeerDiscovery((PeerDiscovery)new DnsDiscovery((NetworkParameters)params));
        peerGroup.setUseLocalhostPeerWhenPossible(false);
        peerGroup.start();
        peerGroup.waitForPeers(10).get();
        Peer peer = peerGroup.getDownloadPeer();
        for (String hash : new String[]{"0000000000000011fbdfb7ebea7b3b68c11c82f68fe792e4a376f0f3e1ebfee5", "000000000000001b7c5666cbda73912a5bcff8fc179fdd421fc9bfe7b7e7be73", "000000000000000cdf5cc24c3beb0669b31e942d1301e07b53d6f0c7db10860d"}) {
            Sha256Hash blockHash = Sha256Hash.wrap((String)hash);
            ListenableFuture future = peer.getBlock(blockHash);
            System.out.println("Waiting for node to send us the requested block: " + blockHash);
            Block block = (Block)future.get();
            System.out.println(block);
            try {
                UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(block.getMessageSize());
                block.bitcoinSerialize((OutputStream)bos);
                System.out.println(Utils.HEX.encode(bos.toByteArray()));
            }
            catch (IOException x) {
                throw new RuntimeException(x.getMessage());
            }
        }
        peerGroup.stopAsync();
    }
}

