/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.examples.NetworkEnum;
import org.bitcoinj.kits.WalletAppKit;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.protocols.channels.IPaymentChannelClient;
import org.bitcoinj.protocols.channels.PaymentChannelClient;
import org.bitcoinj.protocols.channels.PaymentChannelClientConnection;
import org.bitcoinj.protocols.channels.StoredPaymentChannelClientStates;
import org.bitcoinj.protocols.channels.ValueOutOfRangeException;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.WalletExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamplePaymentChannelClient {
    private static final Logger log = LoggerFactory.getLogger(ExamplePaymentChannelClient.class);
    private WalletAppKit appKit;
    private final Coin channelSize = Coin.CENT;
    private final ECKey myKey = new ECKey();
    private final NetworkParameters params = RegTestParams.get();

    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec net = parser.accepts("net", "The network to run the examples on").withRequiredArg().ofType(NetworkEnum.class).defaultsTo((Object)NetworkEnum.TEST, (Object[])new NetworkEnum[0]);
        ArgumentAcceptingOptionSpec version = parser.accepts("version", "The payment channel protocol to use").withRequiredArg().ofType(Integer.class);
        parser.accepts("help", "Displays program options");
        OptionSet opts = parser.parse(args);
        if (opts.has("help") || !opts.has((OptionSpec)net) || opts.nonOptionArguments().size() != 1) {
            System.err.println("usage: ExamplePaymentChannelClient --net=MAIN/TEST/REGTEST --version=1/2 host");
            parser.printHelpOn((OutputStream)System.err);
            return;
        }
        PaymentChannelClient.DefaultClientChannelProperties clientChannelProperties = new PaymentChannelClient.DefaultClientChannelProperties(){

            public PaymentChannelClient.VersionSelector versionSelector() {
                return PaymentChannelClient.VersionSelector.VERSION_1;
            }
        };
        if (opts.has("version")) {
            switch ((Integer)version.value(opts)) {
                case 1: {
                    break;
                }
                case 2: {
                    clientChannelProperties = new PaymentChannelClient.DefaultClientChannelProperties(){

                        public PaymentChannelClient.VersionSelector versionSelector() {
                            return PaymentChannelClient.VersionSelector.VERSION_2;
                        }
                    };
                    break;
                }
                default: {
                    System.err.println("Invalid version - valid versions are 1, 2");
                    return;
                }
            }
        }
        NetworkParameters params = ((NetworkEnum)((Object)net.value(opts))).get();
        new ExamplePaymentChannelClient().run((String)opts.nonOptionArguments().get(0), (IPaymentChannelClient.ClientChannelProperties)clientChannelProperties, params);
    }

    public void run(String host, IPaymentChannelClient.ClientChannelProperties clientChannelProperties, NetworkParameters params) throws Exception {
        int timeoutSeconds;
        this.appKit = new WalletAppKit(params, new File("."), "payment_channel_example_client"){

            protected List<WalletExtension> provideWalletExtensions() {
                return ImmutableList.of((Object)new StoredPaymentChannelClientStates(null));
            }
        };
        int n = timeoutSeconds = params.getId().equals("org.bitcoin.regtest") ? 15 : 150;
        if (params == RegTestParams.get()) {
            this.appKit.connectToLocalHost();
        }
        this.appKit.startAsync();
        this.appKit.awaitRunning();
        this.appKit.wallet().importKey(this.myKey);
        this.appKit.wallet().allowSpendingUnconfirmedTransactions();
        System.out.println(this.appKit.wallet());
        InetSocketAddress server = new InetSocketAddress(host, 4242);
        this.waitForSufficientBalance(this.channelSize);
        String channelID = host;
        log.info("Round one ...");
        this.openAndSend(timeoutSeconds, server, channelID, 5, clientChannelProperties);
        log.info("Round two ...");
        log.info(this.appKit.wallet().toString());
        this.openAndSend(timeoutSeconds, server, channelID, 4, clientChannelProperties);
        log.info("Stopping ...");
        this.appKit.stopAsync();
        this.appKit.awaitTerminated();
    }

    private void openAndSend(int timeoutSecs, InetSocketAddress server, String channelID, final int times, IPaymentChannelClient.ClientChannelProperties clientChannelProperties) throws IOException, ValueOutOfRangeException, InterruptedException {
        PaymentChannelClientConnection client = new PaymentChannelClientConnection(server, timeoutSecs, this.appKit.wallet(), this.myKey, this.channelSize, channelID, null, clientChannelProperties);
        final CountDownLatch latch = new CountDownLatch(1);
        Futures.addCallback((ListenableFuture)client.getChannelOpenFuture(), (FutureCallback)new FutureCallback<PaymentChannelClientConnection>(){

            public void onSuccess(PaymentChannelClientConnection client) {
                log.info("Success! Trying to make {} micropayments. Already paid {} satoshis on this channel", (Object)times, (Object)client.state().getValueSpent());
                Coin MICROPAYMENT_SIZE = Coin.CENT.divide(10L);
                for (int i = 0; i < times; ++i) {
                    try {
                        Uninterruptibles.getUninterruptibly((Future)client.incrementPayment(MICROPAYMENT_SIZE));
                    }
                    catch (ValueOutOfRangeException e) {
                        log.error("Failed to increment payment by a CENT, remaining value is {}", (Object)client.state().getValueRefunded());
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        log.error("Failed to increment payment", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    log.info("Successfully sent payment of one CENT, total remaining on channel is now {}", (Object)client.state().getValueRefunded());
                }
                if (client.state().getValueRefunded().compareTo(MICROPAYMENT_SIZE) < 0) {
                    log.info("Settling channel for good");
                    client.settle();
                } else {
                    client.disconnectWithoutSettlement();
                }
                latch.countDown();
            }

            public void onFailure(Throwable throwable) {
                log.error("Failed to open connection", throwable);
                latch.countDown();
            }
        }, (Executor)Threading.USER_THREAD);
        latch.await();
    }

    private void waitForSufficientBalance(Coin amount) {
        Coin amountPlusFee = amount.add(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE);
        ListenableFuture balanceFuture = this.appKit.wallet().getBalanceFuture(amountPlusFee, Wallet.BalanceType.ESTIMATED);
        if (!balanceFuture.isDone()) {
            System.out.println("Please send " + amountPlusFee.toFriendlyString() + " to " + Address.fromKey((NetworkParameters)this.params, (ECKey)this.myKey));
            Futures.getUnchecked((Future)balanceFuture);
        }
    }
}

