/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.examples.NetworkEnum;
import org.bitcoinj.kits.WalletAppKit;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.protocols.channels.PaymentChannelCloseException;
import org.bitcoinj.protocols.channels.PaymentChannelServerListener;
import org.bitcoinj.protocols.channels.PaymentChannelServerState;
import org.bitcoinj.protocols.channels.ServerConnectionEventHandler;
import org.bitcoinj.protocols.channels.StoredPaymentChannelServerStates;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.wallet.WalletExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamplePaymentChannelServer
implements PaymentChannelServerListener.HandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(ExamplePaymentChannelServer.class);
    private WalletAppKit appKit;

    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec net = parser.accepts("net", "The network to run the examples on").withRequiredArg().ofType(NetworkEnum.class).defaultsTo((Object)NetworkEnum.TEST, (Object[])new NetworkEnum[0]);
        parser.accepts("help", "Displays program options");
        OptionSet opts = parser.parse(args);
        if (opts.has("help") || !opts.has((OptionSpec)net)) {
            System.err.println("usage: ExamplePaymentChannelServer --net=MAIN/TEST/REGTEST");
            parser.printHelpOn((OutputStream)System.err);
            return;
        }
        NetworkParameters params = ((NetworkEnum)((Object)net.value(opts))).get();
        new ExamplePaymentChannelServer().run(params);
    }

    public void run(NetworkParameters params) throws Exception {
        int timeoutSeconds;
        this.appKit = new WalletAppKit(params, new File("."), "payment_channel_example_server"){

            protected List<WalletExtension> provideWalletExtensions() {
                return ImmutableList.of((Object)new StoredPaymentChannelServerStates(null));
            }
        };
        int n = timeoutSeconds = params.getId().equals("org.bitcoin.regtest") ? 15 : 150;
        if (params == RegTestParams.get()) {
            this.appKit.connectToLocalHost();
        }
        this.appKit.startAsync();
        this.appKit.awaitRunning();
        System.out.println(this.appKit.wallet());
        new PaymentChannelServerListener((TransactionBroadcaster)this.appKit.peerGroup(), this.appKit.wallet(), timeoutSeconds, Coin.valueOf((long)100000L), (PaymentChannelServerListener.HandlerFactory)this).bindAndStart(4242);
    }

    public ServerConnectionEventHandler onNewConnection(final SocketAddress clientAddress) {
        return new ServerConnectionEventHandler(){

            public void channelOpen(Sha256Hash channelId) {
                log.info("Channel open for {}: {}.", (Object)clientAddress, (Object)channelId);
                PaymentChannelServerState state = null;
                try {
                    StoredPaymentChannelServerStates storedStates = (StoredPaymentChannelServerStates)ExamplePaymentChannelServer.this.appKit.wallet().getExtensions().get(StoredPaymentChannelServerStates.class.getName());
                    state = storedStates.getChannel(channelId).getOrCreateState(ExamplePaymentChannelServer.this.appKit.wallet(), (TransactionBroadcaster)ExamplePaymentChannelServer.this.appKit.peerGroup());
                }
                catch (VerificationException e) {
                    throw new RuntimeException(e);
                }
                log.info("   with a maximum value of {}, expiring at UNIX timestamp {}.", (Object)state.getContract().getOutput(0L).getValue(), (Object)(state.getExpiryTime() + -7200L));
            }

            public ListenableFuture<ByteString> paymentIncrease(Coin by, Coin to, ByteString info) {
                log.info("Client {} paid increased payment by {} for a total of " + to.toString(), (Object)clientAddress, (Object)by);
                return null;
            }

            public void channelClosed(PaymentChannelCloseException.CloseReason reason) {
                log.info("Client {} closed channel for reason {}", (Object)clientAddress, (Object)reason);
            }
        };
    }
}

