/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.List;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.utils.BriefLogFormatter;

public class FetchBlock {
    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        OptionParser parser = new OptionParser();
        OptionSet opts = null;
        List nonOpts = null;
        try {
            parser.accepts("localhost", "Connect to the localhost node");
            parser.accepts("help", "Displays program options");
            opts = parser.parse(args);
            if (opts.has("help")) {
                System.out.println("usage: org.bitcoinj.examples.FetchBlock [--localhost] <blockHash>");
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            nonOpts = opts.nonOptionArguments();
            if (nonOpts.size() != 1) {
                throw new IllegalArgumentException("Incorrect number of block hash, please provide only one block hash.");
            }
        }
        catch (IllegalArgumentException | OptionException e) {
            System.err.println(e.getMessage());
            System.err.println("usage: org.bitcoinj.examples.FetchBlock [--localhost] <blockHash>");
            parser.printHelpOn((OutputStream)System.err);
            return;
        }
        System.out.println("Connecting to node");
        TestNet3Params params = TestNet3Params.get();
        MemoryBlockStore blockStore = new MemoryBlockStore((NetworkParameters)params);
        BlockChain chain = new BlockChain((NetworkParameters)params, (BlockStore)blockStore);
        PeerGroup peerGroup = new PeerGroup((NetworkParameters)params, (AbstractBlockChain)chain);
        if (!opts.has("localhost")) {
            peerGroup.addPeerDiscovery((PeerDiscovery)new DnsDiscovery((NetworkParameters)params));
        } else {
            PeerAddress addr = new PeerAddress((NetworkParameters)params, InetAddress.getLocalHost());
            peerGroup.addAddress(addr);
        }
        peerGroup.start();
        peerGroup.waitForPeers(1).get();
        Peer peer = (Peer)peerGroup.getConnectedPeers().get(0);
        Sha256Hash blockHash = Sha256Hash.wrap((byte[])((byte[])nonOpts.get(0)));
        ListenableFuture future = peer.getBlock(blockHash);
        System.out.println("Waiting for node to send us the requested block: " + blockHash);
        Block block = (Block)future.get();
        System.out.println(block);
        peerGroup.stopAsync();
    }
}

