/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.util.List;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.utils.BriefLogFormatter;

public class FetchTransactions {
    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        System.out.println("Connecting to node");
        TestNet3Params params = TestNet3Params.get();
        MemoryBlockStore blockStore = new MemoryBlockStore((NetworkParameters)params);
        BlockChain chain = new BlockChain((NetworkParameters)params, (BlockStore)blockStore);
        PeerGroup peerGroup = new PeerGroup((NetworkParameters)params, (AbstractBlockChain)chain);
        peerGroup.start();
        peerGroup.addAddress(new PeerAddress((NetworkParameters)params, InetAddress.getLocalHost()));
        peerGroup.waitForPeers(1).get();
        Peer peer = (Peer)peerGroup.getConnectedPeers().get(0);
        Sha256Hash txHash = Sha256Hash.wrap((String)args[0]);
        ListenableFuture future = peer.getPeerMempoolTransaction(txHash);
        System.out.println("Waiting for node to send us the requested transaction: " + txHash);
        Transaction tx = (Transaction)future.get();
        System.out.println(tx);
        System.out.println("Waiting for node to send us the dependencies ...");
        List deps = (List)peer.downloadDependencies(tx).get();
        for (Transaction dep : deps) {
            System.out.println("Got dependency " + dep.getTxId());
        }
        System.out.println("Done.");
        peerGroup.stop();
    }
}

