/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.util.concurrent.Executor;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.crypto.KeyCrypterException;
import org.bitcoinj.kits.FullPrunedWalletAppKit;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.ThreeMethodPeerDiscovery;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.listeners.WalletCoinsReceivedEventListener;

public class FullPrunedForwardingService {
    private static Address forwardingAddress;
    private static FullPrunedWalletAppKit kit;

    public static void main(String[] args) throws Exception {
        String filePrefix;
        MainNetParams params;
        BriefLogFormatter.init();
        if (args.length < 1) {
            System.err.println("Usage: address-to-send-back-to [regtest|testnet]");
            return;
        }
        if (args.length > 1 && args[1].equals("testnet")) {
            params = TestNet3Params.get();
            filePrefix = "forwarding-service-testnet";
        } else if (args.length > 1 && args[1].equals("regtest")) {
            params = RegTestParams.get();
            filePrefix = "forwarding-service-regtest";
        } else {
            params = MainNetParams.get();
            filePrefix = "forwarding-service";
        }
        forwardingAddress = Address.fromBase58((NetworkParameters)params, (String)args[0]);
        kit = new FullPrunedWalletAppKit((NetworkParameters)params, new File("."), filePrefix);
        kit.setDiscovery((PeerDiscovery)new ThreeMethodPeerDiscovery((NetworkParameters)params, Context.get().masternodeListManager));
        if (params == RegTestParams.get()) {
            kit.connectToLocalHost();
        }
        kit.startAsync();
        kit.awaitRunning();
        kit.wallet().addCoinsReceivedEventListener(new WalletCoinsReceivedEventListener(){

            public void onCoinsReceived(Wallet w, final Transaction tx, Coin prevBalance, Coin newBalance) {
                Coin value = tx.getValueSentToMe((TransactionBag)w);
                System.out.println("Received tx for " + value.toFriendlyString() + ": " + tx);
                System.out.println("Transaction will be forwarded after it confirms.");
                Futures.addCallback((ListenableFuture)tx.getConfidence().getDepthFuture(1), (FutureCallback)new FutureCallback<TransactionConfidence>(){

                    public void onSuccess(TransactionConfidence result) {
                        FullPrunedForwardingService.forwardCoins(tx);
                    }

                    public void onFailure(Throwable t) {
                        throw new RuntimeException(t);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
        });
        Address sendToAddress = Address.fromKey((NetworkParameters)params, (ECKey)kit.wallet().currentReceiveKey());
        System.out.println("Send coins to: " + sendToAddress);
        System.out.println("Waiting for coins to arrive. Press Ctrl-C to quit.");
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void forwardCoins(Transaction tx) {
        try {
            Coin value = tx.getValueSentToMe((TransactionBag)kit.wallet());
            System.out.println("Forwarding " + value.toFriendlyString());
            Coin amountToSend = value.subtract(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE);
            final Wallet.SendResult sendResult = kit.wallet().sendCoins((TransactionBroadcaster)kit.peerGroup(), forwardingAddress, amountToSend);
            Preconditions.checkNotNull((Object)sendResult);
            System.out.println("Sending ...");
            sendResult.broadcastComplete.addListener(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Sent coins onwards! Transaction hash is " + sendResult.tx.getHashAsString());
                }
            }, MoreExecutors.directExecutor());
        }
        catch (InsufficientMoneyException | KeyCrypterException e) {
            throw new RuntimeException(e);
        }
    }
}

