/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.net.discovery.SeedPeers;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.TestNet3Params;

public class PortOpen {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean available(String address, int port) {
        try (Socket ignored = new Socket(address, port);){
            boolean bl = false;
            return bl;
        }
        catch (IOException ignored2) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serverListening(String host, int port) {
        Socket s = null;
        try {
            s = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) {
        MainNetParams params = MainNetParams.get();
        if (args[0].equals("testnet")) {
            params = TestNet3Params.get();
        }
        SeedPeers seedPeers = new SeedPeers((NetworkParameters)params);
        try {
            int index = 0;
            int notAvailable = 0;
            for (InetSocketAddress address : seedPeers.getPeers(0L, 10L, TimeUnit.SECONDS)) {
                boolean available = PortOpen.serverListening(address.getAddress().getHostAddress(), params.getPort());
                System.out.println(address.getAddress() + " is " + (available ? "available" : "not available"));
                ++index;
                notAvailable += available ? 0 : 1;
            }
            System.out.println(notAvailable * 100 / index + "% are not available");
        }
        catch (PeerDiscoveryException x) {
            System.out.println("Error: " + x.getMessage());
        }
    }
}

