/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import java.math.BigInteger;
import java.net.InetAddress;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.DumpedPrivateKey;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.wallet.Wallet;

public class PrivateKeys {
    public static void main(String[] args) throws Exception {
        MainNetParams params = MainNetParams.get();
        try {
            ECKey key;
            if (args[0].length() == 51 || args[0].length() == 52) {
                DumpedPrivateKey dumpedPrivateKey = DumpedPrivateKey.fromBase58((NetworkParameters)params, (String)args[0]);
                key = dumpedPrivateKey.getKey();
            } else {
                BigInteger privKey = Base58.decodeToBigInteger((String)args[0]);
                key = ECKey.fromPrivate((BigInteger)privKey);
            }
            System.out.println("Address from private key is: " + Address.fromKey((NetworkParameters)params, (ECKey)key).toString());
            Address destination = Address.fromBase58((NetworkParameters)params, (String)args[1]);
            Wallet wallet = new Wallet((NetworkParameters)params);
            wallet.importKey(key);
            MemoryBlockStore blockStore = new MemoryBlockStore((NetworkParameters)params);
            BlockChain chain = new BlockChain((NetworkParameters)params, wallet, (BlockStore)blockStore);
            PeerGroup peerGroup = new PeerGroup((NetworkParameters)params, (AbstractBlockChain)chain);
            peerGroup.addAddress(new PeerAddress((NetworkParameters)params, InetAddress.getLocalHost()));
            peerGroup.startAsync();
            peerGroup.downloadBlockChain();
            peerGroup.stopAsync();
            System.out.println("Claiming " + wallet.getBalance().toFriendlyString());
            wallet.sendCoins((TransactionBroadcaster)peerGroup, destination, wallet.getBalance());
            Thread.sleep(5000L);
            System.exit(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("First arg should be private key in Base58 format. Second argument should be address to send to.");
        }
    }
}

