/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import java.io.File;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.WalletExtension;
import org.bitcoinj.wallet.listeners.WalletCoinsReceivedEventListener;

public class RefreshWallet {
    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        Wallet wallet = Wallet.loadFromFile((File)file, (WalletExtension[])new WalletExtension[0]);
        System.out.println(wallet.toString());
        TestNet3Params params = TestNet3Params.get();
        MemoryBlockStore blockStore = new MemoryBlockStore((NetworkParameters)params);
        BlockChain chain = new BlockChain((NetworkParameters)params, wallet, (BlockStore)blockStore);
        PeerGroup peerGroup = new PeerGroup((NetworkParameters)params, (AbstractBlockChain)chain);
        peerGroup.startAsync();
        wallet.addCoinsReceivedEventListener(new WalletCoinsReceivedEventListener(){

            public synchronized void onCoinsReceived(Wallet w, Transaction tx, Coin prevBalance, Coin newBalance) {
                System.out.println("\nReceived tx " + tx.getTxId());
                System.out.println(tx.toString());
            }
        });
        peerGroup.downloadBlockChain();
        peerGroup.stopAsync();
        wallet.saveToFile(file);
        System.out.println("\nDone!\n");
        System.out.println(wallet.toString());
    }
}

