/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator;

import java.util.Arrays;
import java.util.List;
import org.databene.benerator.PropertyMessage;
import org.databene.commons.ConfigurationError;

public class InvalidGeneratorSetupException
extends ConfigurationError {
    private static final long serialVersionUID = 7613352958748575041L;
    private List<PropertyMessage> propertyMessages;

    public InvalidGeneratorSetupException(String propertyName, String propertyMessage) {
        this(new PropertyMessage(propertyName, propertyMessage));
    }

    public InvalidGeneratorSetupException(PropertyMessage ... propertyMessages) {
        this((String)null, (Throwable)null, propertyMessages);
    }

    public InvalidGeneratorSetupException(String textMessage) {
        this(textMessage, (Throwable)null);
    }

    public InvalidGeneratorSetupException(Throwable cause) {
        this(null, cause);
    }

    public InvalidGeneratorSetupException(String textMessage, Throwable cause) {
        this(textMessage, cause, new PropertyMessage[0]);
    }

    public InvalidGeneratorSetupException(String textMessage, Throwable cause, PropertyMessage ... propertyMessages) {
        super(InvalidGeneratorSetupException.formatMessage(textMessage, propertyMessages), cause);
        this.propertyMessages = Arrays.asList(propertyMessages);
    }

    public PropertyMessage[] getPropertyMessages() {
        PropertyMessage[] array = new PropertyMessage[this.propertyMessages.size()];
        return this.propertyMessages.toArray(array);
    }

    private static String formatMessage(String textMessage, PropertyMessage ... propertyMessages) {
        StringBuilder buffer = new StringBuilder();
        if (textMessage != null) {
            buffer.append(textMessage).append(": ");
        }
        for (int i = 0; i < propertyMessages.length; ++i) {
            PropertyMessage propertyMessage = propertyMessages[i];
            buffer.append(propertyMessage);
            if (i >= propertyMessages.length - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

