/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.composite;

import java.util.Map;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.Entity;
import org.databene.model.data.PrimitiveType;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeConverter
extends FixedSourceTypeConverter<Entity, Entity> {
    private ComplexTypeDescriptor type;

    public ComponentTypeConverter(ComplexTypeDescriptor type) {
        super(Entity.class, Entity.class);
        this.type = type;
    }

    public Entity convert(Entity entity) throws ConversionException {
        if (entity == null) {
            return null;
        }
        if (!this.type.getName().equals(entity.getName())) {
            throw new ConfigurationError("Expected '" + this.type.getName() + "', found: '" + entity + "'");
        }
        Map<String, Object> components = entity.getComponents();
        for (Map.Entry<String, Object> entry : components.entrySet()) {
            String componentName = entry.getKey();
            ComponentDescriptor componentDescriptor = this.type.getComponent(componentName);
            if (componentDescriptor == null) continue;
            TypeDescriptor componentType = componentDescriptor.getType();
            Object componentValue = entry.getValue();
            if (componentType instanceof SimpleTypeDescriptor) {
                PrimitiveType primitive = ((SimpleTypeDescriptor)componentType).getPrimitiveType();
                if (primitive == null) {
                    primitive = PrimitiveType.STRING;
                }
                Class<?> javaType = primitive.getJavaType();
                Object javaValue = AnyConverter.convert((Object)componentValue, javaType);
                components.put(componentName, javaValue);
                continue;
            }
            components.put(componentName, this.convert((Entity)componentValue));
        }
        return entity;
    }
}

