/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.composite;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.commons.Context;
import org.databene.model.data.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredEntityGenerator
implements Generator<Entity> {
    private static Log logger = LogFactory.getLog(ConfiguredEntityGenerator.class);
    private static long entityCount = 0L;
    private Generator<Entity> entityGenerator;
    private Map<String, Generator<? extends Object>> variables;
    private Context context;
    private boolean variablesInitialized;

    public ConfiguredEntityGenerator(Generator<Entity> entityGenerator, Map<String, Generator<? extends Object>> variables, Context context) {
        this.entityGenerator = entityGenerator;
        this.variables = variables;
        this.context = context;
        this.variablesInitialized = false;
    }

    @Override
    public Class<Entity> getGeneratedType() {
        return Entity.class;
    }

    @Override
    public void validate() {
        for (Generator<? extends Object> varGen : this.variables.values()) {
            varGen.validate();
        }
        this.entityGenerator.validate();
    }

    @Override
    public boolean available() {
        if (!this.variablesInitialized) {
            for (Generator<? extends Object> generator : this.variables.values()) {
                if (generator.available()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No more available: " + generator));
                }
                return false;
            }
            for (Map.Entry entry : this.variables.entrySet()) {
                this.context.set((String)entry.getKey(), ((Generator)entry.getValue()).generate());
            }
            this.variablesInitialized = true;
        }
        return this.entityGenerator.available();
    }

    @Override
    public Entity generate() {
        Entity product;
        if (!this.available()) {
            throw new IllegalGeneratorStateException("Generator is not available");
        }
        Entity entity = product = this.entityGenerator.generate();
        this.variablesInitialized = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generated " + entity));
        }
        ++entityCount;
        return entity;
    }

    @Override
    public void reset() {
        for (Generator<? extends Object> variable : this.variables.values()) {
            variable.reset();
        }
        this.variablesInitialized = false;
        this.entityGenerator.reset();
    }

    @Override
    public void close() {
        for (Generator<? extends Object> variable : this.variables.values()) {
            variable.close();
        }
        this.entityGenerator.close();
        for (String variableName : this.variables.keySet()) {
            this.context.remove(variableName);
        }
    }

    public static long entityCount() {
        return entityCount;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\n" + (this.variables.size() > 0 ? "    variables" + this.variables + "\n" : "") + "    " + this.entityGenerator + "\n" + "]";
    }
}

