/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.composite;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.composite.ComponentBuilder;
import org.databene.benerator.composite.SimpleEntityGenerator;
import org.databene.commons.Context;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityGenerator
implements Generator<Entity> {
    private static final Log stateLogger = LogFactory.getLog((String)"org.databene.benerator.STATE");
    private String entityName;
    private Generator<Entity> source;
    private List<ComponentBuilder> componentBuilders;
    private Context context;
    private Entity currentEntity;

    public EntityGenerator(ComplexTypeDescriptor descriptor, List<ComponentBuilder> componentBuilders, Context context) {
        this(descriptor, new SimpleEntityGenerator(descriptor), componentBuilders, context);
    }

    public EntityGenerator(ComplexTypeDescriptor descriptor, Generator<Entity> source, List<ComponentBuilder> componentBuilders, Context context) {
        this.entityName = descriptor.getName();
        this.source = source;
        this.componentBuilders = componentBuilders;
        this.context = context;
        this.currentEntity = null;
    }

    @Override
    public Class<Entity> getGeneratedType() {
        return Entity.class;
    }

    @Override
    public void validate() {
        this.source.validate();
        for (ComponentBuilder compGen : this.componentBuilders) {
            compGen.validate();
        }
    }

    @Override
    public boolean available() {
        if (this.currentEntity != null) {
            return true;
        }
        if (!this.source.available()) {
            if (stateLogger.isDebugEnabled()) {
                stateLogger.debug((Object)("Source for entity '" + this.entityName + "' is not available any more: " + this.source));
            }
            return false;
        }
        this.currentEntity = this.source.generate();
        this.context.set(this.currentEntity.getName(), (Object)this.currentEntity);
        for (ComponentBuilder compGen : this.componentBuilders) {
            if (compGen.available()) continue;
            if (stateLogger.isDebugEnabled()) {
                stateLogger.debug((Object)("Generator for entity '" + this.entityName + "' is not available any more: " + compGen));
            }
            return false;
        }
        return true;
    }

    @Override
    public Entity generate() {
        for (ComponentBuilder componentBuilder : this.componentBuilders) {
            try {
                componentBuilder.buildComponentFor(this.currentEntity);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure in generation of entity '" + this.entityName + "'", e);
            }
        }
        Entity result = this.currentEntity;
        this.currentEntity = null;
        return result;
    }

    @Override
    public void close() {
        this.source.close();
        for (ComponentBuilder compGen : this.componentBuilders) {
            compGen.close();
        }
    }

    @Override
    public void reset() {
        this.source.reset();
        for (ComponentBuilder compGen : this.componentBuilders) {
            compGen.reset();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.entityName + ']' + this.componentBuilders;
    }
}

