/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.composite;

import org.databene.benerator.Generator;
import org.databene.benerator.wrapper.CardinalGenerator;
import org.databene.commons.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceArrayGenerator<S>
extends CardinalGenerator<S, Object> {
    public InstanceArrayGenerator(Generator<S> source) {
        super(source);
    }

    @Override
    public Class<Object> getGeneratedType() {
        return Object.class;
    }

    @Override
    public Object generate() {
        int count = ((Long)this.countGenerator.generate()).intValue();
        if (count == 0) {
            return new Object[0];
        }
        if (count == 1) {
            return this.source.generate();
        }
        Object[] result = ArrayUtil.newInstance(this.source.getGeneratedType(), (int)count);
        for (int i = 0; i < count; ++i) {
            if (!this.source.available()) {
                return ArrayUtil.copyOfRange((Object[])result, (int)0, (int)i);
            }
            result[i] = this.source.generate();
        }
        return result;
    }
}

