/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.composite;

import org.databene.benerator.Generator;
import org.databene.benerator.composite.ComponentBuilder;
import org.databene.benerator.wrapper.IdGenerator;
import org.databene.model.data.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainComponentBuilder
implements ComponentBuilder {
    private String name;
    private Generator<? extends Object> source;

    public PlainComponentBuilder(String name, Generator<? extends Object> source) {
        this.name = name;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void buildComponentFor(Entity entity) {
        entity.setComponent(this.name, this.source.generate());
    }

    @Override
    public void close() {
        if (!(this.source instanceof IdGenerator)) {
            this.source.close();
        }
    }

    @Override
    public boolean available() {
        return this.source.available();
    }

    @Override
    public void validate() {
        this.source.validate();
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.name + ',' + this.source + ']';
    }
}

