/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.csv;

import java.util.Locale;
import org.databene.benerator.sample.WeightedCSVSampleGenerator;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.LocaleUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.NoOpConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCSVGenerator<E>
extends WeightedCSVSampleGenerator<E> {
    private String baseName;
    private Locale locale;
    private String suffix;

    public LocalCSVGenerator() {
        this(null, null, SystemInfo.getFileEncoding());
    }

    public LocalCSVGenerator(String baseName, String suffix, String encoding) {
        this(baseName, Locale.getDefault(), suffix, encoding);
    }

    public LocalCSVGenerator(String baseName, Locale locale, String suffix, String encoding) {
        this(baseName, locale, suffix, encoding, (Converter<String, E>)NoOpConverter.getInstance());
    }

    public LocalCSVGenerator(String baseName, Locale locale, String suffix, String encoding, Converter<String, E> converter) {
        super(LocalCSVGenerator.availableUri(baseName, locale, suffix), encoding, converter);
        this.baseName = baseName;
        this.locale = locale;
        this.suffix = suffix;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        super.setUrl(LocalCSVGenerator.availableUri(this.baseName, locale, this.suffix));
        this.locale = locale;
    }

    private static String availableUri(String baseName, Locale locale, String suffix) {
        if (baseName == null || suffix == null) {
            return null;
        }
        String uri = LocaleUtil.availableLocaleUrl((String)baseName, (Locale)locale, (String)suffix);
        if (uri == null) {
            throw new ConfigurationError("No localization found for " + baseName + suffix);
        }
        return uri;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.baseName + ',' + this.locale + ',' + this.suffix + ']';
    }
}

