/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.databene.benerator.sample.WeightedSample;
import org.databene.benerator.sample.WeightedSampleGenerator;
import org.databene.benerator.wrapper.GeneratorProxy;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.NoOpConverter;
import org.databene.dataset.DatasetFactory;
import org.databene.document.csv.CSVLineIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedDatasetCSVGenerator<E>
extends GeneratorProxy<E> {
    private String filenamePattern;
    private String datasetName;
    private String nesting;

    public WeightedDatasetCSVGenerator(String filenamePattern, String datasetName, String nesting) {
        this(filenamePattern, ',', datasetName, nesting, SystemInfo.getFileEncoding());
    }

    public WeightedDatasetCSVGenerator(String filenamePattern, char separator, String datasetName, String nesting, String encoding) {
        this(filenamePattern, separator, datasetName, nesting, encoding, (Converter<String, E>)new NoOpConverter());
    }

    public WeightedDatasetCSVGenerator(String filenamePattern, String datasetName, String nesting, String encoding) {
        this(filenamePattern, ',', datasetName, nesting, encoding, (Converter<String, E>)new NoOpConverter());
    }

    public WeightedDatasetCSVGenerator(String filenamePattern, char separator, String datasetName, String nesting, String encoding, Converter<String, E> converter) {
        super(new WeightedSampleGenerator());
        List<WeightedSample<E>> samples = WeightedDatasetCSVGenerator.createSamples(datasetName, separator, nesting, filenamePattern, encoding, converter);
        ((WeightedSampleGenerator)this.source).setSamples(samples);
        this.nesting = nesting;
        this.filenamePattern = filenamePattern;
        this.datasetName = datasetName;
    }

    public String getDataset() {
        return this.datasetName;
    }

    private static <T> List<WeightedSample<T>> createSamples(String datasetName, char separator, String nesting, String filenamePattern, String encoding, Converter<String, T> converter) {
        String[] dataFilenames = nesting == null || datasetName == null ? new String[]{filenamePattern} : DatasetFactory.getDataFiles(filenamePattern, datasetName, nesting);
        ArrayList<WeightedSample<T>> samples = new ArrayList<WeightedSample<T>>();
        for (String dataFilename : dataFilenames) {
            WeightedDatasetCSVGenerator.parse(dataFilename, separator, encoding, converter, samples);
        }
        return samples;
    }

    private static <T> void parse(String filename, char separator, String encoding, Converter<String, T> converter, List<WeightedSample<T>> samples) {
        try {
            CSVLineIterator iterator = new CSVLineIterator(filename, separator, encoding);
            while (iterator.hasNext()) {
                String[] tokens = iterator.next();
                if (tokens.length == 0) continue;
                double weight = tokens.length < 2 ? 1.0 : Double.parseDouble(tokens[1]);
                Object value = converter.convert((Object)tokens[0]);
                WeightedSample<Object> sample = new WeightedSample<Object>(value, weight);
                samples.add(sample);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.filenamePattern + ',' + this.nesting + ':' + this.datasetName + ']';
    }
}

