/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.engine;

import java.util.Locale;
import org.databene.commons.Context;
import org.databene.commons.LocaleUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.bean.ClassCache;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.context.CaseInsensitiveContext;
import org.databene.commons.context.ContextStack;
import org.databene.commons.context.DefaultContext;
import org.databene.commons.context.PropertiesContext;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.script.ScriptUtil;

public class BeneratorContext
extends ContextStack
implements ClassProvider {
    private DefaultContext properties;
    private ClassCache classCache;
    protected String defaultEncoding = SystemInfo.getFileEncoding();
    protected String defaultDataset = LocaleUtil.getDefaultCountryCode();
    protected int defaultPagesize = 1;
    protected boolean defaultNull = true;
    protected char defaultSeparator = (char)44;
    protected String defaultErrorHandler = "fatal";
    protected String contextUri = "./";
    public boolean validate = true;
    public Long maxCount = null;
    protected ComplexTypeDescriptor defaultComponent = new ComplexTypeDescriptor("benerator:defaultComponent");

    public BeneratorContext(String contextUri) {
        super(new Context[0]);
        this.contextUri = contextUri;
        this.validate = !"false".equals(System.getProperty("benerator.validate"));
        this.properties = new DefaultContext();
        this.push((Context)new PropertiesContext(System.getenv()));
        this.push((Context)new PropertiesContext(System.getProperties()));
        this.push((Context)this.properties);
        this.push((Context)new CaseInsensitiveContext(true));
        this.set("benerator", (Object)this);
        this.classCache = new ClassCache();
    }

    public synchronized Object get(String key) {
        for (int i = this.contexts.size() - 1; i >= 0; --i) {
            Object result = ((Context)this.contexts.get(i)).get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        this.properties.set(name, value);
    }

    public Class forName(String className) {
        return this.classCache.forName(className);
    }

    public void importClass(String className) {
        this.classCache.importClass(className);
    }

    public void importPackage(String packageName) {
        this.classCache.importPackage(packageName);
    }

    public void importDefaults() {
        this.importPackage("org.databene.benerator.primitive.datetime");
        this.importPackage("org.databene.platform.flat");
        this.importPackage("org.databene.platform.csv");
        this.importPackage("org.databene.platform.dbunit");
        this.importPackage("org.databene.platform.xls");
        this.importPackage("org.databene.model.consumer");
        this.importPackage("org.databene.benerator.wrapper");
        this.importPackage("org.databene.commons.converter");
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        System.setProperty("file.encoding", defaultEncoding);
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultLineSeparator() {
        return SystemInfo.getLineSeparator();
    }

    public void setDefaultLineSeparator(String defaultLineSeparator) {
        System.setProperty("line.separator", defaultLineSeparator);
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public void setDefaultLocale(Locale defaultLocale) {
        Locale.setDefault(defaultLocale);
    }

    public String getDefaultDataset() {
        return this.defaultDataset;
    }

    public void setDefaultDataset(String defaultDataset) {
        this.defaultDataset = defaultDataset;
    }

    public int getDefaultPagesize() {
        return this.defaultPagesize;
    }

    public void setDefaultPagesize(int defaultPagesize) {
        this.defaultPagesize = defaultPagesize;
    }

    public String getDefaultScript() {
        return ScriptUtil.getDefaultScriptEngine();
    }

    public void setDefaultScript(String defaultScript) {
        ScriptUtil.setDefaultScriptEngine((String)defaultScript);
    }

    public boolean isDefaultNull() {
        return this.defaultNull;
    }

    public void setDefaultNull(boolean defaultNull) {
        this.defaultNull = defaultNull;
    }

    public char getDefaultSeparator() {
        return this.defaultSeparator;
    }

    public void setDefaultSeparator(char defaultSeparator) {
        this.defaultSeparator = defaultSeparator;
    }

    public ComponentDescriptor getDefaultComponentConfig(String name) {
        return this.defaultComponent.getComponent(name);
    }

    public void setDefaultComponentConfig(ComponentDescriptor component) {
        this.defaultComponent.addComponent(component);
    }

    public String getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public void setDefaultErrorHandler(String defaultErrorHandler) {
        this.defaultErrorHandler = defaultErrorHandler;
    }

    public String getContextUri() {
        return this.contextUri;
    }

    public void setContextUri(String contextUri) {
        this.contextUri = contextUri;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public Long getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Long maxCount) {
        this.maxCount = maxCount;
    }
}

