/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.engine;

import java.util.List;
import org.databene.benerator.Generator;
import org.databene.benerator.engine.PagedCreateEntityTask;
import org.databene.commons.ErrorHandler;
import org.databene.model.consumer.Consumer;
import org.databene.model.data.Entity;
import org.databene.task.AbstractTask;
import org.databene.task.Task;
import org.databene.task.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateEntityTask
extends AbstractTask
implements ThreadSafe {
    private Generator<Entity> generator;
    private Consumer<Entity> consumer;
    private List<? extends Task> subTasks;
    private boolean isSubTask;

    public CreateEntityTask(String taskName, Generator<Entity> generator, Consumer<Entity> consumer, List<? extends Task> subTasks, boolean isSubTask, ErrorHandler errorHandler) {
        super(taskName, errorHandler);
        this.generator = generator;
        this.consumer = consumer;
        this.subTasks = subTasks;
        this.isSubTask = isSubTask;
    }

    @Override
    public boolean wantsToRun() {
        return this.generator.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Entity entity = null;
            Generator<Entity> generator = this.generator;
            synchronized (generator) {
                if (!this.generator.available()) {
                    return;
                }
                entity = this.generator.generate();
            }
            if (entity != null) {
                this.context.set(entity.getName(), (Object)entity);
                this.consumer.startConsuming(entity);
                for (Task task : this.subTasks) {
                    if (task instanceof PagedCreateEntityTask) {
                        ((PagedCreateEntityTask)task).reset();
                    }
                    task.init(this.context);
                    task.run();
                    task.destroy();
                }
                this.consumer.finishConsuming(entity);
            }
        }
        catch (Exception e) {
            this.errorHandler.handleError("Error in execution of task " + this.getTaskName(), (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        if (!this.isSubTask) {
            this.consumer.flush();
        }
        super.destroy();
    }
}

