/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.composite.ConfiguredEntityGenerator;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.engine.PagedCreateEntityTask;
import org.databene.benerator.factory.DescriptorUtil;
import org.databene.benerator.factory.InstanceGeneratorFactory;
import org.databene.benerator.parser.BasicParser;
import org.databene.benerator.parser.ModelParser;
import org.databene.benerator.parser.xml.XmlDescriptorParser;
import org.databene.commons.Assert;
import org.databene.commons.BeanUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.ErrorHandler;
import org.databene.commons.Escalator;
import org.databene.commons.Heavyweight;
import org.databene.commons.IOUtil;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.RoundedNumberFormat;
import org.databene.commons.ShellUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.converter.LiteralParser;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.db.DBUtil;
import org.databene.commons.mutator.AnyMutator;
import org.databene.commons.xml.XMLElement2BeanConverter;
import org.databene.commons.xml.XMLUtil;
import org.databene.model.consumer.Consumer;
import org.databene.model.consumer.ConsumerChain;
import org.databene.model.consumer.FileExporter;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.DataModel;
import org.databene.model.data.DescriptorProvider;
import org.databene.model.data.Entity;
import org.databene.model.data.InstanceDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.model.storage.StorageSystem;
import org.databene.model.storage.StorageSystemConsumer;
import org.databene.platform.db.DBSystem;
import org.databene.script.Script;
import org.databene.script.ScriptConverter;
import org.databene.script.ScriptUtil;
import org.databene.script.jsr227.Jsr223ScriptFactory;
import org.databene.task.PageListener;
import org.databene.task.Task;
import org.databene.task.TaskException;
import org.databene.task.TaskRunner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorRunner {
    public static final String LOCALE_VM_PARAM = "benerator.locale";
    private static final String UPDATE_ENTITIES = "update-entities";
    private static final String CREATE_ENTITIES = "create-entities";
    private static final Collection<String> COMPONENT_TYPES = CollectionUtil.toSet((Object[])new String[]{"attribute", "part", "id", "reference"});
    private static final Collection<String> CREATE_ENTITIES_EXT_SETUP = CollectionUtil.toSet((Object[])new String[]{"pagesize", "threads", "consumer", "onError"});
    private static final Log logger = LogFactory.getLog(DescriptorRunner.class);
    private static final Log commentLogger = LogFactory.getLog((String)"org.databene.COMMENT");
    private ModelParser parser;
    private String uri;
    private ExecutorService executor;
    private Escalator escalator;
    private Set<Heavyweight> resources = new HashSet<Heavyweight>();
    private BeneratorContext context;
    private Map<String, Object> beans;
    private DataModel dataModel = DataModel.getDefaultInstance();
    private BasicParser basicParser;
    private List<String> generatedFiles;

    public DescriptorRunner(String uri) {
        this.uri = uri;
        this.context = new BeneratorContext(".");
        this.executor = Executors.newCachedThreadPool();
        this.escalator = new LoggerEscalator();
        this.basicParser = new BasicParser();
        this.beans = new HashMap<String, Object>();
        this.generatedFiles = new ArrayList<String>();
    }

    public BeneratorContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            this.generatedFiles = new ArrayList<String>();
            this.context.setContextUri(IOUtil.getContextUri((String)this.uri));
            this.parser = new ModelParser(this.context);
            long startTime = System.currentTimeMillis();
            Document document = XMLUtil.parse((String)this.uri, (boolean)this.context.isValidate());
            Element root = document.getDocumentElement();
            XMLUtil.mapAttributesToProperties((Element)root, (Object)((Object)this.context), (boolean)false);
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                this.parseRootChild((Element)node);
            }
            for (Heavyweight resource : this.resources) {
                resource.close();
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.info((Object)("Created a total of " + ConfiguredEntityGenerator.entityCount() + " entities " + "in " + elapsedTime + " ms " + "(~" + RoundedNumberFormat.format((Number)(ConfiguredEntityGenerator.entityCount() * 3600000L / elapsedTime), (int)0) + " p.h.)"));
            List<String> generations = this.getGeneratedFiles();
            if (generations.size() > 0) {
                logger.info((Object)("Generated file(s): " + generations));
            }
        }
        finally {
            this.executor.shutdownNow();
        }
    }

    public List<String> getGeneratedFiles() {
        return this.generatedFiles;
    }

    private void parseRootChild(Element element) {
        String elementType = element.getNodeName();
        if ("bean".equals(elementType)) {
            this.parseBean(element);
        } else if (CREATE_ENTITIES.equals(elementType) || UPDATE_ENTITIES.equals(elementType)) {
            this.parseAndRunEntityTask(element);
        } else if ("run-task".equals(elementType)) {
            this.parseRunTask(element);
        } else if ("property".equals(elementType)) {
            this.parseProperty(element);
        } else if ("include".equals(elementType)) {
            this.parser.parseInclude(element);
        } else if ("import".equals(elementType)) {
            this.parser.parseImport(element);
        } else if ("echo".equals(elementType)) {
            this.parseEcho(element);
        } else if ("database".equals(elementType)) {
            this.parseDatabase(element);
        } else if ("execute".equals(elementType)) {
            this.parseExecute(element);
        } else if ("evaluate".equals(elementType)) {
            this.parseEvaluate(element);
        } else if ("defaultComponents".equals(elementType)) {
            this.parseDefaultComponents(element);
        } else if ("comment".equals(elementType)) {
            this.parseComment(element);
        } else {
            throw new ConfigurationError("Unknown element: " + elementType);
        }
    }

    private void parseComment(Element element) {
        commentLogger.debug((Object)XMLUtil.getText((Node)element));
    }

    private void parseProperty(Element element) {
        Object propertyValue;
        String propertyName = element.getAttribute("name");
        if (element.hasAttribute("value")) {
            propertyValue = LiteralParser.parse((String)XmlDescriptorParser.parseStringAttribute(element, "value", (Context)this.context));
        } else if (element.hasAttribute("ref")) {
            propertyValue = this.context.get(XmlDescriptorParser.parseStringAttribute(element, "ref", (Context)this.context));
        } else {
            throw new ConfigurationError("Syntax error");
        }
        if (propertyName.startsWith("benerator.")) {
            AnyMutator.setValue((Object)((Object)this.context), (String)propertyName, (Object)propertyValue, (boolean)true);
        } else {
            this.context.setProperty(propertyName, propertyValue);
        }
    }

    private void parseEcho(Element element) {
        String message = XmlDescriptorParser.parseStringAttribute(element, "message", (Context)this.context);
        System.out.println(ScriptUtil.render((String)message, (Context)this.context));
    }

    private Object parseBean(Element element) {
        try {
            Object bean = this.parser.parseBean(element);
            if (bean instanceof DescriptorProvider) {
                this.dataModel.addDescriptorProvider((DescriptorProvider)bean);
            }
            if (bean instanceof Heavyweight) {
                this.addResource((Heavyweight)bean);
            }
            if (BeanUtil.hasProperty(bean.getClass(), (String)"id")) {
                Object id = BeanUtil.getPropertyValue((Object)bean, (String)"id");
                this.beans.put(String.valueOf(id), bean);
            }
            return bean;
        }
        catch (ConversionException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    boolean addResource(Heavyweight resource) {
        if (this.resources.contains(resource)) {
            return false;
        }
        if (resource instanceof FileExporter) {
            this.generatedFiles.add(((FileExporter)resource).getUri());
        }
        return this.resources.add(resource);
    }

    private void parseDatabase(Element element) {
        try {
            String id = XmlDescriptorParser.parseStringAttribute(element, "id", (Context)this.context);
            if (id == null) {
                throw new ConfigurationError();
            }
            logger.debug((Object)("Instantiating database with id '" + id + "'"));
            DBSystem db = new DBSystem(id, XmlDescriptorParser.parseStringAttribute(element, "url", (Context)this.context), XmlDescriptorParser.parseStringAttribute(element, "driver", (Context)this.context), XmlDescriptorParser.parseStringAttribute(element, "user", (Context)this.context), XmlDescriptorParser.parseStringAttribute(element, "password", (Context)this.context));
            db.setSchema(XmlDescriptorParser.parseStringAttribute(element, "schema", (Context)this.context));
            db.setBatch(XmlDescriptorParser.parseBooleanAttribute(element, "batch", (Context)this.context, false));
            db.setFetchSize(XmlDescriptorParser.parseIntAttribute(element, "fetchSize", (Context)this.context, 100));
            db.setBatch(XmlDescriptorParser.parseBooleanAttribute(element, "readOnly", (Context)this.context, false));
            this.context.set(id, db);
            this.beans.put(id, db);
            this.dataModel.addDescriptorProvider(db, this.context.isValidate());
            this.addResource(db);
        }
        catch (ConversionException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    private void parseExecute(Element element) {
        this.parseEvaluate(element);
    }

    private Object parseEvaluate(Element element) {
        try {
            String id;
            String uri = XmlDescriptorParser.parseStringAttribute(element, "uri", (Context)this.context);
            String target = XmlDescriptorParser.parseStringAttribute(element, "target", (Context)this.context);
            Object targetObject = this.context.get(target);
            String onError = XmlDescriptorParser.parseStringAttribute(element, "onError", (Context)this.context);
            if (StringUtil.isEmpty((String)onError)) {
                onError = "fatal";
            }
            String encoding = XmlDescriptorParser.parseStringAttribute(element, "encoding", (Context)this.context);
            boolean optimize = XmlDescriptorParser.parseBooleanAttribute(element, "optimize", (Context)this.context, false);
            String type = XmlDescriptorParser.parseStringAttribute(element, "type", (Context)this.context);
            if (type == null && uri != null) {
                String lcUri = uri.toLowerCase();
                if (lcUri.endsWith(".sql")) {
                    type = "sql";
                }
                if (lcUri.endsWith(".bat") || lcUri.endsWith(".sh")) {
                    type = "shell";
                }
                if (lcUri.endsWith(".jar")) {
                    type = "jar";
                }
                if (lcUri.endsWith(".js")) {
                    type = "js";
                }
                uri = IOUtil.resolveLocalUri((String)uri, (String)this.context.getContextUri());
            }
            if (type == null && targetObject instanceof DBSystem) {
                type = "sql";
            }
            ErrorHandler errorHandler = new ErrorHandler(this.getClass().getName(), ErrorHandler.Level.valueOf((String)onError));
            Object result = null;
            String text = XMLUtil.getText((Node)element);
            if ("sql".equals(type)) {
                result = this.runSqlTask(uri, targetObject, onError, encoding, text, optimize);
            } else if ("shell".equals(type)) {
                if (!StringUtil.isEmpty((String)uri)) {
                    text = IOUtil.getContentOfURI((String)uri);
                }
                text = String.valueOf(ScriptUtil.render((String)text, (Context)this.context));
                result = this.runShell(null, text, onError);
            } else {
                if (StringUtil.isEmpty((String)type)) {
                    throw new ConfigurationError("script type is not defined");
                }
                if (!StringUtil.isEmpty((String)uri)) {
                    text = IOUtil.getContentOfURI((String)uri);
                }
                result = this.runScript(text, type, onError);
            }
            this.context.set("result", result);
            Object assertion = XmlDescriptorParser.parseAttribute(element, "assert", (Context)this.context);
            String resultAsString = ToStringConverter.convert((Object)result, null);
            if (!(assertion == null || assertion instanceof String && ((String)assertion).length() == 0)) {
                if (assertion instanceof Boolean) {
                    if (!((Boolean)assertion).booleanValue()) {
                        errorHandler.handleError("Assertion failed: '" + element.getAttribute("assert") + "'");
                    }
                } else if (!assertion.equals(resultAsString)) {
                    errorHandler.handleError("Assertion failed. Expected: '" + assertion + "', found: '" + resultAsString + "'");
                }
            }
            if ((id = XmlDescriptorParser.parseStringAttribute(element, "id", (Context)this.context)) != null) {
                this.context.set(id, result);
            }
            return result;
        }
        catch (ConversionException e) {
            throw new ConfigurationError((Throwable)e);
        }
        catch (IOException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    private Object runScript(String text, String type, String onError) {
        ErrorHandler errorHandler = new ErrorHandler(this.getClass().getName(), ErrorHandler.Level.valueOf((String)onError));
        try {
            Script script = Jsr223ScriptFactory.parseText((String)text, (String)type);
            return script.evaluate((Context)this.context);
        }
        catch (Exception e) {
            errorHandler.handleError("Error in script evaluation", (Throwable)e);
            return null;
        }
    }

    private int runShell(String uri, String text, String onError) {
        ErrorHandler errorHandler = new ErrorHandler(this.getClass().getName(), ErrorHandler.Level.valueOf((String)onError));
        if (text != null) {
            return ShellUtil.runShellCommands((ReaderLineIterator)new ReaderLineIterator((Reader)new StringReader(text)), (ErrorHandler)errorHandler);
        }
        if (uri != null) {
            try {
                return ShellUtil.runShellCommands((ReaderLineIterator)new ReaderLineIterator((Reader)IOUtil.getReaderForURI((String)uri)), (ErrorHandler)errorHandler);
            }
            catch (IOException e) {
                errorHandler.handleError("Error in shell invocation", (Throwable)e);
                return 1;
            }
        }
        throw new ConfigurationError("At least uri or text must be provided in <execute>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runSqlTask(String uri, Object targetObject, String onError, String encoding, String text, boolean optimize) {
        if (targetObject == null) {
            throw new ConfigurationError("Please specify the 'target' database to execute the SQL script");
        }
        Assert.instanceOf((Object)targetObject, DBSystem.class, (String)"target");
        DBSystem db = (DBSystem)targetObject;
        if (uri != null) {
            logger.info((Object)("Executing script " + uri));
        } else if (text != null) {
            logger.info((Object)"Executing inline script");
        } else {
            throw new TaskException("No uri or content");
        }
        Connection connection = null;
        Object result = null;
        ErrorHandler errorHandler = new ErrorHandler("org.databene.SQL", ErrorHandler.Level.valueOf((String)onError));
        try {
            connection = db.createConnection();
            result = text != null ? DBUtil.runScript((String)text, (Connection)connection, (boolean)optimize, (ErrorHandler)errorHandler) : DBUtil.runScript((String)uri, (String)encoding, (Connection)connection, (boolean)optimize, (ErrorHandler)errorHandler);
            db.invalidate();
            connection.commit();
        }
        catch (Exception sqle) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            errorHandler.handleError("Error in SQL script execution", (Throwable)sqle);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        return result;
    }

    private void parseDefaultComponents(Element element) {
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childType = XMLUtil.localName((Element)child);
            if (!COMPONENT_TYPES.contains(childType)) {
                throw new ConfigurationError("Unexpected element: " + childType);
            }
            ComponentDescriptor component = this.parser.parseSimpleTypeComponent(child, null);
            this.context.setDefaultComponentConfig(component);
        }
    }

    private void parseRunTask(Element element) {
        try {
            String beanName = XmlDescriptorParser.parseStringAttribute(element, "name", (Context)this.context);
            logger.debug((Object)("Instantiating task '" + beanName + "'"));
            ScriptConverter scriptConverter = new ScriptConverter((Context)this.context);
            Task task = (Task)XMLElement2BeanConverter.convert((Element)element, (Context)this.context, (Converter)scriptConverter);
            int count = XmlDescriptorParser.parseIntAttribute(element, "count", (Context)this.context, 1);
            int pageSize = XmlDescriptorParser.parseIntAttribute(element, "pagesize", (Context)this.context, this.context.getDefaultPagesize());
            int threads = XmlDescriptorParser.parseIntAttribute(element, "threads", (Context)this.context, 1);
            PageListener pager = this.parsePager(element);
            TaskRunner.run(task, (Context)this.context, count, pager, pageSize, threads, this.executor);
        }
        catch (ConversionException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    private PageListener parsePager(Element element) {
        String pagerSetup = XmlDescriptorParser.parseStringAttribute(element, "pager", (Context)this.context);
        if (StringUtil.isEmpty((String)pagerSetup)) {
            return null;
        }
        PageListener pager = null;
        try {
            pager = (PageListener)this.basicParser.resolveConstructionOrReference(pagerSetup, (ClassProvider)this.context, (Context)this.context);
        }
        catch (Exception e) {
            pager = (PageListener)this.context.get(pagerSetup);
        }
        if (pager == null) {
            throw new ConfigurationError("pager=\"" + pagerSetup + "\" neither denotes a class nor an object in the context.");
        }
        return pager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndRunEntityTask(Element element) {
        PagedCreateEntityTask task = this.parseCreateEntities(element, false);
        long t0 = System.currentTimeMillis();
        long count0 = ConfiguredEntityGenerator.entityCount();
        task.init((Context)this.context);
        try {
            task.run();
        }
        finally {
            task.destroy();
        }
        long dc = ConfiguredEntityGenerator.entityCount() - count0;
        long dt = System.currentTimeMillis() - t0;
        String taskId = task.getTaskName();
        if (dc == 0L) {
            logger.info((Object)("No entities created from '" + taskId + "' setup"));
        } else if (dt > 0L) {
            logger.info((Object)("Created " + dc + " entities from '" + taskId + "' setup in " + dt + " ms (" + dc * 1000L / dt + "/s)"));
        } else {
            logger.info((Object)("Created " + dc + " entities from '" + taskId));
        }
    }

    public PagedCreateEntityTask parseCreateEntities(Element element, boolean isSubTask) {
        InstanceDescriptor descriptor = this.mapEntityDescriptorElement(element, this.context);
        descriptor.setNullable(false);
        ErrorHandler errorHandler = this.parseOnError(element, this.getClass().getName());
        if (!isSubTask) {
            logger.info((Object)descriptor);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)descriptor);
        }
        ConsumerChain<Entity> consumerChain = this.parseConsumers(element, CREATE_ENTITIES.equals(element.getNodeName()));
        if (UPDATE_ENTITIES.equals(element.getNodeName())) {
            String sourceName = XmlDescriptorParser.parseStringAttribute(element, "source", (Context)this.context);
            Object source = this.context.get(sourceName);
            if (!(source instanceof StorageSystem)) {
                throw new ConfigurationError("The source of an <update-entities> element must be a StorageSystem. '" + sourceName + "' is not");
            }
            consumerChain.addComponent(new StorageSystemConsumer((StorageSystem)source, false));
        }
        Generator<? extends Object> configuredGenerator = InstanceGeneratorFactory.createInstanceGenerator(descriptor, this.context);
        ArrayList<PagedCreateEntityTask> subs = new ArrayList<PagedCreateEntityTask>();
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String nodeName = child.getNodeName();
            if (!CREATE_ENTITIES.equals(nodeName) && !UPDATE_ENTITIES.equals(nodeName)) continue;
            subs.add(this.parseCreateEntities(child, true));
        }
        long minCount = DescriptorUtil.getMinCount(descriptor, this.context);
        Long maxCount = DescriptorUtil.getMaxCount(descriptor, this.context);
        int pageSize = XmlDescriptorParser.parseIntAttribute(element, "pagesize", (Context)this.context, this.context.getDefaultPagesize());
        int threads = XmlDescriptorParser.parseIntAttribute(element, "threads", (Context)this.context, 1);
        String taskName = descriptor.getName();
        if (taskName == null) {
            taskName = descriptor.getLocalType().getSource();
        }
        long limit = maxCount != null ? maxCount : -1L;
        return new PagedCreateEntityTask(taskName, limit, pageSize, threads, subs, configuredGenerator, consumerChain, this.executor, isSubTask, errorHandler);
    }

    private ConsumerChain<Entity> parseConsumers(Element parent, boolean consumersExpected) {
        String entityName = XmlDescriptorParser.parseStringAttribute(parent, "name", (Context)this.context);
        ConsumerChain<Object> consumerChain = new ConsumerChain(new Consumer[0]);
        if (parent.hasAttribute("consumer")) {
            String consumerSpec = XmlDescriptorParser.parseStringAttribute(parent, "consumer", (Context)this.context);
            consumerChain = DescriptorUtil.parseConsumersSpec(consumerSpec, this.context);
        }
        Element[] consumerElements = XMLUtil.getChildElements((Element)parent, (boolean)true, (String)"consumer");
        for (int i = 0; i < consumerElements.length; ++i) {
            Element consumerElement = consumerElements[i];
            if (consumerElement.hasAttribute("ref")) {
                String consumerSpec = XmlDescriptorParser.parseStringAttribute(consumerElement, "ref", (Context)this.context);
                consumerChain.addComponent(DescriptorUtil.parseConsumersSpec(consumerSpec, this.context));
                continue;
            }
            if (consumerElement.hasAttribute("class")) {
                consumerChain.addComponent((Consumer)this.parseBean(consumerElement));
                continue;
            }
            throw new UnsupportedOperationException("Don't know how to handle " + XMLUtil.format((Element)consumerElement));
        }
        for (Consumer<Object> consumer : consumerChain.getComponents()) {
            this.addResource(consumer);
        }
        if (consumerChain.componentCount() == 0 && consumersExpected) {
            this.escalator.escalate("No consumers defined for " + entityName, (Object)this, null);
        }
        return consumerChain;
    }

    private InstanceDescriptor mapEntityDescriptorElement(Element element, BeneratorContext context) {
        ComplexTypeDescriptor localType;
        String entityName = XmlDescriptorParser.parseStringAttribute(element, "name", (Context)context);
        TypeDescriptor parentType = this.dataModel.getTypeDescriptor(entityName);
        if (parentType != null) {
            entityName = parentType.getName();
            localType = new ComplexTypeDescriptor(parentType.getName(), (ComplexTypeDescriptor)parentType);
        } else {
            localType = new ComplexTypeDescriptor(entityName, "entity");
        }
        InstanceDescriptor instance = new InstanceDescriptor(entityName, entityName);
        instance.setLocalType(localType);
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeName = attribute.getName();
            if (CREATE_ENTITIES_EXT_SETUP.contains(attributeName)) continue;
            Object attributeValue = XmlDescriptorParser.parseAttribute(attribute, (Context)context);
            if (instance.supportsDetail(attributeName)) {
                instance.setDetailValue(attributeName, attributeValue);
                continue;
            }
            if (localType == null) continue;
            localType.setDetailValue(attributeName, attributeValue);
        }
        for (Element child : XMLUtil.getChildElements((Element)element)) {
            String childType = XMLUtil.localName((Element)child);
            if ("variable".equals(childType)) {
                this.parser.parseVariable(child, localType);
                continue;
            }
            if (COMPONENT_TYPES.contains(childType)) {
                ComponentDescriptor component = this.parser.parseSimpleTypeComponent(child, localType);
                ((ComplexTypeDescriptor)instance.getType()).addComponent(component);
                continue;
            }
            if (CREATE_ENTITIES.equals(childType) || "consumer".equals(childType) || "variable".equals(childType)) continue;
            throw new ConfigurationError("Unexpected element: " + childType);
        }
        return instance;
    }

    private ErrorHandler parseOnError(Element element, String category) {
        String levelName = XmlDescriptorParser.parseStringAttribute(element, "onError", (Context)this.context);
        if (levelName == null) {
            levelName = this.context.getDefaultErrorHandler();
        }
        ErrorHandler.Level level = ErrorHandler.Level.valueOf((String)levelName);
        return new ErrorHandler(category, level);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

