/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.engine;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.databene.benerator.Generator;
import org.databene.benerator.engine.CreateEntityTask;
import org.databene.commons.ErrorHandler;
import org.databene.model.consumer.Consumer;
import org.databene.model.data.Entity;
import org.databene.task.PagedTask;
import org.databene.task.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedCreateEntityTask
extends PagedTask {
    private Generator<Entity> generator;
    private Consumer<Entity> consumer;

    public PagedCreateEntityTask(String taskName, long count, int pageSize, int threads, List<? extends Task> subTasks, Generator<Entity> generator, Consumer<Entity> consumer, ExecutorService executor, boolean isSubTask, ErrorHandler errorHandler) {
        super(new CreateEntityTask(taskName, generator, consumer, subTasks, isSubTask, errorHandler), count, null, pageSize, threads, executor);
        this.generator = generator;
        this.consumer = consumer;
    }

    @Override
    public void pageFinished(int currentPageNo) {
        this.consumer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        super.destroy();
        Generator<Entity> generator = this.generator;
        synchronized (generator) {
            this.generator.close();
        }
    }

    @Override
    protected boolean workPending(int currentPageNo) {
        return this.generator.available();
    }

    public void reset() {
        this.generator.reset();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.realTask + ']';
    }
}

